/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core;

import com.sun.javafx.eclipse.core.builder.classpath.ClassPath;
import com.sun.javafx.eclipse.core.classpath.SDKClasspathContainer;
import com.sun.javafx.eclipse.core.preferences.PreferenceConstants;
import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFXProject {
    private static WeakHashMap<IProject, JavaFXProject> mapping = new WeakHashMap();
    private IProject project;
    private IPersistentPreferenceStore preferenceStore;

    public JavaFXProject(IProject project) {
        this.project = project;
        this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "com.sun.javafx.eclipse.core.preferences");
        PreferenceConstants.initializeProjectPreferences(this.preferenceStore);
    }

    public IPersistentPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public IJavaProject getJavaProject() {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        return javaProject != null && javaProject.exists() ? javaProject : null;
    }

    public Map<String, String> resolvePropertiesFromPreferences() {
        String sdkPath = JavaFXSDK.getSDKPathFromPreferences();
        String profile = this.getProfileFromPreferences();
        if (!JavaFXSDK.isValidProfileFromPreferences(profile)) {
            profile = "desktop";
        }
        return JavaFXSDK.getProfileProperties(sdkPath, profile);
    }

    public List<IFile> getSourcePath() {
        IClasspathEntry[] entries;
        try {
            entries = this.getJavaProject().getRawClasspath();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        ArrayList<IFile> sourcePath = new ArrayList<IFile>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            int entryKind = entry.getEntryKind();
            if (entryKind == 3) {
                sourcePath.add(this.project.getWorkspace().getRoot().getFile(entry.getPath()));
            }
            ++n2;
        }
        return sourcePath;
    }

    public List<IResource> getLibraryPath() {
        IClasspathEntry[] entries;
        try {
            entries = this.getJavaProject().getRawClasspath();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        ArrayList<IResource> libraryPath = new ArrayList<IResource>();
        this.addFromEntries(libraryPath, entries, false);
        return libraryPath;
    }

    private void addFromEntries(List<IResource> libraryPath, IClasspathEntry[] entries, boolean inside) {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (!inside || entry.isExported()) {
                int entryKind = entry.getEntryKind();
                switch (entryKind) {
                    case 1: {
                        libraryPath.add((IResource)this.project.getWorkspace().getRoot().getFile(entry.getPath()));
                        break;
                    }
                    case 5: {
                        if (inside || JavaRuntime.JRE_CONTAINER.equals(entry.getPath()) || SDKClasspathContainer.CONTAINER_ID.equals((Object)entry.getPath())) break;
                        IClasspathContainer container = null;
                        try {
                            container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.getJavaProject());
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                        if (container == null) break;
                        this.addFromEntries(libraryPath, container.getClasspathEntries(), true);
                        break;
                    }
                    case 2: {
                        if (inside) break;
                        IProject otherP = this.project.getWorkspace().getRoot().getProject(entry.getPath().segment(0));
                        IJavaProject otherJavaProject = JavaCore.create((IProject)otherP);
                        IPath outputPath = null;
                        try {
                            IClasspathEntry[] entries2 = otherJavaProject.getRawClasspath();
                            this.addFromEntries(libraryPath, entries2, true);
                            outputPath = otherJavaProject.getOutputLocation();
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                        IResource outputFile = ClassPath.pathToFile(outputPath);
                        if (outputFile == null) break;
                        libraryPath.add(outputFile);
                    }
                }
            }
            ++n2;
        }
    }

    public static String fileListToOSPath(List<? extends IResource> fileList, String pathSeparator) {
        if (fileList.isEmpty()) {
            return "";
        }
        Iterator<? extends IResource> iter = fileList.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(JavaFXProject.fileToOSPath(iter.next()));
        while (iter.hasNext()) {
            buffer.append(pathSeparator).append(JavaFXProject.fileToOSPath(iter.next()));
        }
        return buffer.toString();
    }

    public static String fileToOSPath(IResource resource) {
        IPath path = resource.getLocation();
        if (path == null) {
            path = resource.getFullPath();
        }
        return path.toOSString();
    }

    public static String fileToUnixPath(IResource resource) {
        IPath path = resource.getLocation();
        if (path == null) {
            path = resource.getFullPath();
        }
        return path.toString();
    }

    public String getProfileFromPreferences() {
        return this.preferenceStore.getString("JavaFXSDKProfile");
    }

    public static JavaFXProject create(IProject project) {
        JavaFXProject javafxProject = mapping.get(project);
        if (javafxProject == null && JavaFXProject.getValidJavaProject(project) != null) {
            javafxProject = new JavaFXProject(project);
            mapping.put(project, javafxProject);
        }
        return javafxProject;
    }

    public void excludeFXFilesFromOutput() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            throw new IllegalStateException("Cannot operate on non-java project " + this.project);
        }
        String excludedResources = javaProject.getOption("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", true);
        if (excludedResources.indexOf("*.fx") == -1) {
            excludedResources = excludedResources.length() == 0 ? "*.fx" : String.valueOf(excludedResources) + ",*.fx";
            javaProject.setOption("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", excludedResources);
        }
    }

    private static IJavaProject getValidJavaProject(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject != null && javaProject.exists() ? javaProject : null;
    }
}

