/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core;

import com.sun.javafx.eclipse.core.JavaFXProject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUISupport {
    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    public static IJavaProject chooseJavaProject(Shell shell, IJavaProject initialJavaProject) {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle("Select Java Project");
        dialog.setElements(projects);
        if (initialJavaProject != null) {
            dialog.setInitialSelections(new Object[]{initialJavaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    public static String getJavaProjectName(IJavaProject javaProject) {
        return javaProject != null && javaProject.exists() ? javaProject.getElementName() : null;
    }

    public static IJavaElement getActiveJavaElement() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IJavaElement element = JavaUISupport.getActiveJavaElementFromSelection(page.getSelection());
        if (element != null) {
            return element;
        }
        return JavaUISupport.getActiveJavaElementFromEditorPart(page.getActiveEditor());
    }

    public static void getActiveFXContentFromSelection(ISelection selection, IJavaProject[] javaProject, String[] className) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.isEmpty()) {
            return;
        }
        JavaUISupport.getActiveFXContentFromObject(structuredSelection.getFirstElement(), javaProject, className);
    }

    public static void getActiveFXContentFromObject(Object object, IJavaProject[] javaProject, String[] className) {
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if ("fx".equalsIgnoreCase(resource.getFileExtension())) {
                JavaFXProject javafxProject = JavaFXProject.create(resource.getProject());
                if (javafxProject != null) {
                    javaProject[0] = javafxProject.getJavaProject();
                    String foundClassName = JavaUISupport.findClassName(javafxProject.getSourcePath(), resource);
                    if (foundClassName != null) {
                        className[0] = foundClassName;
                    }
                }
            } else {
                IJavaElement element = JavaCore.create((IResource)resource);
                if (element == null) {
                    IProject pro = resource.getProject();
                    element = JavaCore.create((IProject)pro);
                }
                if (element != null) {
                    javaProject[0] = element.getJavaProject();
                }
            }
        } else if (object instanceof IJavaElement) {
            IJavaElement element = (IJavaElement)object;
            javaProject[0] = element.getJavaProject();
        }
    }

    private static String findClassName(List<IFile> sourcePath, IResource resource) {
        String child = JavaFXProject.fileToUnixPath(resource);
        if (child != null) {
            for (IFile source : sourcePath) {
                int i;
                String parent = JavaFXProject.fileToUnixPath((IResource)source);
                if (parent == null || !child.startsWith(parent)) continue;
                String className = child.substring(parent.length());
                if (className.startsWith("/")) {
                    className = className.substring(1);
                }
                if ((i = className.lastIndexOf(46)) >= 0) {
                    className = className.substring(0, i);
                }
                className = className.replace('/', '.');
                return className;
            }
        }
        return null;
    }

    public static IJavaElement getActiveJavaElementFromSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            Object obj = structuredSelection.getFirstElement();
            if (obj instanceof IJavaElement) {
                return (IJavaElement)obj;
            }
            if (obj instanceof IResource) {
                IJavaElement je = JavaCore.create((IResource)((IResource)obj));
                if (je == null) {
                    IProject pro = ((IResource)obj).getProject();
                    je = JavaCore.create((IProject)pro);
                }
                if (je != null) {
                    return je;
                }
            }
        }
        return null;
    }

    public static IJavaElement getActiveJavaElementFromEditorPart(IEditorPart part) {
        if (part != null) {
            IEditorInput input = part.getEditorInput();
            return (IJavaElement)input.getAdapter(IJavaElement.class);
        }
        return null;
    }
}

