/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class Logger {
    private Level maxTraceLevel = Level.ERROR;
    private static final Logger instance = new Logger();
    public static final String DEBUG_FLAG = "/debug";
    private static final int SEVERITY_MASK_LOG_ALWAYS = 4;

    private Logger() {
    }

    public static Logger getInstance() {
        return instance;
    }

    public void log(Plugin plugin, IStatus status) {
        this.log(plugin, status, null);
    }

    public void log(Plugin plugin, IStatus status, String customMessage) {
        if (status == null || plugin == null) {
            return;
        }
        if (status.matches(4)) {
            this.logImpl(plugin.getLog(), status, customMessage);
        } else if (Platform.inDebugMode() && Boolean.valueOf(Platform.getDebugOption((String)(String.valueOf(plugin.getBundle().getSymbolicName()) + DEBUG_FLAG))).booleanValue()) {
            this.logImpl(plugin.getLog(), status, customMessage);
            Level level = Logger.getLevel(status);
            if (customMessage != null) {
                this.traceImpl(level, customMessage, null);
            }
            this.traceImpl(level, status.getMessage(), status.getException());
        }
    }

    public static Level getLevel(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                return Level.INFO;
            }
            case 4: {
                return Level.ERROR;
            }
            case 8: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARNING;
            }
            case 0: {
                return Level.INFO;
            }
        }
        return Level.DEBUG;
    }

    private void logImpl(ILog log, IStatus status, String customMessage) {
        IStatus report = status;
        if (customMessage != null && customMessage.length() != 0) {
            report = new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, customMessage, null);
        }
        log.log(report);
    }

    public void trace(Plugin plugin, String message, Throwable throwable) {
        this.trace(plugin, Level.INFO, message, throwable);
    }

    public void trace(Plugin plugin, Level level, String message, Throwable throwable) {
        assert (plugin != null);
        if (Platform.inDebugMode() && Boolean.valueOf(Platform.getDebugOption((String)(String.valueOf(plugin.getBundle().getSymbolicName()) + DEBUG_FLAG))).booleanValue()) {
            this.traceImpl(level, message, throwable);
        }
    }

    public void trace(Plugin plugin, Level level, String message) {
        this.trace(plugin, level, message, null);
    }

    public void trace(Plugin plugin, String message) {
        this.trace(plugin, Level.INFO, message, null);
    }

    private void traceImpl(Level level, String message, Throwable throwable) {
        if (level.ordinal() > this.maxTraceLevel.ordinal()) {
            return;
        }
        System.out.println((Object)((Object)level) + ": " + message);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    public void setTraceLevel(Level level) {
        this.maxTraceLevel = level;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        DEBUG,
        INFO,
        WARNING,
        ERROR;


        public static Level getLevel(IStatus status) {
            switch (status.getSeverity()) {
                case 1: {
                    return INFO;
                }
                case 4: {
                    return ERROR;
                }
                case 8: {
                    return INFO;
                }
                case 2: {
                    return WARNING;
                }
                case 0: {
                    return INFO;
                }
            }
            return DEBUG;
        }
    }
}

