/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.builder.classpath.ClassPath;
import com.sun.javafx.eclipse.core.builder.classpath.JavaFileObjects;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Archive {
    private static Map<IPath, Archive> archives = new HashMap<IPath, Archive>();

    public abstract Iterable<JavaFileObject> getFiles(String var1, IClasspathEntry var2, Set<JavaFileObject.Kind> var3) throws IOException;

    public abstract void clear();

    public static Archive get(IPath root) {
        Archive archive = archives.get(root);
        if (archive == null && (archive = Archive.create(root)) != null) {
            archives.put(root, archive);
        }
        return archive;
    }

    private static Archive create(IPath root) {
        boolean isDir;
        Activator.trace("Archive create for " + root, null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        URI uri = URIUtil.toURI((IPath)root);
        IResource m = workspaceRoot.findMember(root);
        boolean bl = isDir = m != null && m.exists() && m.getType() == 2;
        if (isDir) {
            return new FolderArchive((IFolder)m);
        }
        return new CachingArchive(new File(uri));
    }

    public static URL getArchiveFile(URL url) {
        String path;
        int index;
        String protocol = url.getProtocol();
        if ("jar".equals(protocol) && (index = (path = url.getPath()).indexOf("!/")) >= 0) {
            try {
                String jarPath = path.substring(0, index);
                if (jarPath.indexOf("file://") > -1 && jarPath.indexOf("file:////") == -1) {
                    jarPath = jarPath.replaceFirst("file://", "file:////");
                }
                return new URL(jarPath);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingArchive
    extends Archive {
        private final File archiveFile;
        private ZipFile zipFile;
        byte[] names;
        private int nameOffset = 0;
        static final int[] EMPTY = new int[0];
        private Map<String, Folder> folders;

        public CachingArchive(File archiveFile) {
            this.archiveFile = archiveFile;
        }

        @Override
        public Iterable<JavaFileObject> getFiles(String folderName, IClasspathEntry entry, Set<JavaFileObject.Kind> kinds) throws IOException {
            this.doInit();
            Folder files = this.folders.get(folderName);
            if (files == null) {
                return Collections.emptyList();
            }
            assert (this.zipFile != null);
            ArrayList<JavaFileObject> l = new ArrayList<JavaFileObject>(files.idx / files.delta);
            int i = 0;
            while (i < files.idx) {
                this.create(folderName, files, i, kinds, l);
                i += files.delta;
            }
            return l;
        }

        private String getString(int off, int len) {
            byte[] name = new byte[len];
            System.arraycopy(this.names, off, name, 0, len);
            try {
                return new String(name, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("No UTF-8");
            }
        }

        static long join(int higher, int lower) {
            return (long)higher << 32 | (long)lower & 0xFFFFFFFFL;
        }

        private void create(String pkg, Folder f, int off, Set<JavaFileObject.Kind> kinds, List<? super JavaFileObject> l) {
            String baseName = this.getString(f.indices[off], f.indices[off + 1]);
            if (kinds == null || kinds.contains((Object)JavaFileObjects.getKind(JavaFileObjects.getExtension(baseName)))) {
                long mtime = CachingArchive.join(f.indices[off + 3], f.indices[off + 2]);
                if (this.zipFile == null) {
                    assert (f.delta == 4);
                    l.add(JavaFileObjects.zipFileObject(this.archiveFile, pkg, baseName, mtime));
                } else {
                    l.add(JavaFileObjects.zipFileObject(this.zipFile, pkg, baseName, mtime));
                }
            }
        }

        @Override
        public synchronized void clear() {
            this.folders = null;
            this.names = null;
            this.nameOffset = 0;
        }

        synchronized void doInit() {
            block5: {
                if (this.folders == null) {
                    try {
                        this.names = new byte[16384];
                        this.folders = this.createMap(this.archiveFile);
                        this.trunc();
                    }
                    catch (IOException iOException) {
                        this.names = new byte[0];
                        this.nameOffset = 0;
                        this.folders = new HashMap<String, Folder>();
                        if (this.zipFile == null) break block5;
                        try {
                            this.zipFile.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }

        private void trunc() {
            byte[] newNames = new byte[this.nameOffset];
            System.arraycopy(this.names, 0, newNames, 0, this.nameOffset);
            this.names = newNames;
            for (Folder fld : this.folders.values()) {
                fld.trunc();
            }
        }

        private Map<String, Folder> createMap(File file) throws IOException {
            if (!file.canRead()) {
                return Collections.emptyMap();
            }
            HashMap<String, Folder> map = new HashMap<String, Folder>();
            ZipFile zip = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    Folder fld;
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName();
                    int i = name.lastIndexOf(47);
                    String dirname = i == -1 ? "" : name.substring(0, i);
                    String basename = name.substring(i + 1);
                    if (basename.length() == 0) {
                        basename = null;
                    }
                    if ((fld = (Folder)map.get(dirname)) == null) {
                        fld = new Folder();
                        map.put(new String(dirname).intern(), fld);
                    }
                    if (basename == null) continue;
                    fld.appendEntry(this, basename, entry.getTime());
                }
            }
            finally {
                this.zipFile = zip;
            }
            return map;
        }

        int putName(byte[] name) {
            int start = this.nameOffset;
            if (start + name.length > this.names.length) {
                byte[] newNames = new byte[this.names.length * 2 + name.length];
                System.arraycopy(this.names, 0, newNames, 0, start);
                this.names = newNames;
            }
            System.arraycopy(name, 0, this.names, start, name.length);
            this.nameOffset += name.length;
            return start;
        }

        private static class Folder {
            int[] indices = EMPTY;
            int idx = 0;
            private final int delta;

            public Folder() {
                this.delta = 4;
            }

            void appendEntry(CachingArchive outer, String name, long mtime) {
                if (this.idx + this.delta > this.indices.length) {
                    int[] newInd = new int[2 * this.indices.length + this.delta];
                    System.arraycopy(this.indices, 0, newInd, 0, this.idx);
                    this.indices = newInd;
                }
                try {
                    byte[] bytes = name.getBytes("UTF-8");
                    this.indices[this.idx++] = outer.putName(bytes);
                    this.indices[this.idx++] = bytes.length;
                    this.indices[this.idx++] = (int)(mtime & 0xFFFFFFFFFFFFFFFFL);
                    this.indices[this.idx++] = (int)(mtime >> 32);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InternalError("No UTF-8");
                }
            }

            void trunc() {
                if (this.indices.length > this.idx) {
                    int[] newInd = new int[this.idx];
                    System.arraycopy(this.indices, 0, newInd, 0, this.idx);
                    this.indices = newInd;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileObjectArchive
    extends Archive {
        private final IFolder root;

        public FileObjectArchive(IFolder root) {
            this.root = root;
        }

        @Override
        public Iterable<JavaFileObject> getFiles(String folderName, IClasspathEntry entry, Set<JavaFileObject.Kind> kinds) throws IOException {
            IFile[] children;
            IFolder folder = (IFolder)this.root.getFile(folderName);
            if (folder == null || entry != null && !ClassPath.includes(entry, folder)) {
                return Collections.emptySet();
            }
            try {
                children = (IFile[])folder.members();
            }
            catch (CoreException e) {
                e.printStackTrace();
                return Collections.emptySet();
            }
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(children.length);
            IFile[] iFileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFile fo = iFileArray[n2];
                if (fo.getType() == 1 && (entry == null || ClassPath.includes(entry, fo)) && (kinds == null || kinds.contains((Object)JavaFileObjects.getKind(fo.getFileExtension())))) {
                    result.add(JavaFileObjects.nbFileObject(fo, this.root, false));
                }
                ++n2;
            }
            return result;
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderArchive
    extends Archive {
        final IFolder root;
        Charset encoding = Charset.forName("UTF-8");

        public FolderArchive(IFolder root) {
            assert (root != null);
            this.root = root;
        }

        @Override
        public Iterable<JavaFileObject> getFiles(String folderName, IClasspathEntry entry, Set<JavaFileObject.Kind> kinds) throws IOException {
            File[] content;
            IWorkspace workspace;
            IWorkspaceRoot workspaceRoot;
            File f1;
            File f2;
            File folder;
            assert (folderName != null);
            if (folderName.length() > 0) {
                folderName = String.valueOf(folderName) + '/';
            }
            if ((entry == null || ClassPath.includes(entry, folderName)) && (folder = new File(f2 = new File(f1 = (workspaceRoot = (workspace = ResourcesPlugin.getWorkspace()).getRoot()).getLocation().toFile(), this.root.getFullPath().toOSString()), folderName.replace('/', File.separatorChar))).canRead() && (content = folder.listFiles()) != null) {
                ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(content.length);
                File[] fileArray = content;
                int n = content.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isFile() && (entry == null || ClassPath.includes(entry, f.getAbsolutePath())) && (kinds == null || kinds.contains((Object)JavaFileObjects.getKind(JavaFileObjects.getExtension(f.getName()))))) {
                        result.add(JavaFileObjects.fileFileObject(f, new File(this.root.getFullPath().toOSString()), this.encoding));
                    }
                    ++n2;
                }
                return Collections.unmodifiableList(result);
            }
            return Collections.emptyList();
        }

        @Override
        public void clear() {
        }
    }
}

