/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class ClassOutputBuffer
extends SimpleJavaFileObject {
    private String name;
    private byte[] bytes;
    private static final String EXT = ".fx";

    ClassOutputBuffer(String name) {
        super(ClassOutputBuffer.toURI(name), JavaFileObject.Kind.CLASS);
        this.name = name;
    }

    public String getBinaryName() {
        return this.name;
    }

    public OutputStream openOutputStream() {
        return new FilterOutputStream(new ByteArrayOutputStream()){

            public void close() throws IOException {
                this.out.close();
                ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                ClassOutputBuffer.this.bytes = bos.toByteArray();
            }
        };
    }

    public byte[] getClassBytes() {
        return this.bytes;
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            StringBuilder newUri = new StringBuilder();
            newUri.append("mfm:///");
            newUri.append(name.replace('.', '/'));
            if (name.endsWith(EXT)) {
                newUri.replace(newUri.length() - EXT.length(), newUri.length(), EXT);
            }
            return URI.create(newUri.toString());
        }
        catch (Exception exception) {
            return URI.create("mfm:///com/sun/tools/javafx/script/javafx_source");
        }
    }
}

