/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iterators {
    private Iterators() {
    }

    public static <T> Iterable<T> chained(Iterable<? extends Iterable<T>> iterables) {
        return new ChainedIterable(iterables);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainedIterable<T>
    implements Iterable<T> {
        final Iterable<? extends Iterable<T>> iterables;

        ChainedIterable(Iterable<? extends Iterable<T>> iterables) {
            assert (iterables != null);
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new ChainedIterator(this.iterables);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainedIterator<E>
    implements Iterator<E> {
        protected final Iterator<? extends Iterable<E>> iteratorChain;
        protected Iterator<E> currentIterator = null;

        public ChainedIterator(Iterable<? extends Iterable<E>> iterators) {
            this.iteratorChain = iterators.iterator();
        }

        protected void updateCurrentIterator() {
            if (this.currentIterator == null) {
                this.currentIterator = !this.iteratorChain.hasNext() ? Collections.emptyList().iterator() : this.iteratorChain.next().iterator();
            }
            while (!this.currentIterator.hasNext() && this.iteratorChain.hasNext()) {
                this.currentIterator = this.iteratorChain.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.updateCurrentIterator();
            return this.currentIterator.hasNext();
        }

        @Override
        public E next() {
            this.updateCurrentIterator();
            return this.currentIterator.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

