/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import com.sun.javafx.eclipse.core.builder.classpath.CachingFileManager;
import com.sun.javafx.eclipse.core.builder.classpath.ClassPath;
import com.sun.javafx.eclipse.core.builder.classpath.JavaFileObjects;
import com.sun.javafx.eclipse.core.builder.classpath.SourceFileObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileManager
implements JavaFileManager {
    private final ClassPath cp;

    public SourceFileManager(ClassPath cp) {
        this.cp = cp;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location arg0) {
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        String _name = packageName.replace('.', '/');
        if (_name.length() != 0) {
            _name = String.valueOf(_name) + '/';
        }
        for (IClasspathEntry entry : this.cp.entries()) {
            IPath tmpP;
            IResource tmpFile;
            IResource root;
            if (!ClassPath.includes(entry, _name) || (root = SourceFileManager.fileFromPath(entry.getPath())) == null || (tmpFile = SourceFileManager.fileFromPath(tmpP = entry.getPath().append(_name))) == null || tmpFile.getType() != 2) continue;
            IFolder tmpFolder = (IFolder)tmpFile;
            try {
                IResource[] iResourceArray = tmpFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext;
                    JavaFileObject.Kind kind;
                    IResource file = iResourceArray[n2];
                    if (ClassPath.includes(entry, file) && kinds.contains((Object)(kind = "fx".equalsIgnoreCase(ext = file.getFileExtension()) || "java".equalsIgnoreCase(ext) ? JavaFileObject.Kind.SOURCE : ("class".equalsIgnoreCase(ext) || "sig".equalsIgnoreCase(ext) ? JavaFileObject.Kind.CLASS : ("html".equalsIgnoreCase(ext) ? JavaFileObject.Kind.HTML : JavaFileObject.Kind.OTHER))))) {
                        result.add(SourceFileObject.create((IFile)file, (IFolder)root));
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location l, JavaFileObject jfo) {
        IFolder root = null;
        if (!(jfo instanceof SourceFileObject)) {
            throw new IllegalStateException("cannot convert from " + jfo);
        }
        IFile fo = ((SourceFileObject)jfo).file;
        root = ((SourceFileObject)jfo).root;
        if (root == null) {
            for (IResource rc : this.cp.getRoots()) {
                rc.getLocation().isPrefixOf(fo.getLocation());
                if (!rc.getLocation().isPrefixOf(fo.getLocation())) continue;
                root = (IFolder)rc;
            }
        }
        if (root != null) {
            String relativePath = CachingFileManager.getRelativePath(fo.getFullPath(), root.getFullPath()).toPortableString();
            int index = relativePath.lastIndexOf(46);
            assert (index > 0);
            String result = relativePath.substring(0, index).replace('/', '.');
            return result;
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject0) {
        return fileObject instanceof SourceFileObject && fileObject0 instanceof SourceFileObject && ((SourceFileObject)fileObject).file == ((SourceFileObject)fileObject0).file;
    }

    @Override
    public boolean handleOption(String arg0, Iterator<String> arg1) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location arg0) {
        return true;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) {
        String[] namePair = JavaFileObjects.getParentRelativePathAndName(className);
        if (namePair == null) {
            return null;
        }
        String ext = kind.extension.substring(1);
        for (IClasspathEntry entry : this.cp.entries()) {
            IFile[] children;
            IFile parent;
            IFolder root = (IFolder)SourceFileManager.fileFromPath(entry.getPath());
            if (root == null || (parent = root.getFile(namePair[0])) == null) continue;
            try {
                children = (IFile[])((IFolder)parent).members();
            }
            catch (CoreException e) {
                e.printStackTrace();
                continue;
            }
            IFile[] iFileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFile child = iFileArray[n2];
                if (namePair[1].equals(child.getName()) && ext.equalsIgnoreCase(child.getFileExtension()) && ClassPath.includes(entry, child)) {
                    return SourceFileObject.create(child, root);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location arg0, String arg1, JavaFileObject.Kind arg2, FileObject arg3) throws IOException {
        throw new UnsupportedOperationException("The SourceFileManager does not support write operations.");
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location l, String pkgName, String relativeName) {
        String rp = JavaFileObjects.getRelativePath(pkgName, relativeName);
        for (IClasspathEntry entry : this.cp.entries()) {
            IFile file;
            IFolder root;
            if (!ClassPath.includes(entry, rp) || (root = (IFolder)SourceFileManager.fileFromPath(entry.getPath())) == null || (file = root.getFile(rp)) == null) continue;
            return SourceFileObject.create(file, root);
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location arg0, String arg1, String arg2, FileObject arg3) throws IOException {
        throw new UnsupportedOperationException("The SourceFileManager does not support write operations.");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String arg0) {
        return -1;
    }

    private static IResource fileFromPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        return workspaceRoot.findMember(path);
    }
}

