/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.classpath;

import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.JavaFXProject;
import com.sun.javafx.eclipse.core.classpath.SDKClasspathContainerInitializer;
import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import java.util.HashMap;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SDKClasspathContainerPreferencePage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private JavaFXProject javafxProject;
    private IClasspathEntry containerEntry;
    private Label sdkPath;
    private Button desktopProfile;
    private Button mobileProfile;
    private String profile;

    public SDKClasspathContainerPreferencePage() {
        super("JavaFX System Library", "JavaFX System Library", Activator.getDefault().getImageRegistry().getDescriptor("/icons/javafx_icon.png"));
    }

    public boolean finish() {
        this.javafxProject.getPreferenceStore().setValue("JavaFXSDKProfile", this.profile);
        SDKClasspathContainerInitializer.addClasspathContainerToJavaProject(this.javafxProject.getJavaProject());
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.containerEntry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.containerEntry = containerEntry;
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        this.setControl((Control)root);
        root.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(root, 0);
        label.setText("SDK Path:");
        label.setLayoutData((Object)this.createGridData(1, false));
        this.sdkPath = new Label(root, 2048);
        this.sdkPath.setLayoutData((Object)this.createGridData(2, true));
        Label descLabel = new Label(root, 0);
        descLabel.setText("Edit by changing 'JAVAFX_HOME' variable");
        descLabel.setLayoutData((Object)this.createGridData(2, true));
        Button variablesButton = new Button(root, 2048);
        variablesButton.setText("Change");
        variablesButton.setLayoutData((Object)this.createGridData(1, false));
        variablesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SDKClasspathContainerPreferencePage.openVariablesPreferences(SDKClasspathContainerPreferencePage.this.getShell());
                SDKClasspathContainerPreferencePage.this.updateDialog();
            }
        });
        Label separator = new Label(root, 258);
        separator.setLayoutData((Object)this.createGridData(3, true));
        Label profileLabel = new Label(root, 0);
        profileLabel.setText("Profile:");
        GridData profileLabelGridData = this.createGridData(1, false);
        profileLabelGridData.verticalAlignment = 128;
        profileLabel.setLayoutData((Object)profileLabelGridData);
        Composite profileGroup = new Composite(root, 0);
        profileGroup.setLayout((Layout)new GridLayout());
        profileGroup.setLayoutData((Object)this.createGridData(2, true));
        this.desktopProfile = new Button(profileGroup, 16400);
        this.desktopProfile.setText("Desktop");
        this.desktopProfile.setLayoutData((Object)this.createGridData(1, true));
        this.desktopProfile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SDKClasspathContainerPreferencePage.this.profile = "desktop";
                SDKClasspathContainerPreferencePage.this.updateProfileSelection();
            }
        });
        this.mobileProfile = new Button(profileGroup, 16400);
        this.mobileProfile.setText("Mobile");
        this.mobileProfile.setLayoutData((Object)this.createGridData(1, true));
        this.mobileProfile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SDKClasspathContainerPreferencePage.this.profile = "mobile";
                SDKClasspathContainerPreferencePage.this.updateProfileSelection();
            }
        });
        Label descProfile = new Label(root, 0);
        descProfile.setText("Used for JavaFX editor and Java files compilation only.");
        descProfile.setLayoutData((Object)this.createGridData(3, true));
        Label descProfile2 = new Label(root, 0);
        descProfile2.setText("For building the JavaFX application, use options in 'Run/Debug Settings' page.");
        descProfile2.setLayoutData((Object)this.createGridData(3, true));
        this.updateDialog();
    }

    public void dispose() {
        super.dispose();
        this.getControl().dispose();
        this.sdkPath = null;
        this.desktopProfile = null;
        this.mobileProfile = null;
    }

    private GridData createGridData(int columns, boolean expand) {
        GridData gridData = new GridData(expand ? 4 : 16384, 0x1000000, expand, false);
        gridData.horizontalSpan = columns;
        return gridData;
    }

    public static void openVariablesPreferences(Shell shell) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ClasspathVariablesPreferencePage.select_var", "JAVAFX_HOME");
        PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage", (String[])new String[]{"org.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage"}, options).open();
    }

    private void updateDialog() {
        if (this.sdkPath != null) {
            this.sdkPath.setText(JavaFXSDK.getSDKValidityTextFromPreferences());
        }
        if (this.desktopProfile != null) {
            this.desktopProfile.setEnabled(JavaFXSDK.isValidProfileFromPreferences("desktop"));
        }
        if (this.mobileProfile != null) {
            this.mobileProfile.setEnabled(JavaFXSDK.isValidProfileFromPreferences("mobile"));
        }
        this.updateProfileSelection();
    }

    private void updateProfileSelection() {
        if (this.desktopProfile != null) {
            this.desktopProfile.setSelection("desktop".equals(this.profile));
        }
        if (this.mobileProfile != null) {
            this.mobileProfile.setSelection("mobile".equals(this.profile));
        }
    }

    public void initialize(IJavaProject javaProject, IClasspathEntry[] currentEntries) {
        this.javafxProject = JavaFXProject.create(javaProject.getProject());
        this.profile = this.javafxProject.getPreferenceStore().getString("JavaFXSDKProfile");
    }
}

