/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.jetty;

import com.sun.javafx.eclipse.core.jetty.JettyRun;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JettyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected long getLastModified(HttpServletRequest req) {
        long time;
        String file;
        String conf;
        String distFile;
        int i;
        String path = req.getRequestURI();
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        if ((i = path.indexOf("/")) >= 0 && (distFile = JettyRun.getDistFile(conf = path.substring(0, i), file = path.substring(i + 1))) != null && (time = new File(distFile).lastModified()) > 0L) {
            return time;
        }
        return super.getLastModified(req);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        File distFileFile;
        String file;
        String conf;
        String distFile;
        int i;
        String path = req.getRequestURI();
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        if ((i = path.indexOf("/")) >= 0 && (distFile = JettyRun.getDistFile(conf = path.substring(0, i), file = path.substring(i + 1))) != null && (distFileFile = new File(distFile)).canRead()) {
            String contentType = null;
            if (distFile.endsWith(".html")) {
                contentType = "text/html";
            } else if (distFile.endsWith(".jar")) {
                contentType = "application/java-archive ";
            } else if (distFile.endsWith(".jnlp")) {
                contentType = "application/x-java-jnlp-file";
            }
            if (contentType != null) {
                resp.setContentType(contentType);
                resp.setContentLength((int)distFileFile.length());
                byte[] mem = new byte[65536];
                FileInputStream inputStream = new FileInputStream(distFileFile);
                try {
                    int len;
                    ServletOutputStream outputStream = resp.getOutputStream();
                    while ((len = inputStream.read(mem)) >= 0) {
                        outputStream.write(mem, 0, len);
                    }
                    outputStream.flush();
                }
                finally {
                    inputStream.close();
                }
                return;
            }
        }
        resp.sendError(404);
    }
}

