/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.launch;

import com.sun.javafx.eclipse.core.JavaUISupport;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class LaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        IJavaProject[] javaProject = new IJavaProject[1];
        String[] className = new String[1];
        JavaUISupport.getActiveFXContentFromSelection(selection, javaProject, className);
        this.launch(javaProject[0], className[0], mode);
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaProject[] javaProject = new IJavaProject[1];
        String[] className = new String[1];
        IEditorInput editorInput = editor.getEditorInput();
        JavaUISupport.getActiveFXContentFromObject(editorInput.getAdapter(IResource.class), javaProject, className);
        if (javaProject[0] == null) {
            JavaUISupport.getActiveFXContentFromObject(editor.getAdapter(IJavaElement.class), javaProject, className);
        }
        this.launch(javaProject[0], className[0], mode);
    }

    private void launch(IJavaProject javaProject, String className, String mode) {
        if (javaProject == null) {
            return;
        }
        ILaunchConfiguration[] configuration = new ILaunchConfiguration[1];
        boolean newlyCreated = this.findOrCreateConfiguration(configuration, className != null ? className : javaProject.getElementName(), javaProject.getElementName(), className);
        if (configuration[0] == null) {
            return;
        }
        if (newlyCreated) {
            DebugUITools.openLaunchConfigurationDialog((Shell)JavaUISupport.getShell(), (ILaunchConfiguration)configuration[0], (String)"com.sun.javafx.eclipse.core.launchRunGroup", null);
        } else {
            DebugUITools.launch((ILaunchConfiguration)configuration[0], (String)mode);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean findOrCreateConfiguration(ILaunchConfiguration[] configuration, String configurationName, String projectName, String mainClass) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("com.sun.javafx.eclipse.core.launch.LaunchConfigurationDelegate");
        try {
            if (projectName != null) {
                ILaunchConfiguration[] foundConfigurations;
                ILaunchConfiguration[] iLaunchConfigurationArray = foundConfigurations = launchManager.getLaunchConfigurations(configType);
                int n = foundConfigurations.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration foundConfiguration = iLaunchConfigurationArray[n2];
                    String foundProjectName = foundConfiguration.getAttribute("JavaFXLaunchProjectName", null);
                    String foundClassName = foundConfiguration.getAttribute("JavaFXLaunchMainClass", null);
                    if (projectName.equals(foundProjectName)) {
                        if (mainClass != null) {
                            if (mainClass.equals(foundClassName)) {
                                configuration[0] = foundConfiguration;
                                return false;
                            }
                        } else {
                            configuration[0] = foundConfiguration;
                            return foundClassName == null;
                        }
                    }
                    ++n2;
                }
            }
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchManager.generateUniqueLaunchConfigurationNameFrom(configurationName));
            wc.setAttribute("JavaFXLaunchProjectName", projectName != null ? projectName : "");
            wc.setAttribute("JavaFXLaunchTarget", "deskop/jar");
            wc.setAttribute("JavaFXLaunchMainClass", mainClass != null ? mainClass : "");
            configuration[0] = wc.doSave();
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }
}

