/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.sdk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFXSDK {
    public static final String VALUE_PROFILE_DESKTOP = "desktop";
    public static final String VALUE_PROFILE_MOBILE = "mobile";
    public static final String PROP_COMPILE_BOOTCLASSPATH = "compile_bootclasspath";
    public static final String PROP_COMPILE_CLASSPATH = "compile_classpath";

    private static File getLauncher(File rootDirectory, String launcher) {
        File binDirectory = new File(rootDirectory, "bin");
        File launcherFile = new File(binDirectory, launcher);
        if (launcherFile.exists()) {
            return launcherFile;
        }
        launcherFile = new File(binDirectory, String.valueOf(launcher) + ".exe");
        if (launcherFile.exists()) {
            return launcherFile;
        }
        return null;
    }

    private static File getEmulatorLauncher(File rootDirectory, String launcher) {
        File emulatorDirectory = new File(rootDirectory, "emulator");
        File binDirectory = new File(emulatorDirectory, "bin");
        File launcherFile = new File(binDirectory, launcher);
        if (launcherFile.exists()) {
            return launcherFile;
        }
        launcherFile = new File(binDirectory, String.valueOf(launcher) + ".exe");
        if (launcherFile.exists()) {
            return launcherFile;
        }
        return null;
    }

    private static File getProfile(File rootDirectory, String profile) {
        File profilesDirectory = new File(rootDirectory, "profiles");
        File profileFile = new File(profilesDirectory, String.valueOf(profile) + ".properties");
        if (profileFile.exists()) {
            return profileFile;
        }
        return null;
    }

    public static boolean isValidSDK(String sdkPath) {
        if (sdkPath == null || sdkPath.length() == 0) {
            return false;
        }
        File rootDirectory = new File(sdkPath.trim());
        return rootDirectory.isDirectory() && JavaFXSDK.getLauncher(rootDirectory, "javafx") != null && JavaFXSDK.getLauncher(rootDirectory, "javafxc") != null && JavaFXSDK.getLauncher(rootDirectory, "javafxpackager") != null && JavaFXSDK.getProfile(rootDirectory, VALUE_PROFILE_DESKTOP) != null;
    }

    public static boolean isValidMobileSDK(String sdkPath) {
        if (!JavaFXSDK.isValidSDK(sdkPath)) {
            return false;
        }
        File rootDirectory = new File(sdkPath.trim());
        return JavaFXSDK.getEmulatorLauncher(rootDirectory, "emulator") != null && JavaFXSDK.getProfile(rootDirectory, VALUE_PROFILE_MOBILE) != null;
    }

    public static String getSDKPathFromPreferences() {
        IPath sdkPath = JavaCore.getClasspathVariable((String)"JAVAFX_HOME");
        return sdkPath != null ? sdkPath.toOSString() : null;
    }

    private static File getSDKRootDirectoryFromPreferences() {
        String path = JavaFXSDK.getSDKPathFromPreferences();
        return path != null ? new File(path) : null;
    }

    public static boolean isValidProfileFromPreferences(String profile) {
        return JavaFXSDK.getProfile(JavaFXSDK.getSDKRootDirectoryFromPreferences(), profile) != null;
    }

    public static String getSDKLauncherFromPreferences(String launcher) {
        File launcherFile = JavaFXSDK.getLauncher(JavaFXSDK.getSDKRootDirectoryFromPreferences(), launcher);
        return launcherFile != null ? launcherFile.getPath() : null;
    }

    public static String getSDKEmulatorLauncherFromPreferences(String launcher) {
        File launcherFile = JavaFXSDK.getEmulatorLauncher(JavaFXSDK.getSDKRootDirectoryFromPreferences(), launcher);
        return launcherFile != null ? launcherFile.getPath() : null;
    }

    public static String getSDKValidityTextFromPreferences() {
        String sdkValidity;
        String sdkPath = JavaFXSDK.getSDKPathFromPreferences();
        String string = sdkValidity = JavaFXSDK.isValidSDK(sdkPath) ? "JavaFX SDK is detected" : "JavaFX SDK is missing";
        if (sdkPath == null || sdkPath.length() == 0) {
            sdkPath = "not set";
        }
        return String.valueOf(sdkValidity) + " - <" + sdkPath + ">";
    }

    public static String getSDKProfileValidityTextFromPreferences(String profile) {
        String profileValidity;
        String string = profileValidity = JavaFXSDK.isValidProfileFromPreferences(profile) ? "JavaFX Profile is detected" : "JavaFX Profile is invalid";
        if (profile == null || profile.length() == 0) {
            profile = "not set";
        }
        return String.valueOf(profileValidity) + " - <" + profile + ">";
    }

    public static Map<String, String> getProfileProperties(String sdkPath, String profile) {
        HashMap<String, String> properties;
        block16: {
            if (!JavaFXSDK.isValidSDK(sdkPath)) {
                return Collections.emptyMap();
            }
            File rootDirectory = new File(sdkPath);
            File profileFile = JavaFXSDK.getProfile(rootDirectory, profile);
            if (profileFile == null) {
                return Collections.emptyMap();
            }
            properties = new HashMap<String, String>();
            BufferedReader br = null;
            try {
                try {
                    String line;
                    br = new BufferedReader(new FileReader(profileFile));
                    while ((line = br.readLine()) != null) {
                        int i;
                        if ((line = line.trim()).startsWith("#") || (i = line.indexOf("=")) < 0) continue;
                        String key = line.substring(0, i).trim();
                        String value = line.substring(i + 1).trim();
                        if (value.startsWith("\"")) {
                            value = value.substring("\"".length());
                        }
                        if (value.endsWith("\"")) {
                            value = value.substring(0, value.length() - "\"".length());
                        }
                        value = value.trim();
                        properties.put(key, value);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public static List<String> convertPropertyToListOfPaths(String sdkPath, String propertyValue) {
        if (sdkPath == null || propertyValue == null) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>();
        String[] splitValues = propertyValue.split(";");
        if (splitValues != null) {
            String[] stringArray = splitValues;
            int n = splitValues.length;
            int n2 = 0;
            while (n2 < n) {
                String splitValue = stringArray[n2];
                if (splitValue.length() != 0) {
                    paths.add(splitValue.replace("${javafx_home}", sdkPath));
                }
                ++n2;
            }
        }
        return paths;
    }

    public static List<String> getSDKCompileBootClassPath(Map<String, String> profileProperties) {
        return JavaFXSDK.convertPropertyToListOfPaths(JavaFXSDK.getSDKPathFromPreferences(), profileProperties.get(PROP_COMPILE_BOOTCLASSPATH));
    }

    public static List<String> getSDKCompileClassPath(Map<String, String> profileProperties) {
        return JavaFXSDK.convertPropertyToListOfPaths(JavaFXSDK.getSDKPathFromPreferences(), profileProperties.get(PROP_COMPILE_CLASSPATH));
    }
}

