/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.editor.simple;

import com.sun.javafx.eclipse.editor.Activator;
import com.sun.javafx.eclipse.editor.simple.IContextSensitiveScanner;
import com.sun.javafx.eclipse.editor.simple.Lexer;
import com.sun.javafx.eclipse.editor.simple.TokenConvertor;
import com.sun.javafx.eclipse.editor.simple.v4Lexer;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FXAntlScanner
implements ITokenScanner,
ICharacterScanner,
IContextSensitiveScanner<BQLexerContainer> {
    private v4Lexer lexer;
    private int offset;
    private final TokenConvertor tc;
    private char[][] lineDelimiters;
    private IDocument document;
    private int cEnd;
    private int cOffset;
    private int start;

    FXAntlScanner(TokenConvertor tc) {
        this.tc = tc;
    }

    public void setRange(IDocument document, int offset, int length) {
        Activator.trace("Document: " + document, null);
        this.offset = offset;
        this.start = offset;
        this.cOffset = offset;
        this.cEnd = offset + length;
        this.document = document;
        try {
            int ols = document.getLineOfOffset(offset);
            int eols = document.getLineOfOffset(offset + length);
            int lineNumber = document.getNumberOfLines(offset, length);
            Activator.trace("Configuring antlr scanner. " + offset + " => " + length + " total: " + lineNumber + " line(s) starting @ " + ols + " ending @" + eols, null);
            this.lexer = new v4Lexer((CharStream)new ANTLRStringStream(document.get(offset, length)));
            String[] delimiters = document.getLegalLineDelimiters();
            this.lineDelimiters = new char[delimiters.length][];
            int i = 0;
            while (i < delimiters.length) {
                this.lineDelimiters[i] = delimiters[i].toCharArray();
                ++i;
            }
        }
        catch (BadLocationException e) {
            FXAntlScanner.log(4, "Error while setting range for scanner.", e);
        }
    }

    static void log(int severity, String message, Throwable e) {
        Activator.log((IStatus)new Status(severity, "com.sun.javafx.eclipse.editor", message, e));
    }

    public IToken nextToken() {
        this.offset = this.start + this.lexer.getCharIndex();
        Token token = this.lexer.nextToken();
        return this.tc.convert(token);
    }

    public int getTokenOffset() {
        return this.offset;
    }

    public int getTokenLength() {
        return this.start + this.lexer.getCharIndex() - this.offset;
    }

    public char[][] getLegalLineDelimiters() {
        return this.lineDelimiters;
    }

    public int getColumn() {
        try {
            int line = this.document.getLineOfOffset(this.cOffset);
            int start = this.document.getLineOffset(line);
            return this.cOffset - start;
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    /*
     * Loose catch block
     */
    public int read() {
        try {
            if (this.cOffset < this.cEnd) {
                try {
                    char c = this.document.getChar(this.cOffset);
                    return c;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            return -1;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ++this.cOffset;
        }
    }

    public void unread() {
        --this.cOffset;
    }

    @Override
    public BQLexerContainer getContext() {
        return BQLexerContainer.freezeState(this.lexer.getBraceQuoteTracker());
    }

    @Override
    public void setContext(BQLexerContainer context) {
        BQLexerContainer.unfreezeState(context, this.lexer);
    }

    private static class BQLexerContainer {
        private final int braceDepth;
        private final char quote;
        private final boolean percentIsFormat;
        private final BQLexerContainer previous;

        private BQLexerContainer(int braceDepth, char quote, boolean percentIsFormat, BQLexerContainer previous) {
            this.braceDepth = braceDepth;
            this.quote = quote;
            this.percentIsFormat = percentIsFormat;
            this.previous = previous;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BQLexerContainer that = (BQLexerContainer)o;
            if (this.braceDepth != that.braceDepth) {
                return false;
            }
            if (this.percentIsFormat != that.percentIsFormat) {
                return false;
            }
            if (this.quote != that.quote) {
                return false;
            }
            return !(this.previous != null ? !this.previous.equals(that.previous) : that.previous != null);
        }

        public int hashCode() {
            int result = this.braceDepth;
            result = 31 * result + this.quote;
            result = 31 * result + (this.percentIsFormat ? 1 : 0);
            result = 31 * result + (this.previous != null ? this.previous.hashCode() : 0);
            return result;
        }

        static BQLexerContainer freezeState(Lexer.BraceQuoteTracker t) {
            BQLexerContainer root = null;
            while (t != null) {
                root = new BQLexerContainer(t.getBraceDepth(), t.getQuote(), t.isPercentIsFormat(), root);
                t = t.getNext();
            }
            return root;
        }

        static Lexer.BraceQuoteTracker unfreezeState(BQLexerContainer c, Lexer lexer) {
            Lexer.BraceQuoteTracker root = null;
            while (c != null) {
                root = lexer.createBQT(root, c.quote, c.percentIsFormat);
                root.setBraceDepth(c.braceDepth);
                c = c.previous;
            }
            return root;
        }
    }
}

