/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.editor.simple;

import com.sun.javafx.eclipse.editor.simple.FXAntlScanner;
import com.sun.javafx.eclipse.editor.simple.FXDoubleClickStrategy;
import com.sun.javafx.eclipse.editor.simple.IFXColorConstants;
import com.sun.javafx.eclipse.editor.simple.NonRuleBasedDamagerRepairer;
import com.sun.javafx.eclipse.editor.simple.TokenConvertor;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class FXConfiguration
extends SourceViewerConfiguration {
    private FXDoubleClickStrategy doubleClickStrategy;
    private ITokenScanner scanner;
    private IColorManager colorManager;
    private IPreferenceStore fPreferenceStore;

    public FXConfiguration(IColorManager colorManager, IPreferenceStore fPreferenceStore) {
        this.colorManager = colorManager;
        this.fPreferenceStore = fPreferenceStore;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__line_comment", "__block_comment"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new FXDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected ITokenScanner getFXScanner() {
        if (this.scanner == null) {
            this.scanner = new FXAntlScanner(new TokenConvertor(this.colorManager, this.fPreferenceStore));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getFXScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IFXColorConstants.COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__line_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__line_comment");
        return reconciler;
    }
}

