/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.editor.simple;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;

public abstract class Lexer
extends org.antlr.runtime.Lexer {
    public final BraceQuoteTracker NULL_BQT;
    private BraceQuoteTracker quoteStack;
    protected static Log log = new MyLog(new Context());
    private static final Logger logger = Logger.getLogger(Lexer.class.getName());
    private List<Token> tokens;

    public void emit(Token token) {
        this.state.token = token;
        this.tokens.add(token);
    }

    public Token nextToken() {
        if (this.tokens.size() > 0) {
            return this.tokens.remove(0);
        }
        super.nextToken();
        if (this.tokens.size() == 0) {
            this.emit(Token.EOF_TOKEN);
        }
        return this.tokens.remove(0);
    }

    public void setText(String text) {
    }

    protected Lexer(CharStream charStream, RecognizerSharedState recognizerSharedState) {
        super(charStream, recognizerSharedState);
        this.quoteStack = this.NULL_BQT = new BraceQuoteTracker(null, '\'', false);
        this.tokens = new ArrayList<Token>();
    }

    protected Lexer() {
        this.quoteStack = this.NULL_BQT = new BraceQuoteTracker(null, '\'', false);
        this.tokens = new ArrayList<Token>();
    }

    protected Lexer(CharStream input) {
        super(input);
        this.quoteStack = this.NULL_BQT = new BraceQuoteTracker(null, '\'', false);
        this.tokens = new ArrayList<Token>();
    }

    public BraceQuoteTracker getBraceQuoteTracker() {
        return this.quoteStack;
    }

    public void setBraceQuoteTracker(BraceQuoteTracker stack) {
        this.quoteStack = stack;
    }

    public RecognizerSharedState getSharedState() {
        return this.state;
    }

    public void recover(RecognitionException re) {
        logger.severe(String.valueOf(this.getErrorMessage(re, this.getTokenNames())) + " Trying to recover from error. " + re.getClass().getSimpleName());
        BitSet bitSet = this.computeErrorRecoverySet();
        this.consumeUntil((IntStream)this.input, bitSet);
        this.input.consume();
    }

    public void reportError(RecognitionException e) {
        if (e instanceof FailedPredicateException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(String.valueOf(e.getClass().getSimpleName()) + " found unexpected type " + Integer.toString(e.getUnexpectedType()) + " trying to recover from buggy source code.");
            }
            this.input.consume();
        } else {
            super.reportError(e);
        }
    }

    public void setSharedState(RecognizerSharedState state) {
        this.state = state;
    }

    BraceQuoteTracker createBQT(BraceQuoteTracker prev, char quote, boolean percentIsFormat) {
        if (prev == null) {
            return this.NULL_BQT;
        }
        return new BraceQuoteTracker(prev, quote, percentIsFormat);
    }

    protected void processString() {
    }

    protected void processTranslationKey() {
    }

    protected void enterBrace(int quote, boolean nextIsPercent) {
        this.quoteStack.enterBrace(quote, nextIsPercent);
    }

    protected void leaveQuote() {
        this.quoteStack.leaveQuote();
    }

    protected boolean rightBraceLikeQuote(int quote) {
        return this.quoteStack.rightBraceLikeQuote(quote);
    }

    protected void leaveBrace() {
        this.quoteStack.leaveBrace();
    }

    protected boolean percentIsFormat() {
        return this.quoteStack.percentIsFormat();
    }

    protected void resetPercentIsFormat() {
        this.quoteStack.resetPercentIsFormat();
    }

    protected void checkIntLiteralRange(String text, int pos, int radix) {
    }

    protected void processFormatString() {
    }

    class BraceQuoteTracker {
        private int braceDepth;
        private char quote;
        private boolean percentIsFormat;
        private BraceQuoteTracker next;

        public BraceQuoteTracker(BraceQuoteTracker prev, char quote, boolean percentIsFormat) {
            this.quote = quote;
            this.percentIsFormat = percentIsFormat;
            this.braceDepth = 1;
            this.next = prev;
        }

        void enterBrace(int quote, boolean percentIsFormat) {
            if (quote == 0) {
                if (Lexer.this.quoteStack != Lexer.this.NULL_BQT) {
                    ++((Lexer)Lexer.this).quoteStack.braceDepth;
                    ((Lexer)Lexer.this).quoteStack.percentIsFormat = percentIsFormat;
                }
            } else {
                Lexer.this.quoteStack = new BraceQuoteTracker(Lexer.this.quoteStack, (char)quote, percentIsFormat);
            }
        }

        char leaveBrace() {
            if (Lexer.this.quoteStack != Lexer.this.NULL_BQT && --((Lexer)Lexer.this).quoteStack.braceDepth == 0) {
                return ((Lexer)Lexer.this).quoteStack.quote;
            }
            return '\u0000';
        }

        boolean rightBraceLikeQuote(int quote) {
            boolean b = Lexer.this.quoteStack != Lexer.this.NULL_BQT && ((Lexer)Lexer.this).quoteStack.braceDepth == 1 && (quote == 0 || ((Lexer)Lexer.this).quoteStack.quote == (char)quote);
            return b;
        }

        void leaveQuote() {
            assert (Lexer.this.quoteStack != Lexer.this.NULL_BQT && ((Lexer)Lexer.this).quoteStack.braceDepth == 0);
            Lexer.this.quoteStack = ((Lexer)Lexer.this).quoteStack.next;
        }

        boolean percentIsFormat() {
            return Lexer.this.quoteStack != Lexer.this.NULL_BQT && ((Lexer)Lexer.this).quoteStack.percentIsFormat;
        }

        void resetPercentIsFormat() {
            ((Lexer)Lexer.this).quoteStack.percentIsFormat = false;
        }

        boolean inBraceQuote() {
            boolean b = Lexer.this.quoteStack != Lexer.this.NULL_BQT;
            return b;
        }

        public String toString() {
            return "BQT[depth=" + this.braceDepth + ", quote=" + Integer.toString(this.quote) + ", pif=" + this.percentIsFormat + ", next=" + this.next + ']';
        }

        public int getBraceDepth() {
            return this.braceDepth;
        }

        public char getQuote() {
            return this.quote;
        }

        public boolean isPercentIsFormat() {
            return this.percentIsFormat;
        }

        public BraceQuoteTracker getNext() {
            return this.next;
        }

        void setBraceDepth(int depth) {
            this.braceDepth = depth;
        }
    }

    private static class MyLog
    extends Log {
        static Log instace(Context context) {
            if (context.get(logKey) != null) {
                context.put(logKey, null);
            }
            return new MyLog(context);
        }

        private MyLog(Context context) {
            super(context);
        }

        public void error(String key, Object ... args) {
            this.error(null, key, args);
        }

        public void error(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
            this.error(pos.getStartPosition(), key, args);
        }

        public void error(int pos, String key, Object ... args) {
            logger.fine("Lexer error: " + key + " @" + pos + "\tCaused by: " + Arrays.asList(args));
        }
    }
}

