/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder;

import com.sun.javafx.api.JavafxcTask;
import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.builder.JavaFXCompilerMessage;
import com.sun.javafx.eclipse.core.builder.classpath.ClasspathInfo;
import com.sun.javafx.eclipse.core.builder.classpath.SourceFileObject;
import com.sun.tools.javafx.api.JavafxcTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class JavaFXBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.sun.javafx.eclipse.core.builder.JavaFXBuilder";
    private static final String MARKER_TYPE = "com.sun.javafx.eclipse.core.builder.fxproblem";
    private Map<IResource, Long> lastCheck = new WeakHashMap<IResource, Long>();

    private void addMarker(IFile file, String message, int lineNumber, int start, int end, int severity) {
        try {
            if (lineNumber <= 0) {
                return;
            }
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)JavaFXCompilerMessage.format(message));
            marker.setAttribute("severity", severity);
            marker.setAttribute("lineNumber", lineNumber);
            if (start > 0) {
                marker.setAttribute("charStart", start);
            }
            if (end > 0) {
                marker.setAttribute("charEnd", end);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void checkFX(IResource resource) {
        if (resource instanceof IFolder) {
            IFolder f = (IFolder)resource;
            try {
                IResource[] members;
                IResource[] iResourceArray = members = f.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (!(r instanceof IProject)) {
                        this.checkFX(r);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            return;
        }
        if (resource instanceof IProject) {
            IProject p = (IProject)resource;
            try {
                IResource[] members;
                IResource[] iResourceArray = members = p.members();
                int n = members.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource r = iResourceArray[n3];
                    if (!(r instanceof IProject)) {
                        this.checkFX(r);
                    }
                    ++n3;
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            return;
        }
        if (resource instanceof IFile && resource.getName().endsWith(".fx")) {
            String srcDir = resource.getParent().getLocation().toOSString();
            IFile file = (IFile)resource;
            Long last = this.lastCheck.get(file);
            long now = System.currentTimeMillis();
            if (last != null && now - last < 1000L) {
                return;
            }
            this.lastCheck.put((IResource)file, now);
            Activator.trace("Compiling " + file, null);
            MyDiagnosticListener dl = new MyDiagnosticListener();
            try {
                ClasspathInfo cpInfo = ClasspathInfo.create(file);
                JavafxcTool tool = new JavafxcTool();
                JavaFileManager fm = cpInfo.getFileManager(tool);
                SourceFileObject jfo = SourceFileObject.create(file, null);
                ArrayList<String> options = new ArrayList<String>();
                options.add("-XDdisableStringFolding");
                new File(srcDir, file.getName());
                JavafxcTask task = tool.getTask(null, fm, dl, options, (Iterable)Collections.singleton(jfo));
                task.parse();
                task.analyze();
            }
            catch (Exception e) {
                Activator.log(e);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Error e) {
                Activator.log(e);
            }
            this.deleteMarkers(file);
            FXErrorHandler reporter = new FXErrorHandler(file, dl.errors);
            reporter.markAll();
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, true, 2);
        }
        catch (CoreException ce) {
            Activator.log(ce);
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new ResourceVisitor());
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new DeltaVisitor());
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    JavaFXBuilder.this.checkFX(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    JavaFXBuilder.this.checkFX(resource);
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FXErrorHandler {
        private IFile file;
        private List<Diagnostic<?>> errors;

        public FXErrorHandler(IFile file, List<?> list) {
            this.file = file;
            this.errors = list;
        }

        public void markAll() {
            for (Diagnostic<?> d : this.errors) {
                int severity;
                switch (d.getKind()) {
                    case ERROR: {
                        severity = 2;
                        break;
                    }
                    case WARNING: 
                    case MANDATORY_WARNING: {
                        severity = 1;
                        break;
                    }
                    default: {
                        severity = 0;
                    }
                }
                JavaFXBuilder.this.addMarker(this.file, d.getMessage(Locale.getDefault()), (int)d.getLineNumber(), (int)d.getStartPosition(), (int)d.getEndPosition(), severity);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyDiagnosticListener<T>
    implements DiagnosticListener<T> {
        public List<Diagnostic<? extends T>> errors = new ArrayList<Diagnostic<? extends T>>();

        MyDiagnosticListener() {
        }

        @Override
        public void report(Diagnostic<? extends T> d) {
            this.errors.add(d);
        }
    }

    class ResourceVisitor
    implements IResourceVisitor {
        ResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            JavaFXBuilder.this.checkFX(resource);
            return true;
        }
    }
}

