/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import com.sun.javafx.eclipse.core.builder.classpath.Archive;
import com.sun.javafx.eclipse.core.builder.classpath.ClassPath;
import com.sun.javafx.eclipse.core.builder.classpath.Iterators;
import com.sun.javafx.eclipse.core.builder.classpath.JavaFileObjects;
import com.sun.javafx.eclipse.core.builder.classpath.SourceFileObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingFileManager
implements JavaFileManager,
PropertyChangeListener {
    protected final ClassPath cp;

    public CachingFileManager(ClassPath cp) {
        this.cp = cp;
        cp.addPropertyChangeListener(this);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException("Recursive listing is not supported in archives");
        }
        String folderName = JavaFileObjects.convertPackage2Folder(packageName);
        LinkedList<Iterable<JavaFileObject>> idxs = new LinkedList<Iterable<JavaFileObject>>();
        for (IClasspathEntry entry : this.cp.entries()) {
            try {
                List<Archive> archives = this.getArchives(entry);
                for (Archive archive : archives) {
                    Iterable<JavaFileObject> entries = archive.getFiles(folderName, entry, kinds);
                    idxs.add(entries);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Iterators.chained(idxs);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location l, String pkgName, String relativeName) {
        for (IClasspathEntry root : this.cp.entries()) {
            try {
                List<Archive> archives = this.getArchives(root);
                for (Archive archive : archives) {
                    Iterable<JavaFileObject> files = archive.getFiles(JavaFileObjects.convertPackage2Folder(pkgName), root, null);
                    for (JavaFileObject e : files) {
                        if (!relativeName.equals(e.getName())) continue;
                        return e;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) {
        String[] namePair = JavaFileObjects.getParentRelativePathAndName(className);
        if (namePair == null) {
            return null;
        }
        namePair[1] = String.valueOf(namePair[1]) + kind.extension;
        for (IClasspathEntry root : this.cp.entries()) {
            try {
                List<Archive> archives = this.getArchives(root);
                for (Archive archive : archives) {
                    Iterable<JavaFileObject> files = archive.getFiles(namePair[0], root, null);
                    for (JavaFileObject e : files) {
                        if (!namePair[1].equals(e.getName())) continue;
                        return e;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private List<Archive> getArchives(IClasspathEntry entry) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        this.cp.entryToResource(entry, resources);
        ArrayList<Archive> res = new ArrayList<Archive>();
        for (IResource r : resources) {
            IPath p = r.getFullPath();
            Archive a = Archive.get(p);
            if (a != null) {
                res.add(a);
                continue;
            }
            System.err.println("Archive not found for " + p);
        }
        return res;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location l, JavaFileObject javaFileObject) {
        if (javaFileObject instanceof JavaFileObjects.Base) {
            JavaFileObjects.Base base = (JavaFileObjects.Base)javaFileObject;
            StringBuilder sb = new StringBuilder();
            sb.append(base.getPackage());
            sb.append('.');
            sb.append(base.getNameWithoutExtension());
            return sb.toString();
        }
        if (javaFileObject instanceof SourceFileObject) {
            IFile fo = ((SourceFileObject)javaFileObject).file;
            IFolder root = ((SourceFileObject)javaFileObject).root;
            if (root != null) {
                String relativePath = CachingFileManager.getRelativePath(fo.getFullPath(), root.getFullPath()).toPortableString();
                if (relativePath != null) {
                    int index = relativePath.lastIndexOf(46);
                    assert (index > 0);
                    String result = relativePath.substring(0, index).replace('/', '.');
                    return result;
                }
            } else {
                for (IResource r : this.cp.getRoots()) {
                    if (!r.getFullPath().isPrefixOf(fo.getFullPath())) continue;
                    String relativePath = CachingFileManager.getRelativePath(fo.getFullPath(), r.getFullPath()).toPortableString();
                    int index = relativePath.lastIndexOf(46);
                    assert (index > 0);
                    String result = relativePath.substring(0, index).replace('/', '.');
                    return result;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject0) {
        return fileObject instanceof JavaFileObjects.FileBase && fileObject0 instanceof JavaFileObjects.FileBase && ((JavaFileObjects.FileBase)fileObject).getFile().equals(((JavaFileObjects.FileBase)fileObject).getFile());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public static IPath getRelativePath(IPath aPath, IPath root) {
        if (!root.isPrefixOf(aPath)) {
            String message = "Relative path failed from " + aPath + " to root " + root;
            throw new IllegalArgumentException(message);
        }
        int matchingSegments = aPath.matchingFirstSegments(root);
        return aPath.removeFirstSegments(matchingSegments);
    }
}

