/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.JavaFXProject;
import com.sun.javafx.eclipse.core.builder.classpath.CachingFileManager;
import com.sun.javafx.eclipse.core.builder.classpath.PathMatcher;
import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPath {
    public static final String BOOT = "boot";
    public static final String COMPILE = "compile";
    public static final String SOURCE = "source";
    private static Map<IClasspathEntry, PathMatcher> matcherCache = new WeakHashMap<IClasspathEntry, PathMatcher>();
    private List<IClasspathEntry> entries;
    private IJavaProject javaProject;

    public static ClassPath getClassPath(IFile fo, String type) {
        IProject project = fo.getProject();
        if (project == null) {
            throw new IllegalArgumentException("Not part of any project " + fo);
        }
        JavaFXProject fxProject = JavaFXProject.create(project);
        IJavaProject javaP = fxProject.getJavaProject();
        if (BOOT.equals(type)) {
            ArrayList<IClasspathEntry> li = new ArrayList<IClasspathEntry>();
            for (String be : JavaFXSDK.getSDKCompileBootClassPath(fxProject.resolvePropertiesFromPreferences())) {
                li.add(JavaCore.newLibraryEntry((IPath)new Path(be), null, null));
            }
            return new ClassPath(li, javaP);
        }
        if (COMPILE.equals(type)) {
            List<IClasspathEntry> li = ClassPath.getLibraryPath(javaP);
            for (String be : JavaFXSDK.getSDKCompileClassPath(fxProject.resolvePropertiesFromPreferences())) {
                li.add(JavaCore.newLibraryEntry((IPath)new Path(be), null, null));
            }
            ClassPath cp = new ClassPath(li, javaP);
            return cp;
        }
        if (SOURCE.equals(type)) {
            ArrayList<IClasspathEntry> li = new ArrayList<IClasspathEntry>();
            for (IFile be : fxProject.getSourcePath()) {
                li.add(JavaCore.newSourceEntry((IPath)be.getFullPath()));
            }
            return new ClassPath(li, javaP);
        }
        throw new IllegalArgumentException("type == " + type);
    }

    private ClassPath(List<IClasspathEntry> entries, IJavaProject p) {
        Activator.trace("Classpath created with entries: " + entries, null);
        this.entries = entries;
        this.javaProject = p;
    }

    public List<IClasspathEntry> entries() {
        if (this.entries == null) {
            this.entries = new ArrayList<IClasspathEntry>();
        }
        return new ArrayList<IClasspathEntry>(this.entries);
    }

    public void addPropertyChangeListener(CachingFileManager cachingFileManager) {
    }

    public List<IResource> getRoots() {
        if (this.entries == null) {
            return null;
        }
        ArrayList<IResource> res = new ArrayList<IResource>();
        for (IClasspathEntry entry : this.entries) {
            this.entryToResource(entry, res);
        }
        return res;
    }

    void entryToResource(IClasspathEntry entry, List<IResource> res) {
        IResource r;
        if (entry.getEntryKind() == 4) {
            entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        }
        if (entry.getEntryKind() == 1 && (r = ClassPath.pathToFile(entry.getPath())) != null) {
            res.add(r);
        }
        if (entry.getEntryKind() == 5) {
            try {
                IClasspathEntry[] iClasspathEntryArray = this.javaProject.getResolvedClasspath(true);
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry e = iClasspathEntryArray[n2];
                    if (e.isExported()) {
                        this.entryToResource(e, res);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                Activator.log(e);
            }
        }
        if (entry.getEntryKind() == 2) {
            IProject otherP = this.javaProject.getProject().getWorkspace().getRoot().getProject(entry.getPath().segment(0));
            IJavaProject otherJavaProject = JavaCore.create((IProject)otherP);
            try {
                IClasspathEntry[] iClasspathEntryArray = otherJavaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IClasspathEntry e = iClasspathEntryArray[n3];
                    if (e.isExported()) {
                        this.entryToResource(e, res);
                    }
                    ++n3;
                }
            }
            catch (JavaModelException e) {
                Activator.log(e);
            }
            try {
                IPath o = otherJavaProject.getOutputLocation();
                IResource r2 = ClassPath.pathToFile(o);
                if (r2 != null) {
                    res.add(r2);
                }
            }
            catch (JavaModelException e) {
                Activator.log(e);
            }
        }
    }

    public static IResource pathToFile(IPath path) {
        if (path == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IFolder fold = workspaceRoot.getFolder(path);
        if (fold != null) {
            return fold;
        }
        IFile file = workspaceRoot.getFile(path);
        if (file != null) {
            return file;
        }
        return null;
    }

    private static List<IClasspathEntry> getLibraryPath(IJavaProject project) {
        int n;
        int n2;
        IPackageFragmentRoot[] iPackageFragmentRootArray;
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        try {
            IPackageFragmentRoot[] roots;
            iPackageFragmentRootArray = roots = project.getAllPackageFragmentRoots();
            n2 = roots.length;
            n = 0;
            while (n < n2) {
                IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n];
                res.add(packageRoot.getRawClasspathEntry());
                ++n;
            }
        }
        catch (JavaModelException e) {
            Activator.log(e);
        }
        try {
            IClasspathEntry[] rc = project.getResolvedClasspath(true);
            iPackageFragmentRootArray = rc;
            n2 = rc.length;
            n = 0;
            while (n < n2) {
                IPackageFragmentRoot i = iPackageFragmentRootArray[n];
                if (i.getEntryKind() == 2) {
                    res.add((IClasspathEntry)i);
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            Activator.log(e);
        }
        return res;
    }

    public static boolean includes(IClasspathEntry entry, IResource file) {
        try {
            return ClassPath.includes(entry.getPath().toFile().toURI().toURL(), file.getFullPath().toOSString(), entry);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return false;
        }
    }

    public static boolean includes(IClasspathEntry entry, IFolder folder) {
        try {
            return ClassPath.includes(entry.getPath().toFile().toURI().toURL(), folder.getFullPath().toOSString(), entry);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return false;
        }
    }

    public static boolean includes(IClasspathEntry entry, IFile folder) {
        try {
            return ClassPath.includes(entry.getPath().toFile().toURI().toURL(), folder.getFullPath().toOSString(), entry);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return false;
        }
    }

    public static boolean includes(IClasspathEntry entry, String folder) {
        try {
            return ClassPath.includes(entry.getPath().toFile().toURI().toURL(), folder, entry);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return false;
        }
    }

    public static boolean includes(URL root, String resource, IClasspathEntry entry) {
        PathMatcher matcher = matcherCache.get(entry);
        if (matcher == null) {
            IPath[] exclude;
            int n;
            String includes = "**";
            String excludes = "";
            IPath[] include = entry.getInclusionPatterns();
            if (include != null && include.length > 0) {
                includes = "";
                IPath[] iPathArray = include;
                n = include.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath i = iPathArray[n2];
                    includes = String.valueOf(includes) + i.toPortableString();
                    ++n2;
                }
            }
            if ((exclude = entry.getExclusionPatterns()) != null && exclude.length > 0) {
                IPath[] iPathArray = exclude;
                int n3 = exclude.length;
                n = 0;
                while (n < n3) {
                    IPath i = iPathArray[n];
                    excludes = String.valueOf(excludes) + i.toPortableString();
                    ++n;
                }
            }
            matcher = new PathMatcher(includes, excludes, new File(URI.create(root.toExternalForm())));
            matcherCache.put(entry, matcher);
        }
        boolean res = matcher.matches(resource, true);
        return res;
    }
}

