/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import com.sun.javafx.eclipse.core.builder.classpath.CachingFileManager;
import com.sun.javafx.eclipse.core.builder.classpath.ClassPath;
import com.sun.javafx.eclipse.core.builder.classpath.MemoryFileManager;
import com.sun.javafx.eclipse.core.builder.classpath.ProxyFileManager;
import com.sun.javafx.eclipse.core.builder.classpath.SourceFileManager;
import com.sun.tools.javafx.api.JavafxcTool;
import javax.tools.JavaFileManager;
import org.eclipse.core.resources.IFile;

public class ClasspathInfo {
    private ClassPath bootPath;
    private ClassPath compilePath;
    private ClassPath srcPath;
    private JavaFileManager fileManager;

    public static ClasspathInfo create(IFile fo) {
        ClassPath bootPath = ClassPath.getClassPath(fo, "boot");
        ClassPath compilePath = ClassPath.getClassPath(fo, "compile");
        ClassPath srcPath = ClassPath.getClassPath(fo, "source");
        return ClasspathInfo.create(bootPath, compilePath, srcPath);
    }

    public static ClasspathInfo create(ClassPath bootPath, ClassPath compilePath, ClassPath srcPath) {
        return new ClasspathInfo(bootPath, compilePath, srcPath);
    }

    private ClasspathInfo(ClassPath bootPath, ClassPath compilePath, ClassPath srcPath) {
        this.bootPath = bootPath;
        this.compilePath = compilePath;
        this.srcPath = srcPath;
    }

    public ClassPath getClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootPath;
            }
            case COMPILE: {
                return this.compilePath;
            }
            case SOURCE: {
                return this.srcPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    public synchronized JavaFileManager getFileManager(JavafxcTool tool) {
        if (this.fileManager == null) {
            ClassPath cachedSrcPath = this.srcPath;
            this.fileManager = new ProxyFileManager(new CachingFileManager(this.bootPath), new CachingFileManager(this.compilePath), new SourceFileManager(cachedSrcPath), new MemoryFileManager());
        }
        return this.fileManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathKind {
        BOOT,
        COMPILE,
        SOURCE;

    }
}

