/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import com.sun.javafx.eclipse.core.builder.classpath.SourceFileObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;

public class JavaFileObjects {
    public static final String JAVAFX = "fx";
    public static final String JAVA = "java";
    public static final String CLASS = "class";
    public static final String JAR = "jar";
    public static final String FILE = "file";
    public static final String ZIP = "zip";
    public static final String HTML = "html";
    public static final String SIG = "sig";
    public static final String RS = "rs";
    static final String encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();

    private JavaFileObjects() {
    }

    public static JavaFileObject zipFileObject(File zipFile, String folder, String baseName, long mtime) {
        assert (zipFile != null);
        return new ZipFileObject(zipFile, folder, baseName, mtime);
    }

    public static JavaFileObject zipFileObject(ZipFile zipFile, String folder, String baseName, long mtime) {
        assert (zipFile != null);
        return new CachedZipFileObject(zipFile, folder, baseName, mtime);
    }

    public static JavaFileObject fileFileObject(File file, File root) {
        return JavaFileObjects.fileFileObject(file, root, null);
    }

    public static JavaFileObject fileFileObject(File file, File root, Charset encoding) {
        assert (file != null);
        assert (root != null);
        String[] pkgNamePair = JavaFileObjects.getFolderAndBaseName(JavaFileObjects.getRelativePath(root, file), File.separatorChar);
        return new RegularFileObject(file, JavaFileObjects.convertFolder2Package(pkgNamePair[0], File.separatorChar), pkgNamePair[1], encoding);
    }

    public static SourceFileObject nbFileObject(IFile file, IFolder root) throws IOException {
        return JavaFileObjects.nbFileObject(file, root, false);
    }

    public static SourceFileObject nbFileObject(IFile file, IFolder root, boolean renderNow) throws IOException {
        assert (file != null);
        if (!file.isAccessible() || !file.exists()) {
            throw new InvalidFileException(file);
        }
        return new SourceFileObject(file, root);
    }

    public static String stripExtension(String fileName) {
        int dot = fileName.lastIndexOf(".");
        return dot == -1 ? fileName : fileName.substring(0, dot);
    }

    public static String getExtension(String fileName) {
        int dot = fileName.lastIndexOf(46);
        return dot == -1 || dot == fileName.length() - 1 ? "" : fileName.substring(dot + 1);
    }

    public static String getName(JavaFileObject fo, boolean noExt) {
        assert (fo != null);
        if (fo instanceof Base) {
            Base baseFileObject = (Base)fo;
            if (noExt) {
                return baseFileObject.getName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(baseFileObject.getName());
            sb.append('.');
            sb.append(baseFileObject.getExt());
            return sb.toString();
        }
        try {
            int index2;
            URL url = fo.toUri().toURL();
            String path = url.getPath();
            int index1 = path.lastIndexOf(47);
            int len = noExt ? ((index2 = path.lastIndexOf(46)) > index1 ? index2 : path.length()) : path.length();
            path = path.substring(index1 + 1, len);
            return path;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String getBaseName(String fileName) {
        return JavaFileObjects.getBaseName(fileName, File.separatorChar);
    }

    public static String getBaseName(String fileName, char separator) {
        return JavaFileObjects.getFolderAndBaseName(fileName, separator)[1];
    }

    public static String[] getFolderAndBaseName(String fileName, char separator) {
        int i = fileName.lastIndexOf(separator);
        if (i == -1) {
            return new String[]{"", fileName};
        }
        return new String[]{fileName.substring(0, i), fileName.substring(i + 1)};
    }

    public static String getBinaryName(File file, File root) {
        assert (file != null && root != null);
        String fileName = JavaFileObjects.getRelativePath(root, file);
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName.replace(File.separatorChar, '.');
    }

    public static String getSimpleName(JavaFileObject fo) {
        String name = JavaFileObjects.getName(fo, true);
        int i = name.lastIndexOf(36);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String getSimpleName(String fileName) {
        String name = JavaFileObjects.getBaseName(fileName);
        int i = name.lastIndexOf(36);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String convertPackage2Folder(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String convertFolder2Package(String packageName) {
        return JavaFileObjects.convertFolder2Package(packageName, '/');
    }

    public static String convertFolder2Package(String packageName, char folderSeparator) {
        return packageName.replace(folderSeparator, '.');
    }

    public static String getRelativePath(String packageName, String relativeName) {
        StringBuilder relativePath = new StringBuilder();
        relativePath.append(packageName.replace('.', '/'));
        relativePath.append(relativeName);
        return relativePath.toString();
    }

    public static String[] getParentRelativePathAndName(String className) {
        if (className.charAt(className.length() - 1) == '.') {
            return null;
        }
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return new String[]{"", className};
        }
        return new String[]{className.substring(0, index).replace('.', '/'), className.substring(index + 1)};
    }

    public static JavaFileObject.Kind getKind(String extension) {
        if (extension == null) {
            return JavaFileObject.Kind.OTHER;
        }
        String lcextension = extension.toLowerCase();
        if (JAVAFX.equals(lcextension) || JAVA.equals(lcextension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (CLASS.equals(lcextension) || SIG.equals(lcextension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (HTML.equals(lcextension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    public static void deleteRecursively(File folder) {
        File[] children;
        assert (folder != null);
        if (folder.isDirectory() && (children = folder.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                JavaFileObjects.deleteRecursively(file);
                ++n2;
            }
        }
        folder.delete();
    }

    public static String getRelativePath(File root, File fo) {
        int foIndex;
        String rootPath = root.getAbsolutePath();
        String foPath = fo.getAbsolutePath();
        assert (foPath.startsWith(rootPath)) : String.format("getRelativePath(%s, %s)", rootPath, foPath);
        int index = rootPath.length();
        if (rootPath.charAt(index - 1) != File.separatorChar) {
            ++index;
        }
        if ((foIndex = foPath.length()) <= index) {
            return "";
        }
        return foPath.substring(index);
    }

    public static abstract class Base
    implements JavaFileObject {
        protected final JavaFileObject.Kind kind;
        protected final String pkgName;
        protected final String nameWithoutExt;
        protected final String ext;

        protected Base(String pkgName, String name) {
            assert (pkgName != null);
            assert (name != null);
            this.pkgName = pkgName;
            String[] res = Base.getNameExtPair(name);
            this.nameWithoutExt = res[0];
            this.ext = res[1];
            this.kind = JavaFileObjects.getKind(this.ext);
        }

        public JavaFileObject.Kind getKind() {
            return this.kind;
        }

        public boolean isNameCompatible(String simplename, JavaFileObject.Kind k) {
            if (this.kind != k) {
                return false;
            }
            return this.nameWithoutExt.equals(simplename);
        }

        public NestingKind getNestingKind() {
            return null;
        }

        public Modifier getAccessLevel() {
            return null;
        }

        public String toString() {
            return this.toUri().toString();
        }

        public String getPackage() {
            return this.pkgName;
        }

        public String getNameWithoutExtension() {
            return this.nameWithoutExt;
        }

        public String getName() {
            return String.valueOf(this.nameWithoutExt) + '.' + this.ext;
        }

        public String getExt() {
            return this.ext;
        }

        private static String[] getNameExtPair(String name) {
            String ext;
            String namenx;
            int index = name.lastIndexOf(46);
            if (index <= 0) {
                namenx = name;
                ext = "";
            } else {
                namenx = name.substring(0, index);
                ext = index == name.length() - 1 ? "" : name.substring(index + 1);
            }
            return new String[]{namenx, ext};
        }
    }

    private static class CachedZipFileObject
    extends ZipFileBase {
        private ZipFile zipFile;

        CachedZipFileObject(ZipFile zipFile, String folderName, String baseName, long mtime) {
            super(folderName, baseName, mtime);
            assert (zipFile != null) : "archiveFile == null";
            this.zipFile = zipFile;
        }

        public InputStream openInputStream() throws IOException {
            return new BufferedInputStream(this.zipFile.getInputStream(new ZipEntry(this.resName)));
        }

        public URI getArchiveURI() {
            return new File(this.zipFile.getName()).toURI();
        }

        protected long getSize() throws IOException {
            ZipEntry ze = this.zipFile.getEntry(this.resName);
            return ze == null ? 0L : ze.getSize();
        }
    }

    public static abstract class FileBase
    extends Base {
        protected final File f;

        protected FileBase(File file, String pkgName, String name) {
            super(pkgName, name);
            assert (file != null);
            this.f = file;
        }

        public File getFile() {
            return this.f;
        }
    }

    public static class InvalidFileException
    extends IOException {
        public InvalidFileException() {
        }

        public InvalidFileException(IFile fo) {
            super(fo.getFullPath().toOSString());
        }
    }

    private static class RegularFileObject
    extends FileBase {
        private URI uriCache;
        private final Charset encoding;

        public RegularFileObject(File f, String packageName, String baseName, Charset encoding) {
            super(f, packageName, baseName);
            this.encoding = encoding;
        }

        public InputStream openInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.f));
        }

        public Reader openReader(boolean b) throws IOException {
            throw new UnsupportedOperationException();
        }

        public OutputStream openOutputStream() throws IOException {
            return new FileOutputStream(this.f);
        }

        public Writer openWriter() throws IOException {
            if (this.encoding != null) {
                return new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), this.encoding);
            }
            return new OutputStreamWriter(new FileOutputStream(this.f));
        }

        public boolean isNameCompatible(String simplename, JavaFileObject.Kind kind) {
            boolean res = super.isNameCompatible(simplename, kind);
            if (res) {
                return res;
            }
            return this.nameWithoutExt.equalsIgnoreCase(simplename);
        }

        public URI toUri() {
            if (this.uriCache == null) {
                this.uriCache = this.f.toURI();
            }
            return this.uriCache;
        }

        public long getLastModified() {
            return this.f.lastModified();
        }

        public boolean delete() {
            return this.f.delete();
        }

        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            char[] result;
            InputStreamReader in = this.encoding != null ? new InputStreamReader((InputStream)new FileInputStream(this.f), this.encoding) : new InputStreamReader(new FileInputStream(this.f));
            int red = 0;
            try {
                int rv;
                int len = (int)this.f.length();
                if (len == 0) {
                    ++len;
                }
                result = new char[len + 1];
                while ((rv = ((Reader)in).read(result, red, len - red)) >= 0) {
                    if ((red += rv) != len) continue;
                    char[] _tmp = new char[2 * len];
                    System.arraycopy(result, 0, _tmp, 0, len);
                    result = _tmp;
                    len = result.length;
                }
            }
            finally {
                ((Reader)in).close();
            }
            result[red++] = 10;
            CharBuffer buffer = CharBuffer.wrap(result, 0, red);
            return buffer;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RegularFileObject)) {
                return false;
            }
            RegularFileObject o = (RegularFileObject)other;
            return this.f.equals(o.f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }
    }

    public static abstract class ZipFileBase
    extends Base {
        protected final long mtime;
        protected final String resName;

        public ZipFileBase(String folderName, String baseName, long mtime) {
            super(JavaFileObjects.convertFolder2Package(folderName), baseName);
            this.mtime = mtime;
            if (folderName.length() == 0) {
                this.resName = baseName;
            } else {
                StringBuilder resName = new StringBuilder(folderName);
                resName.append('/');
                resName.append(baseName);
                this.resName = resName.toString();
            }
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Reader openReader(boolean b) throws IOException {
            if (this.getKind() == JavaFileObject.Kind.CLASS) {
                throw new UnsupportedOperationException();
            }
            return new InputStreamReader(this.openInputStream(), encodingName);
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getLastModified() {
            return this.mtime;
        }

        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            Reader r = this.openReader(ignoreEncodingErrors);
            try {
                int rv;
                int red = 0;
                int len = (int)this.getSize();
                char[] result = new char[len + 1];
                while ((rv = r.read(result, red, len - red)) > 0 && (red += rv) < len) {
                }
                int j = 0;
                int i = 0;
                while (i < red) {
                    if (result[i] == '\r') {
                        if (i + 1 >= red || result[i + 1] != '\n') {
                            result[j++] = 10;
                        }
                    } else {
                        result[j++] = result[i];
                    }
                    ++i;
                }
                result[j] = 10;
                CharBuffer charBuffer = CharBuffer.wrap(result, 0, j);
                return charBuffer;
            }
            finally {
                r.close();
            }
        }

        public final URI toUri() {
            URI zdirURI = this.getArchiveURI();
            try {
                return new URI("jar:" + zdirURI.toString() + "!/" + this.resName);
            }
            catch (URISyntaxException uRISyntaxException) {
                StringBuilder sb = new StringBuilder();
                String[] elements = this.resName.split("/");
                try {
                    int i = 0;
                    while (i < elements.length) {
                        String element = elements[i];
                        element = URLEncoder.encode(element, "UTF-8");
                        element = element.replace("+", "%20");
                        sb.append(element);
                        if (i < elements.length - 1) {
                            sb.append('/');
                        }
                        ++i;
                    }
                    return new URI("jar:" + zdirURI.toString() + "!/" + sb.toString());
                }
                catch (UnsupportedEncodingException e2) {
                    IllegalStateException ne = new IllegalStateException();
                    ne.initCause(e2);
                    throw ne;
                }
                catch (URISyntaxException e2) {
                    IllegalStateException ne = new IllegalStateException();
                    ne.initCause(e2);
                    throw ne;
                }
            }
        }

        public int hashCode() {
            return this.resName.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ZipFileBase)) {
                return false;
            }
            ZipFileBase o = (ZipFileBase)other;
            return this.getArchiveURI().equals(o.getArchiveURI()) && this.resName.equals(o.resName);
        }

        protected abstract URI getArchiveURI();

        protected abstract long getSize() throws IOException;
    }

    private static class ZipFileObject
    extends ZipFileBase {
        protected final File archiveFile;

        ZipFileObject(File archiveFile, String folderName, String baseName, long mtime) {
            super(folderName, baseName, mtime);
            assert (archiveFile != null) : "archiveFile == null";
            this.archiveFile = archiveFile;
        }

        public InputStream openInputStream() throws IOException {
            ZipFile zf = new ZipFile(this.archiveFile);
            class ZipInputStream
            extends InputStream {
                private ZipFile zipfile;
                private InputStream delegate;

                public ZipInputStream(ZipFile zf) throws IOException {
                    if (!$assertionsDisabled && zf == null) {
                        throw new AssertionError();
                    }
                    this.zipfile = zf;
                    try {
                        this.delegate = zf.getInputStream(new ZipEntry(ZipFileObject.this.resName));
                        if (this.delegate == null) {
                            throw new IOException();
                        }
                    }
                    catch (IOException e) {
                        try {
                            this.zipfile.close();
                        }
                        catch (IOException iOException) {}
                        throw e;
                    }
                }

                public int read() throws IOException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    return this.delegate.read(b, off, len);
                }

                public int available() throws IOException {
                    return this.delegate.available();
                }

                public void close() throws IOException {
                    try {
                        this.delegate.close();
                    }
                    finally {
                        this.zipfile.close();
                    }
                }
            }
            return new BufferedInputStream(new ZipInputStream(zf));
        }

        public URI getArchiveURI() {
            return this.archiveFile.toURI();
        }

        protected long getSize() throws IOException {
            ZipFile zf = new ZipFile(this.archiveFile);
            try {
                ZipEntry ze = zf.getEntry(this.resName);
                long l = ze == null ? 0L : ze.getSize();
                return l;
            }
            finally {
                zf.close();
            }
        }
    }
}

