/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import com.sun.javafx.eclipse.core.builder.classpath.ClassOutputBuffer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryFileManager
implements JavaFileManager {
    List<SimpleJavaFileObject> buffers = new ArrayList<SimpleJavaFileObject>();
    private static final String EXT = ".fx";

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ArrayList<JavaFileObject> results = new ArrayList<JavaFileObject>();
        return results;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof StringInputBuffer) {
            return ((StringInputBuffer)file).getBinaryName();
        }
        if (file instanceof ClassOutputBuffer) {
            return ((ClassOutputBuffer)file).getBinaryName();
        }
        if (file instanceof ClassInputBuffer) {
            return ((ClassInputBuffer)file).getBinaryName();
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        ClassOutputBuffer buf = new ClassOutputBuffer(className);
        this.buffers.add(buf);
        return buf;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int isSupportedOption(String option) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            StringBuilder newUri = new StringBuilder();
            newUri.append("mfm:///");
            newUri.append(name.replace('.', '/'));
            if (name.endsWith(EXT)) {
                newUri.replace(newUri.length() - EXT.length(), newUri.length(), EXT);
            }
            return URI.create(newUri.toString());
        }
        catch (Exception exception) {
            return URI.create("mfm:///com/sun/tools/javafx/script/javafx_source");
        }
    }

    private class ClassInputBuffer
    extends SimpleJavaFileObject {
        private String name;
        byte[] buf;

        ClassInputBuffer(String name, byte[] buf) {
            super(MemoryFileManager.toURI(name), JavaFileObject.Kind.CLASS);
            this.name = name;
            this.buf = buf;
        }

        public String getBinaryName() {
            return this.name;
        }

        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.buf);
        }
    }

    private static class StringInputBuffer
    extends SimpleJavaFileObject {
        final String code;
        final boolean isFXSourceFile;
        String binaryName;

        public String getBinaryName() {
            return this.binaryName.equals("__FX_SCRIPT__.fx") ? "__FX_SCRIPT__" : this.binaryName;
        }

        StringInputBuffer(String name, String code) {
            super(MemoryFileManager.toURI(name), JavaFileObject.Kind.SOURCE);
            this.code = code;
            this.binaryName = name;
            this.isFXSourceFile = name.endsWith(MemoryFileManager.EXT);
        }

        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            return CharBuffer.wrap(this.code);
        }

        public Reader openReader() {
            return new StringReader(this.code);
        }

        public JavaFileObject.Kind getKind() {
            return JavaFileObject.Kind.SOURCE;
        }

        public String getName() {
            return super.getName();
        }

        public NestingKind getNestingKind() {
            return super.getNestingKind();
        }

        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return super.isNameCompatible(simpleName, kind);
        }

        public InputStream openInputStream() throws IOException {
            return super.openInputStream();
        }

        public OutputStream openOutputStream() throws IOException {
            return super.openOutputStream();
        }

        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return super.openReader(ignoreEncodingErrors);
        }

        public Writer openWriter() throws IOException {
            return super.openWriter();
        }
    }
}

