/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.builder.classpath;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.CharBuffer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;

public class SourceFileObject
implements JavaFileObject {
    final IFile file;
    final IFolder root;
    private final JavaFileObject.Kind kind;
    private URI uri;
    private String text;

    public static SourceFileObject create(IFile file, IFolder root) {
        try {
            return new SourceFileObject(file, root);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public SourceFileObject(IFile file, IFolder root) throws IOException {
        assert (file != null);
        this.file = file;
        this.root = root;
        this.kind = JavaFileObject.Kind.SOURCE;
    }

    public boolean isNameCompatible(String simplename, JavaFileObject.Kind kind) {
        assert (simplename != null);
        return this.kind == kind && this.getNameWithoutExtension().equals(simplename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return CharBuffer.wrap(_text);
        }
        return this.getCharContentImpl(false);
    }

    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return new StringReader(_text);
        }
        try {
            return new InputStreamReader(this.file.getContents(), this.file.getCharset());
        }
        catch (CoreException e) {
            throw new IOException("CoreException: " + e.getMessage());
        }
    }

    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return new ByteArrayInputStream(_text.getBytes());
        }
        try {
            return this.file.getContents();
        }
        catch (CoreException e) {
            throw new IOException("CoreException: " + e.getMessage());
        }
    }

    public boolean delete() {
        try {
            this.file.delete(false, null);
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getNameWithoutExtension() {
        return this.file.getName();
    }

    public synchronized URI toUri() {
        if (this.uri == null) {
            this.uri = this.file.getLocationURI();
        }
        return this.uri;
    }

    public long getLastModified() {
        try {
            if (this.file.getLocationURI().toURL().toExternalForm().startsWith("jar:")) {
                return 0L;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this.file.getModificationStamp();
    }

    public NestingKind getNestingKind() {
        return null;
    }

    public Modifier getAccessLevel() {
        return null;
    }

    public String toString() {
        return this.file.getFullPath().toOSString();
    }

    public boolean equals(Object other) {
        if (other instanceof SourceFileObject) {
            SourceFileObject otherSource = (SourceFileObject)other;
            return this.file.equals((Object)otherSource.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private CharBuffer getCharContentImpl(boolean assign) throws IOException {
        StringBuffer sb = new StringBuffer();
        Reader in = this.openReader(true);
        try {
            try {
                int len;
                IFileStore store = EFS.getStore((URI)this.file.getLocationURI());
                store.fetchInfo();
                char[] mem = new char[1024];
                while ((len = in.read(mem)) >= 0) {
                    sb.append(new String(mem, 0, len));
                }
            }
            catch (CoreException e) {
                throw new IOException("CoreException: " + e.getMessage());
            }
        }
        finally {
            in.close();
        }
        CharBuffer charBuffer = CharBuffer.wrap(sb);
        if (assign) {
            this.text = sb.toString();
        }
        return charBuffer;
    }
}

