/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.classpath;

import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SDKClasspathContainer
implements IClasspathContainer {
    public static final IPath CONTAINER_ID = new Path("com.sun.javafx.eclipse.core.classpath.SDKClasspathContainer");
    public static final String ATTR_PROFILE = "profile";
    private final String profile;

    public SDKClasspathContainer(String profile) {
        this.profile = profile;
    }

    public IClasspathEntry[] getClasspathEntries() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        Map<String, String> properties = JavaFXSDK.getProfileProperties(JavaFXSDK.getSDKPathFromPreferences(), this.profile);
        for (String path : JavaFXSDK.getSDKCompileBootClassPath(properties)) {
            entries.add(JavaCore.newLibraryEntry((IPath)new Path(path), null, null));
        }
        for (String path : JavaFXSDK.getSDKCompileClassPath(properties)) {
            entries.add(JavaCore.newLibraryEntry((IPath)new Path(path), null, null));
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    public String getDescription() {
        return "JavaFX System Library";
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return CONTAINER_ID;
    }

    public static void assignSDKClasspathContainerToJavaProject(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return;
        }
        if (SDKClasspathContainer.getSDKClasspathContainerEntryFromProject(javaProject) != null) {
            return;
        }
        try {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>((Collection)Arrays.asList(classpath));
            IClasspathEntry sdkEntry = JavaCore.newContainerEntry((IPath)CONTAINER_ID);
            entries.add(sdkEntry);
            classpath = entries.toArray(new IClasspathEntry[entries.size()]);
            javaProject.setRawClasspath(classpath, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static IClasspathEntry getSDKClasspathContainerEntryFromProject(IJavaProject javaProject) {
        IClasspathEntry[] classpath;
        try {
            classpath = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
        if (classpath != null) {
            IClasspathEntry[] iClasspathEntryArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && CONTAINER_ID.equals((Object)entry.getPath())) {
                    return entry;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void refreshClasspathContainerEntryForAllProjects() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("com.sun.javafx.eclipse.core.javafxNature")) {
                    SDKClasspathContainer.assignSDKClasspathContainerToJavaProject(project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }
}

