/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.classpath;

import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.OS;
import com.sun.javafx.eclipse.core.classpath.SDKClasspathContainer;
import com.sun.javafx.eclipse.core.classpath.SDKClasspathContainerPreferencePage;
import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SDKClasspathVariableInitializer
extends ClasspathVariableInitializer {
    public static final String VARIABLE_ID = "JAVAFX_HOME";

    public void initialize(String variable) {
        if (!VARIABLE_ID.equals(variable)) {
            return;
        }
        IPath value = JavaCore.getClasspathVariable((String)VARIABLE_ID);
        if (value == null) {
            String location = OS.isWindows() ? "C:\\Program Files\\JavaFX\\javafx-sdk1.0" : (OS.isMac() ? "/System/Library/Frameworks/JavaFX.framework/Versions/Current" : (OS.isUnix() ? "/usr/lib/javafx/javafx-sdk1.0" : null));
            if (!JavaFXSDK.isValidSDK(location)) {
                location = this.findFromPathEnvVar();
            }
            if (location != null) {
                value = new Path(location);
            }
        }
        if (value == null) {
            value = new Path("");
        }
        try {
            JavaCore.setClasspathVariable((String)VARIABLE_ID, (IPath)value, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SDKClasspathVariableInitializer.uiCheckForMissingJavaFX();
            }
        });
    }

    private static void uiCheckForMissingJavaFX() {
        String sdkPath = JavaFXSDK.getSDKPathFromPreferences();
        if (!JavaFXSDK.isValidSDK(sdkPath) && !Activator.getDefault().getPreferenceStore().getBoolean("DoNotNotifyWhenMissingJavaFXSDK")) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Shell shell = display.getActiveShell();
            MessageBox box = new MessageBox(shell, 289);
            box.setMessage("JavaFX SDK is not detected on the JAVAFX_HOME location.\nPress OK to setup or Cancel to ignore and disable this notification.");
            box.setText("Missing JavaFX SDK");
            int result = box.open();
            if (result == 32) {
                SDKClasspathContainerPreferencePage.openVariablesPreferences(shell);
                SDKClasspathContainer.refreshClasspathContainerEntryForAllProjects();
            } else if (result == 256) {
                Activator.getDefault().getPreferenceStore().setValue("DoNotNotifyWhenMissingJavaFXSDK", true);
            }
        }
    }

    private String findFromPathEnvVar() {
        String pathString = System.getenv("PATH");
        if (pathString == null) {
            return null;
        }
        String[] stringArray = pathString.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String pathElement = stringArray[n2];
                if (new File(pathElement).isDirectory()) {
                    String location;
                    try {
                        File sdkRootDir;
                        File packagerFile = new File(pathElement, OS.isWindows() ? "javafxpackager.exe" : "javafxpackager").getCanonicalFile();
                        File binDir = packagerFile.getParentFile();
                        if (!binDir.exists() || !(sdkRootDir = binDir.getParentFile()).exists()) break block6;
                        location = sdkRootDir.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        break block6;
                    }
                    if (JavaFXSDK.isValidSDK(location)) {
                        return location;
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

