/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AppletLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private ILaunchConfigurationDialog dialog;
    private Composite control;
    private Text fieldAppWidth;
    private Text fieldAppHeight;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public boolean canSave() {
        return true;
    }

    public void createControl(Composite parent) {
        this.dispose();
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, false));
        Label usedLabel = new Label(this.control, 0);
        usedLabel.setText("Used for 'Desktop profile - Run as Applet' profile/target only");
        usedLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createAppletSizeGroup(this.control);
        Label overrideLabel = new Label(this.control, 0);
        overrideLabel.setText("Overrides the 'JavaFX Defaults' values from the project preferences.");
        overrideLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createAppletSizeGroup(Composite rootComposite) {
        Group sizeGroup = new Group(rootComposite, 0);
        sizeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        sizeGroup.setText("Applet Size (optional)");
        sizeGroup.setLayout((Layout)new GridLayout(2, false));
        Label widthLabel = new Label((Composite)sizeGroup, 0);
        widthLabel.setText("Applet Width:");
        widthLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fieldAppWidth = new Text((Composite)sizeGroup, 2052);
        this.fieldAppWidth.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fieldAppWidth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AppletLaunchConfigurationTab.this.notifyModified();
            }
        });
        Label heightLabel = new Label((Composite)sizeGroup, 0);
        heightLabel.setText("Applet Height:");
        heightLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fieldAppHeight = new Text((Composite)sizeGroup, 2052);
        this.fieldAppHeight.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fieldAppHeight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AppletLaunchConfigurationTab.this.notifyModified();
            }
        });
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
        if (this.control == null) {
            return;
        }
        this.control.dispose();
        this.control = null;
        this.fieldAppWidth = null;
        this.fieldAppHeight = null;
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getName() {
        return "Applet";
    }

    private void notifyModified() {
        if (this.dialog != null) {
            this.dialog.updateButtons();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fieldAppWidth.setText(configuration.getAttribute("JavaFXLaunchAppletWidth", ""));
            this.fieldAppHeight.setText(configuration.getAttribute("JavaFXLaunchAppletHeight", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public void launched(ILaunch launch) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("JavaFXLaunchAppletWidth", this.fieldAppWidth.getText());
        configuration.setAttribute("JavaFXLaunchAppletHeight", this.fieldAppHeight.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.dialog = dialog;
    }
}

