/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.launch;

import com.sun.javafx.eclipse.core.JavaUISupport;
import com.sun.javafx.eclipse.core.launch.LaunchConstants;
import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GeneralLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private ILaunchConfigurationDialog dialog;
    private Composite control;
    private Label fieldSDK;
    private Text fieldProjectName;
    private Button fieldProjectNameButton;
    private Combo fieldTarget;
    private Text fieldMainClass;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public boolean canSave() {
        return true;
    }

    public void createControl(Composite parent) {
        this.dispose();
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, false));
        this.createSDKGroup(this.control);
        this.createProjectGroup(this.control);
        this.createTargetGroup(this.control);
        this.createMainClassGroup(this.control);
    }

    private void createSDKGroup(Composite rootComposite) {
        Group sdkGroup = new Group(rootComposite, 0);
        sdkGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        sdkGroup.setText("JavaFX SDK (required)");
        sdkGroup.setLayout((Layout)new GridLayout(1, false));
        this.fieldSDK = new Label((Composite)sdkGroup, 2048);
        this.fieldSDK.setLayoutData((Object)new GridData(4, 2, true, false));
        Label argumentsLabel = new Label((Composite)sdkGroup, 0);
        argumentsLabel.setText("Edit in MainMenu -> Project -> Properties -> Java Build Path -> Libraries -> JavaFX System Library -> Edit");
        argumentsLabel.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private void createProjectGroup(Composite rootComposite) {
        Group projectGroup = new Group(rootComposite, 0);
        projectGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        projectGroup.setText("JavaFX Project (required)");
        projectGroup.setLayout((Layout)new GridLayout(2, false));
        this.fieldProjectName = new Text((Composite)projectGroup, 2052);
        this.fieldProjectName.setLayoutData((Object)new GridData(4, 2, true, false));
        this.fieldProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralLaunchConfigurationTab.this.notifyModified();
            }
        });
        this.fieldProjectNameButton = new Button((Composite)projectGroup, 8);
        this.fieldProjectNameButton.setLayoutData((Object)new GridData(2, 2, false, false));
        this.fieldProjectNameButton.setText("Browse");
        this.fieldProjectNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String prj = JavaUISupport.getJavaProjectName(JavaUISupport.chooseJavaProject(GeneralLaunchConfigurationTab.this.control.getShell(), GeneralLaunchConfigurationTab.this.getJavaProject()));
                if (prj != null) {
                    GeneralLaunchConfigurationTab.this.fieldProjectName.setText(prj);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTargetGroup(Composite rootComposite) {
        Group targetGroup = new Group(rootComposite, 0);
        targetGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        targetGroup.setText("Profile - Target (required)");
        targetGroup.setLayout((Layout)new GridLayout(1, false));
        this.fieldTarget = new Combo((Composite)targetGroup, 2052);
        this.fieldTarget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fieldTarget.setItems(LaunchConstants.LIST_DESC_TARGET);
        this.fieldTarget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLaunchConfigurationTab.this.notifyModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createMainClassGroup(Composite rootComposite) {
        Group mainGroup = new Group(rootComposite, 0);
        mainGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        mainGroup.setText("Main Class (required)");
        mainGroup.setLayout((Layout)new GridLayout(1, false));
        this.fieldMainClass = new Text((Composite)mainGroup, 2052);
        this.fieldMainClass.setLayoutData((Object)new GridData(4, 2, true, false));
        this.fieldMainClass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralLaunchConfigurationTab.this.notifyModified();
            }
        });
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
        if (this.control == null) {
            return;
        }
        this.control.dispose();
        this.control = null;
        this.fieldSDK = null;
        this.fieldProjectName = null;
        this.fieldProjectNameButton = null;
        this.fieldTarget = null;
        this.fieldMainClass = null;
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getName() {
        return "General";
    }

    private void notifyModified() {
        if (this.dialog != null) {
            this.dialog.updateButtons();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            IJavaElement javaElement = JavaUISupport.getActiveJavaElement();
            String name = javaElement != null ? JavaUISupport.getJavaProjectName(javaElement.getJavaProject()) : "";
            String target = configuration.getAttribute("JavaFXLaunchTarget", "deskop/jar");
            String targetDesc = LaunchConstants.getTargetDesc(target);
            if (targetDesc == null) {
                targetDesc = "Desktop profile - Run as Application";
            }
            this.fieldSDK.setText(JavaFXSDK.getSDKValidityTextFromPreferences());
            this.fieldProjectName.setText(configuration.getAttribute("JavaFXLaunchProjectName", name));
            this.fieldTarget.setText(targetDesc);
            this.fieldMainClass.setText(configuration.getAttribute("JavaFXLaunchMainClass", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public void launched(ILaunch launch) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("JavaFXLaunchProjectName", this.fieldProjectName.getText());
        int targetIndex = this.fieldTarget.getSelectionIndex();
        configuration.setAttribute("JavaFXLaunchTarget", targetIndex >= 0 ? LaunchConstants.LIST_ATTR_TARGET[targetIndex] : "deskop/jar");
        configuration.setAttribute("JavaFXLaunchMainClass", this.fieldMainClass.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.dialog = dialog;
    }

    private IJavaProject getJavaProject() {
        String projectName = this.fieldProjectName.getText().trim();
        if (projectName.length() == 0) {
            return null;
        }
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(projectName);
    }
}

