/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.launch;

import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.JavaFXProject;
import com.sun.javafx.eclipse.core.jetty.JettyRun;
import com.sun.javafx.eclipse.core.launch.LaunchConstants;
import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        List<IResource> libraryPath;
        String appHeight;
        monitor.beginTask("Packaging JavaFX Application", 2);
        IProject project = LaunchConfigurationDelegate.getProject(configuration);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        JavaFXProject javafxProject = JavaFXProject.create(project);
        IPersistentPreferenceStore projectPreferenceStore = javafxProject.getPreferenceStore();
        String javafxpackagerLauncher = JavaFXSDK.getSDKLauncherFromPreferences("javafxpackager");
        String mainClass = configuration.getAttribute("JavaFXLaunchMainClass", null);
        String tempDirectory = project.getFolder((IPath)new Path("temp/")).getLocation().toOSString();
        String distDirectory = project.getFolder((IPath)new Path("dist/")).getLocation().toOSString();
        String target = configuration.getAttribute("JavaFXLaunchTarget", "deskop/jar");
        boolean useCustomJDKHome = projectPreferenceStore.getBoolean("UseCustomJDKHome");
        String customJDKHome = projectPreferenceStore.getString("CustomJDKHome");
        String appName = projectPreferenceStore.getString("ApplicationName");
        String appVendor = projectPreferenceStore.getString("ApplicationVendor");
        String appVersion = projectPreferenceStore.getString("ApplicationVersion");
        String appCodebase = projectPreferenceStore.getString("ApplicationCodebase");
        String appWidth = configuration.getAttribute("JavaFXLaunchAppletWidth", "");
        if (LaunchConfigurationDelegate.isEmpty(appWidth)) {
            appWidth = projectPreferenceStore.getString("AppletWidth");
        }
        if (LaunchConfigurationDelegate.isEmpty(appHeight = configuration.getAttribute("JavaFXLaunchAppletHeight", ""))) {
            appHeight = projectPreferenceStore.getString("AppletHeight");
        }
        boolean draggable = projectPreferenceStore.getBoolean("Draggable");
        boolean verbose = projectPreferenceStore.getBoolean("Verbose");
        boolean pack200 = projectPreferenceStore.getBoolean("Pack200");
        boolean sign = projectPreferenceStore.getBoolean("Sign");
        String keystore = projectPreferenceStore.getString("Keystore");
        String keystorePassword = projectPreferenceStore.getString("KeystorePassword");
        String alias = projectPreferenceStore.getString("Alias");
        String aliasPassword = projectPreferenceStore.getString("AliasPassword");
        if (!"run".equals(mode)) {
            this.errorHappened("Unsupported mode (" + mode + ") is invoked.", "'Run JavaFX Application' is allowed only.", monitor);
            return;
        }
        if (javaProject == null || !javaProject.exists() || javafxProject == null) {
            this.errorHappened("The project has to be Java Project with JavaFX Nature.", "Add the nature using 'JavaFX -> Add JavaFX Nature' popup menu on a Java project node.", monitor);
            return;
        }
        if (javafxpackagerLauncher == null) {
            this.errorHappened("JavaFX SDK is not setup correctly.", "Fix 'JAVAFX_HOME' variable at 'MainMenu -> Project -> Properties -> Java Build Path -> Libraries -> JavaFX System Library -> Edit'", monitor);
            return;
        }
        if (mainClass == null || mainClass.length() == 0) {
            this.errorHappened("The application main class or script is not specified.", "Specify it at your configuration (" + configuration.getName() + ").", monitor);
            return;
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(javafxpackagerLauncher);
        List<IFile> sourcePath = javafxProject.getSourcePath();
        if (!sourcePath.isEmpty()) {
            commandLine.add("-src");
            commandLine.add(JavaFXProject.fileListToOSPath(sourcePath, ";"));
        }
        if (!(libraryPath = javafxProject.getLibraryPath()).isEmpty()) {
            commandLine.add("-cp");
            commandLine.add(JavaFXProject.fileListToOSPath(libraryPath, ";"));
        }
        commandLine.add("-workDir");
        commandLine.add(tempDirectory);
        commandLine.add("-d");
        commandLine.add(distDirectory);
        commandLine.add("-p");
        commandLine.add(LaunchConstants.getProfile(target));
        commandLine.add("-appClass");
        commandLine.add(mainClass);
        if (!LaunchConfigurationDelegate.isEmpty(appName)) {
            commandLine.add("-appName");
            commandLine.add(appName);
        }
        if (!LaunchConfigurationDelegate.isEmpty(appVendor)) {
            commandLine.add("-appVendor");
            commandLine.add(appVendor);
        }
        if (!LaunchConfigurationDelegate.isEmpty(appVersion)) {
            commandLine.add("-appVersion");
            commandLine.add(appVersion);
        }
        if (!LaunchConfigurationDelegate.isEmpty(appCodebase)) {
            commandLine.add("-appCodebase");
            commandLine.add(appCodebase);
        }
        if (!LaunchConfigurationDelegate.isEmpty(appWidth)) {
            commandLine.add("-appWidth");
            commandLine.add(appWidth);
        }
        if (!LaunchConfigurationDelegate.isEmpty(appHeight)) {
            commandLine.add("-appHeight");
            commandLine.add(appHeight);
        }
        if (draggable) {
            commandLine.add("-draggable");
        }
        if (pack200) {
            commandLine.add("-pack200");
        }
        if (verbose) {
            commandLine.add("-verbose");
        }
        if (sign) {
            commandLine.add("-sign");
            if (!LaunchConfigurationDelegate.isEmpty(keystore)) {
                commandLine.add("-keystore");
                commandLine.add(keystore);
            }
            if (!LaunchConfigurationDelegate.isEmpty(keystorePassword)) {
                commandLine.add("-keystorePassword");
                commandLine.add(keystorePassword);
            }
            if (!LaunchConfigurationDelegate.isEmpty(alias)) {
                commandLine.add("-alias");
                commandLine.add(alias);
            }
            if (!LaunchConfigurationDelegate.isEmpty(aliasPassword)) {
                commandLine.add("-aliasPassword");
                commandLine.add(aliasPassword);
            }
        }
        HashMap<String, String> envs = null;
        if (useCustomJDKHome && !LaunchConfigurationDelegate.isEmpty(customJDKHome)) {
            envs = new HashMap<String, String>();
            envs.put("JAVA_HOME", customJDKHome);
        }
        Activator.trace("Packaging JavaFX Application: " + commandLine, null);
        if (!LaunchConfigurationDelegate.execute(launch, commandLine, envs)) {
            this.errorHappened("Error happened while packaging JavaFX application.\nCommand line: " + commandLine, "Check the launch console output for errors.", monitor);
            return;
        }
        monitor.worked(1);
        monitor.setTaskName("Running the JavaFX application");
        List<String> runCmdLine = null;
        if ("deskop/jar".equals(target)) {
            runCmdLine = LaunchConfigurationDelegate.createDesktopJarCommandLine(String.valueOf(distDirectory) + File.separator + LaunchConfigurationDelegate.getAppName(mainClass) + ".jar", mainClass, LaunchConfigurationDelegate.getArguments(configuration));
        } else if ("desktop/html".equals(target)) {
            try {
                JettyRun.serve(configuration.getName(), LaunchConfigurationDelegate.getAppName(mainClass), distDirectory);
            }
            catch (Exception exception) {
                this.errorHappened("Error happened while opening an external web-browser.", "Check the web-browser settings.", monitor);
                return;
            }
        } else if ("desktop/jnlp".equals(target)) {
            runCmdLine = LaunchConfigurationDelegate.createDesktopJnlpCommandLine(String.valueOf(distDirectory) + File.separator + LaunchConfigurationDelegate.getAppName(mainClass) + ".jnlp");
        } else if ("mobile/emulator".equals(target)) {
            runCmdLine = LaunchConfigurationDelegate.createMobileEmulatorCommandLine(String.valueOf(distDirectory) + File.separator + LaunchConfigurationDelegate.getAppName(mainClass) + ".jad");
        }
        Activator.trace("Running JavaFX Application: " + runCmdLine, null);
        if (runCmdLine != null && !LaunchConfigurationDelegate.execute(launch, runCmdLine, envs)) {
            this.errorHappened("Error happened while running JavaFX application.\nCommand line: " + runCmdLine, "Check the launch console output for errors.", monitor);
            return;
        }
        monitor.worked(1);
    }

    private void errorHappened(final String error, final String fix, IProgressMonitor monitor) throws CoreException {
        monitor.setCanceled(true);
        LaunchConfigurationDelegate.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageBox message = new MessageBox(LaunchConfigurationDelegate.getShell(), 65569);
                message.setMessage("Cannot run JavaFX Application\nReason: " + error + "\nSolution: " + fix + "\n");
                message.open();
            }
        });
        throw new CoreException(Status.CANCEL_STATUS);
    }

    private static List<String> createDesktopJarCommandLine(String jarFile, String mainClass, String[] arguments) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(JavaFXSDK.getSDKLauncherFromPreferences("javafx"));
        commandLine.add("-cp");
        commandLine.add(jarFile);
        commandLine.add(mainClass);
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            commandLine.add(arg);
            ++n2;
        }
        return commandLine;
    }

    private static List<String> createDesktopJnlpCommandLine(String jnlpFile) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("javaws");
        commandLine.add(jnlpFile);
        return commandLine;
    }

    private static List<String> createMobileEmulatorCommandLine(String jadFile) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(JavaFXSDK.getSDKEmulatorLauncherFromPreferences("emulator"));
        commandLine.add("-Xdescriptor:" + jadFile);
        return commandLine;
    }

    private static boolean execute(ILaunch launch, List<String> commandLine, Map<String, String> envMap) {
        try {
            ArrayList<String> envList;
            if (envMap != null) {
                HashMap<String, String> map = new HashMap<String, String>(System.getenv());
                map.putAll(envMap);
                envList = new ArrayList<String>();
                for (Map.Entry<String, String> entry : envMap.entrySet()) {
                    envList.add(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                }
            } else {
                envList = null;
            }
            Process process = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()]), envList != null ? envList.toArray(new String[envList.size()]) : null);
            launch.addProcess((IProcess)new RuntimeProcess(launch, process, "JavaFX Application", null));
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = LaunchConfigurationDelegate.getProjectName(configuration);
        if (projectName != null && projectName.trim().length() != 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    private static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("JavaFXLaunchProjectName", null);
    }

    private static String[] getArguments(ILaunchConfiguration configuration) throws CoreException {
        String argumentsString = configuration.getAttribute("JavaFXLaunchArguments", "");
        return argumentsString.split("\n");
    }

    private static String getAppName(String mainClass) {
        int i = mainClass.lastIndexOf(46);
        return i >= 0 ? mainClass.substring(i + 1) : mainClass;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }
}

