/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.preferences;

import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.JavaFXProject;
import com.sun.javafx.eclipse.core.sdk.JavaFXSDK;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class ProjectPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private IAdaptable element;

    public ProjectPreferencePage() {
        super(1);
        this.setElement(null);
    }

    protected void createFieldEditors() {
        TabFolder tab = new TabFolder(this.getFieldEditorParent(), 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        tab.setLayoutData((Object)gd);
        Composite sdkGroup = this.addGroup(tab, "JavaFX SDK");
        this.addLabel("JavaFX SDK:", 0, sdkGroup, 1, false);
        this.addLabel(JavaFXSDK.getSDKValidityTextFromPreferences(), 2048, sdkGroup, 1, true);
        this.addLabel("Edit in MainMenu -> Project -> Properties -> Java Build Path -> Libraries -> JavaFX System Library -> Edit", 0, sdkGroup, 2, true);
        this.addLabel(null, 258, sdkGroup, 2, true);
        this.addBoolean("UseCustomJDKHome", "Use Custom JDK Home", sdkGroup);
        this.addString("CustomJDKHome", "JDK Home:", sdkGroup);
        this.addLabel("Use this option only to override your default Java/JDK Home", 0, sdkGroup, 2, true);
        Composite applicationGroup = this.addGroup(tab, "Application");
        this.addString("ApplicationName", "&Name:", applicationGroup);
        this.addString("ApplicationVendor", "V&endor:", applicationGroup);
        this.addString("ApplicationVersion", "&Version:", applicationGroup);
        this.addString("ApplicationCodebase", "&Codebase:", applicationGroup);
        Composite appletGroup = this.addGroup(tab, "Applet");
        this.addString("AppletWidth", "&Width:", appletGroup);
        this.addString("AppletHeight", "&Height:", appletGroup);
        this.addBoolean("Draggable", "&Draggable", appletGroup);
        Composite signingGroup = this.addGroup(tab, "Signing");
        this.addBoolean("Sign", "&Sign Application", signingGroup);
        this.addString("Keystore", "&Keystore:", signingGroup);
        this.addString("KeystorePassword", "Ke&ystore Password:", signingGroup);
        this.addString("Alias", "&Alias:", signingGroup);
        this.addString("AliasPassword", "A&lias Password:", signingGroup);
        Composite advancedGroup = this.addGroup(tab, "Advanced");
        this.addBoolean("Pack200", "&Use Pack200 Compression", advancedGroup);
        this.addBoolean("Verbose", "Ve&rbose Messages", advancedGroup);
    }

    private Composite addGroup(TabFolder parent, String text) {
        TabItem item = new TabItem(parent, 0);
        item.setText(text);
        Composite group = new Composite((Composite)parent, 0);
        group.setLayout((Layout)new GridLayout());
        item.setControl((Control)group);
        Composite g2 = new Composite(group, 0);
        g2.setLayoutData((Object)new GridData(4, 4, true, true));
        g2.setLayout((Layout)new GridLayout(2, false));
        return g2;
    }

    private void addLabel(String text, int style, Composite group, int columns, boolean expand) {
        Label label = new Label(group, style);
        if (text != null) {
            label.setText(text);
        }
        GridData gridData = new GridData(expand ? 4 : 16384, 0x1000000, expand, false);
        gridData.horizontalSpan = columns;
        label.setLayoutData((Object)gridData);
    }

    private void addString(String preference, String text, Composite group) {
        StringFieldEditor editor = new StringFieldEditor(preference, text, group);
        editor.fillIntoGrid(group, 2);
        this.addField((FieldEditor)editor);
    }

    private void addBoolean(String preference, String text, Composite group) {
        BooleanFieldEditor editor = new BooleanFieldEditor(preference, text, group);
        editor.fillIntoGrid(group, 2);
        this.addField((FieldEditor)editor);
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        JavaFXProject prj;
        this.element = element;
        if (element != null && (prj = JavaFXProject.create((IProject)element.getAdapter(IProject.class))) != null) {
            this.setPreferenceStore((IPreferenceStore)prj.getPreferenceStore());
            return;
        }
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }
}

