/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.core.wizards;

import com.sun.javafx.eclipse.core.Activator;
import com.sun.javafx.eclipse.core.FXPerspectiveFactory;
import com.sun.javafx.eclipse.core.builder.ToggleNatureAction;
import com.sun.javafx.eclipse.core.wizards.NewFXScriptWizardPage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewFXScriptWizard
extends Wizard
implements INewWizard {
    private NewFXScriptWizardPage page;
    private IStructuredSelection selection;
    private final String templateName;

    public NewFXScriptWizard(String templateName) {
        this.templateName = templateName;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewFXScriptWizardPage();
        this.addPage((IWizardPage)this.page);
        if (this.selection != null) {
            this.page.init(this.selection);
        }
    }

    public boolean performFinish() {
        final String containerName = String.valueOf(this.page.getPackageFragmentRootText()) + File.separator + this.page.getPackageText().replace('.', File.separatorChar);
        final String fileName = String.valueOf(this.page.getTypeName()) + ".fx";
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewFXScriptWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException == null) {
                realException = e;
            }
            Activator.log(realException);
            String eText = realException.getMessage();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)(eText == null ? realException.getClass().toString() : eText));
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 3);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            String packageStatement = this.page.getPackageText();
            if (packageStatement.length() != 0) {
                packageStatement = "package " + packageStatement + ";";
            }
            String document = NewFXScriptWizard.stream2string(this.openContentStream(), packageStatement, this.page.getTypeName(), System.getProperty("user.name"));
            ByteArrayInputStream stream = new ByteArrayInputStream(document.getBytes());
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, monitor);
            } else {
                file.create((InputStream)stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                FXPerspectiveFactory.activatePerspective();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    Activator.log(e);
                }
            }
        });
        monitor.worked(1);
        monitor.setTaskName("Adding JavaFX nature to the project...");
        ToggleNatureAction.addNature(container.getProject());
        monitor.worked(1);
    }

    private static String stream2string(InputStream stream, String packageStatement, String typeName, String author) throws IOException {
        String line;
        String lineSeparator = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            line = line.replace("##PACKAGE_STATEMENT##", packageStatement);
            line = line.replace("##TYPE##", typeName);
            line = line.replace("##AUTHOR##", author);
            sb.append(line).append(lineSeparator);
        }
        br.close();
        return sb.toString();
    }

    private InputStream openContentStream() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/javafx/eclipse/core/wizards/templates/" + this.templateName + ".fx");
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.sun.javafx.eclipse.core", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (this.page != null) {
            this.page.init(selection);
        }
    }
}

