/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.tools.javac.util.LayoutCharacters;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.TagImpl;

class SeeTagImpl
extends TagImpl
implements SeeTag,
LayoutCharacters {
    private String where;
    private String what;
    private PackageDoc referencedPackage;
    private ClassDoc referencedClass;
    private MemberDoc referencedMember;
    String label = "";

    SeeTagImpl(DocImpl holder, String name, String text) {
        super(holder, name, text);
        this.parseSeeString();
        if (this.where != null) {
            ClassDocImpl container = null;
            if (holder instanceof MemberDoc) {
                container = (ClassDocImpl)((ProgramElementDoc)((Object)holder)).containingClass();
            } else if (holder instanceof ClassDoc) {
                container = (ClassDocImpl)holder;
            }
            this.findReferenced(container);
        }
    }

    public String referencedClassName() {
        return this.where;
    }

    public PackageDoc referencedPackage() {
        return this.referencedPackage;
    }

    public ClassDoc referencedClass() {
        return this.referencedClass;
    }

    public String referencedMemberName() {
        return this.what;
    }

    public MemberDoc referencedMember() {
        return this.referencedMember;
    }

    private void parseSeeString() {
        int sharp;
        int start;
        int cp;
        int len = this.text.length();
        if (len == 0) {
            return;
        }
        switch (this.text.charAt(0)) {
            case '<': {
                if (this.text.charAt(len - 1) != '>') {
                    this.docenv().warning(this.holder, "tag.see.no_close_bracket_on_url", this.name, this.text);
                }
                return;
            }
            case '\"': {
                if (len == 1 || this.text.charAt(len - 1) != '\"') {
                    this.docenv().warning(this.holder, "tag.see.no_close_quote", this.name, this.text);
                }
                return;
            }
        }
        int parens = 0;
        int commentstart = 0;
        block11: for (int i = start = 0; i < len; i += Character.charCount(cp)) {
            cp = this.text.codePointAt(i);
            switch (cp) {
                case 40: {
                    ++parens;
                    continue block11;
                }
                case 41: {
                    --parens;
                    continue block11;
                }
                case 35: 
                case 46: 
                case 91: 
                case 93: {
                    continue block11;
                }
                case 44: {
                    if (parens > 0) continue block11;
                    this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (parens != 0) continue block11;
                    commentstart = i;
                    i = len;
                    continue block11;
                }
                default: {
                    if (Character.isJavaIdentifierPart(cp)) continue block11;
                    this.docenv().warning(this.holder, "tag.see.illegal_character", this.name, "" + cp, this.text);
                }
            }
        }
        if (parens != 0) {
            this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
            return;
        }
        String seetext = "";
        String labeltext = "";
        if (commentstart > 0) {
            seetext = this.text.substring(start, commentstart);
            labeltext = this.text.substring(commentstart + 1);
            for (int i = 0; i < labeltext.length(); ++i) {
                char ch2 = labeltext.charAt(i);
                if (ch2 == ' ' || ch2 == '\t' || ch2 == '\n') continue;
                this.label = labeltext.substring(i);
                break;
            }
        } else {
            seetext = this.text;
            this.label = "";
        }
        if ((sharp = seetext.indexOf(35)) >= 0) {
            this.where = seetext.substring(0, sharp);
            this.what = seetext.substring(sharp + 1);
        } else if (seetext.indexOf(40) >= 0) {
            this.docenv().warning(this.holder, "tag.see.missing_sharp", this.name, this.text);
            this.where = "";
            this.what = seetext;
        } else {
            this.where = seetext;
            this.what = null;
        }
    }

    private void findReferenced(ClassDocImpl containingClass) {
        String memName;
        if (this.where.length() > 0) {
            this.referencedClass = containingClass != null ? containingClass.findClass(this.where) : this.docenv().lookupClass(this.where);
            if (this.referencedClass == null && this.holder() instanceof ProgramElementDoc) {
                this.referencedClass = this.docenv().lookupClass(((ProgramElementDoc)this.holder()).containingPackage().name() + "." + this.where);
            }
            if (this.referencedClass == null) {
                this.referencedPackage = this.docenv().lookupPackage(this.where);
                return;
            }
        } else {
            if (containingClass == null) {
                this.docenv().warning(this.holder, "tag.see.class_not_specified", this.name, this.text);
                return;
            }
            this.referencedClass = containingClass;
        }
        this.where = this.referencedClass.qualifiedName();
        if (this.what == null) {
            return;
        }
        int paren = this.what.indexOf(40);
        String string = memName = paren >= 0 ? this.what.substring(0, paren) : this.what;
        if (paren > 0) {
            String[] paramarr = new ParameterParseMachine(this.what.substring(paren, this.what.length())).parseParameters();
            this.referencedMember = paramarr != null ? this.findExecutableMember(memName, paramarr, this.referencedClass) : null;
        } else {
            this.referencedMember = this.findExecutableMember(memName, null, this.referencedClass);
            FieldDoc fd = ((ClassDocImpl)this.referencedClass).findField(memName);
            if (this.referencedMember == null || fd != null && fd.containingClass().subclassOf(this.referencedMember.containingClass())) {
                this.referencedMember = fd;
            }
        }
        if (this.referencedMember == null) {
            this.docenv().warning(this.holder, "tag.see.can_not_find_member", this.name, this.what, this.where);
        }
    }

    private MemberDoc findReferencedMethod(String memName, String[] paramarr, ClassDoc referencedClass) {
        MemberDoc meth = this.findExecutableMember(memName, paramarr, referencedClass);
        ClassDoc[] nestedclasses = referencedClass.innerClasses();
        if (meth == null) {
            for (int i = 0; i < nestedclasses.length; ++i) {
                meth = this.findReferencedMethod(memName, paramarr, nestedclasses[i]);
                if (meth == null) continue;
                return meth;
            }
        }
        return null;
    }

    private MemberDoc findExecutableMember(String memName, String[] paramarr, ClassDoc referencedClass) {
        if (memName.equals(referencedClass.name())) {
            return ((ClassDocImpl)referencedClass).findConstructor(memName, paramarr);
        }
        return ((ClassDocImpl)referencedClass).findMethod(memName, paramarr);
    }

    public String kind() {
        return "@see";
    }

    public String label() {
        return this.label;
    }

    class ParameterParseMachine {
        final int START = 0;
        final int TYPE = 1;
        final int NAME = 2;
        final int TNSPACE = 3;
        final int ARRAYDECORATION = 4;
        final int ARRAYSPACE = 5;
        String parameters;
        StringBuffer typeId;
        ListBuffer<String> paramList;

        ParameterParseMachine(String parameters) {
            this.parameters = parameters;
            this.paramList = new ListBuffer();
            this.typeId = new StringBuffer();
        }

        public String[] parseParameters() {
            int cp;
            if (this.parameters.equals("()")) {
                return new String[0];
            }
            int state = 0;
            int prevstate = 0;
            this.parameters = this.parameters.substring(1, this.parameters.length() - 1);
            block7: for (int index = 0; index < this.parameters.length(); index += Character.charCount(cp)) {
                cp = this.parameters.codePointAt(index);
                switch (state) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(cp)) {
                            this.typeId.append(Character.toChars(cp));
                            state = 1;
                        }
                        prevstate = 0;
                        continue block7;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(cp) || cp == 46) {
                            this.typeId.append(Character.toChars(cp));
                        } else if (cp == 91) {
                            this.typeId.append('[');
                            state = 4;
                        } else if (Character.isWhitespace(cp)) {
                            state = 3;
                        } else if (cp == 44) {
                            this.addTypeToParamList();
                            state = 0;
                        }
                        prevstate = 1;
                        continue block7;
                    }
                    case 3: {
                        if (Character.isJavaIdentifierStart(cp)) {
                            if (prevstate == 4) {
                                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.missing_comma_space", SeeTagImpl.this.name, "(" + this.parameters + ")");
                                return null;
                            }
                            this.addTypeToParamList();
                            state = 2;
                        } else if (cp == 91) {
                            this.typeId.append('[');
                            state = 4;
                        } else if (cp == 44) {
                            this.addTypeToParamList();
                            state = 0;
                        }
                        prevstate = 3;
                        continue block7;
                    }
                    case 4: {
                        if (cp == 93) {
                            this.typeId.append(']');
                            state = 3;
                        } else if (!Character.isWhitespace(cp)) {
                            SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_char_in_arr_dim", SeeTagImpl.this.name, "(" + this.parameters + ")");
                            return null;
                        }
                        prevstate = 4;
                        continue block7;
                    }
                    case 2: {
                        if (cp == 44) {
                            state = 0;
                        }
                        prevstate = 2;
                    }
                }
            }
            if (state == 4 || state == 0 && prevstate == 3) {
                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_see_tag", "(" + this.parameters + ")");
            }
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
            }
            return this.paramList.toArray(new String[this.paramList.length()]);
        }

        void addTypeToParamList() {
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
                this.typeId.setLength(0);
            }
        }
    }
}

