/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafxdoc;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.DocCommentScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Paths;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.main.JavafxCompiler;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.util.JavafxFileManager;
import com.sun.tools.javafxdoc.DocEnv;
import com.sun.tools.javafxdoc.JavadocTodo;
import com.sun.tools.javafxdoc.JavafxdocClassReader;
import com.sun.tools.javafxdoc.JavafxdocEnter;
import com.sun.tools.javafxdoc.JavafxdocMemberEnter;
import com.sun.tools.javafxdoc.Messager;
import com.sun.tools.javafxdoc.ModifierFilter;
import com.sun.tools.javafxdoc.RootDocImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxdocTool
extends JavafxCompiler {
    DocEnv docenv;
    final Context ctx;
    final Messager messager;
    final JavafxClassReader clsreader;
    final JavafxdocEnter jdenter;
    private final Paths paths;
    static final boolean surrogatesSupported = JavafxdocTool.surrogatesSupported();

    protected JavafxdocTool(Context context) {
        super(context);
        this.ctx = context;
        this.messager = Messager.instance0(context);
        this.clsreader = JavafxClassReader.instance(context);
        this.jdenter = JavafxdocEnter.instance0(context);
        this.paths = Paths.instance(context);
    }

    @Override
    protected void registerServices(Context context) {
        Messager.instance0(context);
    }

    @Override
    protected boolean keepComments() {
        return true;
    }

    public static JavafxdocTool make0(Context context) {
        try {
            JavafxFileManager.preRegister(context);
            JavafxdocEnter.preRegister(context);
            JavafxdocMemberEnter.preRegister(context);
            JavafxSymtab.preRegister(context);
            JavadocTodo.preRegister(context);
            JavafxTypes.preRegister(context);
            DocCommentScanner.Factory.preRegister(context);
            JavafxClassReader reader = JavafxClassReader.instance(context);
            JavafxdocClassReader jclsreader = new JavafxdocClassReader(context);
            reader.jreader = jclsreader;
            return new JavafxdocTool(context);
        }
        catch (Symbol.CompletionFailure ex) {
            Messager messager = Messager.instance0(context);
            if (messager != null) {
                messager.error(-1, ex.getMessage(), new Object[0]);
            }
            return null;
        }
    }

    public RootDocImpl getRootDocImpl(String doclocale, String encoding, ModifierFilter filter, List<String> javaNames, List<String[]> options, boolean breakiterator, List<String> subPackages, List<String> excludedPackages, boolean docClasses, boolean legacyDoclet, boolean quiet) throws IOException {
        this.docenv = DocEnv.instance(this.ctx);
        this.docenv.showAccess = filter;
        this.docenv.quiet = quiet;
        this.docenv.breakiterator = breakiterator;
        this.docenv.setLocale(doclocale);
        this.docenv.setEncoding(encoding);
        this.docenv.docClasses = docClasses;
        this.docenv.legacyDoclet = legacyDoclet;
        this.clsreader.sourceCompleter = docClasses ? null : this;
        ListBuffer<String> filenames = new ListBuffer<String>();
        ListBuffer<JFXScript> classTrees = new ListBuffer<JFXScript>();
        ListBuffer<JFXScript> packTrees = new ListBuffer<JFXScript>();
        try {
            List<String> it = javaNames;
            while (it.nonEmpty()) {
                String name = (String)it.head;
                if (!docClasses && name.endsWith(".fx") && new File(name).exists()) {
                    this.docenv.notice("main.Loading_source_file", name);
                    JFXScript tree = this.parse(name);
                    classTrees.append(tree);
                } else if (this.isValidPackageName(name)) {
                    filenames = filenames.append(name);
                } else if (name.endsWith(".fx")) {
                    this.docenv.error(null, "main.file_not_found", name);
                } else {
                    this.docenv.error(null, "main.illegal_package_name", name);
                }
                it = it.tail;
            }
            if (!docClasses) {
                this.searchSubPackages(subPackages, filenames, excludedPackages);
                List<String> packs = filenames.toList();
                while (packs.nonEmpty()) {
                    this.parsePackageClasses((String)packs.head, packTrees, excludedPackages);
                    packs = packs.tail;
                }
                if (this.messager.nerrors() != 0) {
                    return null;
                }
                this.docenv.notice("main.Building_tree");
                this.enterTrees(classTrees.toList().appendList(packTrees.toList()));
            }
        }
        catch (Abort ex) {
            // empty catch block
        }
        if (this.messager.nerrors() != 0) {
            return null;
        }
        if (docClasses) {
            return new RootDocImpl(this.docenv, javaNames, options);
        }
        return new RootDocImpl(this.docenv, this.listClasses(classTrees.toList()), filenames.toList(), options);
    }

    boolean isValidPackageName(String s) {
        int index;
        while ((index = s.indexOf(46)) != -1) {
            if (!JavafxdocTool.isValidClassName(s.substring(0, index))) {
                return false;
            }
            s = s.substring(index + 1);
        }
        return JavafxdocTool.isValidClassName(s);
    }

    private void parsePackageClasses(String name, ListBuffer<JFXScript> trees, List<String> excludedPackages) throws IOException {
        if (excludedPackages.contains(name)) {
            return;
        }
        boolean hasFiles = false;
        this.docenv.notice("main.Loading_source_files_for_package", name);
        name = name.replace('.', File.separatorChar);
        for (File pathname : this.paths.sourceSearchPath()) {
            File f = new File(pathname, name);
            String[] filenames = f.list();
            if (filenames == null) continue;
            String dir = f.getAbsolutePath();
            if (!dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            for (int j = 0; j < filenames.length; ++j) {
                if (!JavafxdocTool.isValidJavaFXSourceFile(filenames[j])) continue;
                String fn = dir + filenames[j];
                trees.append(this.parse(fn));
                hasFiles = true;
            }
        }
        if (!hasFiles) {
            this.messager.warning("main.no_source_files_for_package", name.replace(File.separatorChar, '.'));
        }
    }

    private void searchSubPackages(List<String> subPackages, ListBuffer<String> packages, List<String> excludedPackages) {
        ArrayList<File> pathnames = new ArrayList<File>();
        if (this.paths.sourcePath() != null) {
            for (File elt : this.paths.sourcePath()) {
                pathnames.add(elt);
            }
        }
        for (File elt : this.paths.userClassPath()) {
            pathnames.add(elt);
        }
        for (String subPackage : subPackages) {
            this.searchSubPackage(subPackage, packages, excludedPackages, pathnames);
        }
    }

    private void searchSubPackage(String packageName, ListBuffer<String> packages, List<String> excludedPackages, Collection<File> pathnames) {
        if (excludedPackages.contains(packageName)) {
            return;
        }
        String packageFilename = packageName.replace('.', File.separatorChar);
        boolean addedPackage = false;
        for (File pathname : pathnames) {
            File f = new File(pathname, packageFilename);
            String[] filenames = f.list();
            if (filenames == null) continue;
            for (String filename : filenames) {
                if (!addedPackage && (JavafxdocTool.isValidJavaFXSourceFile(filename) || JavafxdocTool.isValidClassFile(filename)) && !packages.contains(packageName)) {
                    packages.append(packageName);
                    addedPackage = true;
                    continue;
                }
                if (!JavafxdocTool.isValidClassName(filename) || !new File(f, filename).isDirectory()) continue;
                this.searchSubPackage(packageName + "." + filename, packages, excludedPackages, pathnames);
            }
        }
    }

    private static boolean isValidClassFile(String file) {
        if (!file.endsWith(".class")) {
            return false;
        }
        String clazzName = file.substring(0, file.length() - ".class".length());
        return JavafxdocTool.isValidClassName(clazzName);
    }

    private static boolean isValidJavaFXSourceFile(String file) {
        if (!file.endsWith(".fx")) {
            return false;
        }
        String clazzName = file.substring(0, file.length() - ".fx".length());
        return JavafxdocTool.isValidClassName(clazzName);
    }

    private static boolean surrogatesSupported() {
        try {
            Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    public static boolean isValidClassName(String s) {
        if (s.length() < 1) {
            return false;
        }
        if (s.equals("package-info")) {
            return true;
        }
        if (surrogatesSupported) {
            int cp = s.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                return false;
            }
            for (int j = Character.charCount(cp); j < s.length(); j += Character.charCount(cp)) {
                cp = s.codePointAt(j);
                if (Character.isJavaIdentifierPart(cp)) continue;
                return false;
            }
        } else {
            if (!Character.isJavaIdentifierStart(s.charAt(0))) {
                return false;
            }
            for (int j = 1; j < s.length(); ++j) {
                if (Character.isJavaIdentifierPart(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    List<JFXClassDeclaration> listClasses(List<JFXScript> trees) {
        ListBuffer<JFXClassDeclaration> result = new ListBuffer<JFXClassDeclaration>();
        for (JFXScript t : trees) {
            for (JFXTree def : t.defs) {
                if (!(def instanceof JFXClassDeclaration)) continue;
                result.append((JFXClassDeclaration)def);
            }
        }
        return result.toList();
    }

    private JFXScript parse(String filename) throws IOException {
        JavacFileManager fm = (JavacFileManager)this.fileManager;
        return this.parse(fm.getJavaFileObjectsFromStrings(List.of(filename)).iterator().next());
    }
}

