/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.api;

import com.sun.javafx.api.tree.UnitTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TaskEvent;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public final class JavafxTaskEvent {
    private TaskEvent javacEvent;
    private UnitTree unit;
    private TypeElement clazz;

    public JavafxTaskEvent(TaskEvent.Kind kind, JavaFileObject sourceFile) {
        this.javacEvent = new TaskEvent(kind, sourceFile);
        this.unit = null;
    }

    public JavafxTaskEvent(TaskEvent.Kind kind, CompilationUnitTree javaUnit, TypeElement clazz) {
        this.javacEvent = new TaskEvent(kind, javaUnit, clazz);
        this.unit = null;
    }

    public JavafxTaskEvent(TaskEvent.Kind kind, UnitTree unit) {
        this(kind, unit, null);
    }

    public JavafxTaskEvent(TaskEvent.Kind kind, UnitTree unit, TypeElement clazz) {
        this.javacEvent = new TaskEvent(kind);
        this.unit = unit;
        this.clazz = clazz;
    }

    public TaskEvent.Kind getKind() {
        return this.javacEvent.getKind();
    }

    public JavaFileObject getSourceFile() {
        return this.unit != null ? this.unit.getSourceFile() : this.javacEvent.getSourceFile();
    }

    public UnitTree getUnit() {
        return this.unit;
    }

    public CompilationUnitTree getCompilationUnit() {
        return this.javacEvent.getCompilationUnit();
    }

    public TypeElement getTypeElement() {
        return this.clazz != null ? this.clazz : this.javacEvent.getTypeElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JavafxTaskEvent[");
        sb.append((Object)this.getKind());
        sb.append(',');
        sb.append(this.getSourceFile());
        TypeElement type = this.getTypeElement();
        if (type != null) {
            sb.append(',');
            sb.append(type);
        }
        sb.append(']');
        return sb.toString();
    }
}

