/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.api.tree;

import com.sun.javafx.api.tree.AssignmentTree;
import com.sun.javafx.api.tree.BinaryTree;
import com.sun.javafx.api.tree.BlockExpressionTree;
import com.sun.javafx.api.tree.BreakTree;
import com.sun.javafx.api.tree.CatchTree;
import com.sun.javafx.api.tree.ClassDeclarationTree;
import com.sun.javafx.api.tree.CompoundAssignmentTree;
import com.sun.javafx.api.tree.ConditionalExpressionTree;
import com.sun.javafx.api.tree.ContinueTree;
import com.sun.javafx.api.tree.EmptyStatementTree;
import com.sun.javafx.api.tree.ErroneousTree;
import com.sun.javafx.api.tree.ExpressionTree;
import com.sun.javafx.api.tree.ForExpressionInClauseTree;
import com.sun.javafx.api.tree.ForExpressionTree;
import com.sun.javafx.api.tree.FunctionDefinitionTree;
import com.sun.javafx.api.tree.FunctionInvocationTree;
import com.sun.javafx.api.tree.FunctionValueTree;
import com.sun.javafx.api.tree.IdentifierTree;
import com.sun.javafx.api.tree.ImportTree;
import com.sun.javafx.api.tree.IndexofTree;
import com.sun.javafx.api.tree.InitDefinitionTree;
import com.sun.javafx.api.tree.InstanceOfTree;
import com.sun.javafx.api.tree.InstantiateTree;
import com.sun.javafx.api.tree.InterpolateValueTree;
import com.sun.javafx.api.tree.JavaFXTreeVisitor;
import com.sun.javafx.api.tree.KeyFrameLiteralTree;
import com.sun.javafx.api.tree.LiteralTree;
import com.sun.javafx.api.tree.MemberSelectTree;
import com.sun.javafx.api.tree.ModifiersTree;
import com.sun.javafx.api.tree.ObjectLiteralPartTree;
import com.sun.javafx.api.tree.OnReplaceTree;
import com.sun.javafx.api.tree.ParenthesizedTree;
import com.sun.javafx.api.tree.ReturnTree;
import com.sun.javafx.api.tree.SequenceDeleteTree;
import com.sun.javafx.api.tree.SequenceEmptyTree;
import com.sun.javafx.api.tree.SequenceExplicitTree;
import com.sun.javafx.api.tree.SequenceIndexedTree;
import com.sun.javafx.api.tree.SequenceInsertTree;
import com.sun.javafx.api.tree.SequenceRangeTree;
import com.sun.javafx.api.tree.SequenceSliceTree;
import com.sun.javafx.api.tree.StringExpressionTree;
import com.sun.javafx.api.tree.ThrowTree;
import com.sun.javafx.api.tree.TimeLiteralTree;
import com.sun.javafx.api.tree.Tree;
import com.sun.javafx.api.tree.TriggerTree;
import com.sun.javafx.api.tree.TryTree;
import com.sun.javafx.api.tree.TypeAnyTree;
import com.sun.javafx.api.tree.TypeCastTree;
import com.sun.javafx.api.tree.TypeClassTree;
import com.sun.javafx.api.tree.TypeFunctionalTree;
import com.sun.javafx.api.tree.TypeUnknownTree;
import com.sun.javafx.api.tree.UnaryTree;
import com.sun.javafx.api.tree.UnitTree;
import com.sun.javafx.api.tree.VariableTree;
import com.sun.javafx.api.tree.WhileLoopTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFXTreeScanner<R, P>
implements JavaFXTreeVisitor<R, P> {
    public R scan(Tree node, P p) {
        return node == null ? null : (R)node.accept(this, p);
    }

    private R scanAndReduce(Tree node, P p, R r) {
        return this.reduce(this.scan(node, p), r);
    }

    public R scan(Iterable<? extends Tree> nodes, P p) {
        R r = null;
        if (nodes != null) {
            boolean first = true;
            for (Tree tree : nodes) {
                r = (R)(first ? this.scan(tree, p) : this.scanAndReduce(tree, p, r));
                first = false;
            }
        }
        return r;
    }

    public R reduce(R r1, R r2) {
        return r1;
    }

    private R scanAndReduce(Iterable<? extends Tree> nodes, P p, R r) {
        return this.reduce(this.scan(nodes, p), r);
    }

    @Override
    public R visitCompilationUnit(UnitTree node, P p) {
        R r = this.scan(node.getPackageName(), p);
        r = this.scanAndReduce(node.getImports(), p, r);
        r = this.scanAndReduce(node.getTypeDecls(), p, r);
        return r;
    }

    @Override
    public R visitImport(ImportTree node, P p) {
        return this.scan(node.getQualifiedIdentifier(), p);
    }

    @Override
    public R visitEmptyStatement(EmptyStatementTree node, P p) {
        return null;
    }

    @Override
    public R visitWhileLoop(WhileLoopTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitTry(TryTree node, P p) {
        R r = this.scan(node.getBlock(), p);
        r = this.scanAndReduce(node.getCatches(), p, r);
        r = this.scanAndReduce(node.getFinallyBlock(), p, r);
        return r;
    }

    @Override
    public R visitCatch(CatchTree node, P p) {
        R r = this.scan(node.getParameter(), p);
        r = this.scanAndReduce(node.getBlock(), p, r);
        return r;
    }

    @Override
    public R visitConditionalExpression(ConditionalExpressionTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getTrueExpression(), p, r);
        r = this.scanAndReduce(node.getFalseExpression(), p, r);
        return r;
    }

    @Override
    public R visitBreak(BreakTree node, P p) {
        return null;
    }

    @Override
    public R visitContinue(ContinueTree node, P p) {
        return null;
    }

    @Override
    public R visitReturn(ReturnTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitThrow(ThrowTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitMethodInvocation(FunctionInvocationTree node, P p) {
        R r = this.scan(node.getTypeArguments(), p);
        r = this.scanAndReduce(node.getMethodSelect(), p, r);
        r = this.scanAndReduce(node.getArguments(), p, r);
        return r;
    }

    @Override
    public R visitParenthesized(ParenthesizedTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitAssignment(AssignmentTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitCompoundAssignment(CompoundAssignmentTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitUnary(UnaryTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitBinary(BinaryTree node, P p) {
        R r = this.scan(node.getLeftOperand(), p);
        r = this.scanAndReduce(node.getRightOperand(), p, r);
        return r;
    }

    @Override
    public R visitTypeCast(TypeCastTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitInstanceOf(InstanceOfTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getType(), p, r);
        return r;
    }

    @Override
    public R visitMemberSelect(MemberSelectTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        return null;
    }

    @Override
    public R visitLiteral(LiteralTree node, P p) {
        return null;
    }

    @Override
    public R visitModifiers(ModifiersTree node, P p) {
        return null;
    }

    @Override
    public R visitErroneous(ErroneousTree node, P p) {
        return null;
    }

    @Override
    public R visitBlockExpression(BlockExpressionTree node, P p) {
        R r = this.scan(node.getStatements(), p);
        return this.scanAndReduce(node.getValue(), p, r);
    }

    @Override
    public R visitClassDeclaration(ClassDeclarationTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getImplements(), p, r);
        r = this.scanAndReduce(node.getExtends(), p, r);
        return this.scanAndReduce(node.getClassMembers(), p, r);
    }

    @Override
    public R visitForExpression(ForExpressionTree node, P p) {
        R r = this.scan(node.getInClauses(), p);
        return this.scanAndReduce(node.getBodyExpression(), p, r);
    }

    @Override
    public R visitForExpressionInClause(ForExpressionInClauseTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getSequenceExpression(), p, r);
        return this.scanAndReduce(node.getWhereExpression(), p, r);
    }

    @Override
    public R visitIndexof(IndexofTree node, P p) {
        return this.scan(node.getForVarIdentifier(), p);
    }

    @Override
    public R visitInitDefinition(InitDefinitionTree node, P p) {
        return this.scan(node.getBody(), p);
    }

    @Override
    public R visitPostInitDefinition(InitDefinitionTree node, P p) {
        return this.scan(node.getBody(), p);
    }

    @Override
    public R visitInstantiate(InstantiateTree node, P p) {
        R r = this.scan(node.getArguments(), p);
        r = this.scanAndReduce(node.getClassBody(), p, r);
        r = this.scanAndReduce(node.getIdentifier(), p, r);
        r = this.scanAndReduce(node.getLocalVariables(), p, r);
        return this.scanAndReduce(node.getLiteralParts(), p, r);
    }

    @Override
    public R visitInterpolateValue(InterpolateValueTree node, P p) {
        R r = this.scan(node.getAttribute(), p);
        if (node.getInterpolation() != null) {
            r = this.scanAndReduce(node.getInterpolation(), p, r);
        }
        return this.scanAndReduce(node.getValue(), p, r);
    }

    @Override
    public R visitKeyFrameLiteral(KeyFrameLiteralTree node, P p) {
        R r = this.scan(node.getStartDuration(), p);
        r = this.scanAndReduce(node.getInterpolationValues(), p, r);
        return this.scanAndReduce(node.getTrigger(), p, r);
    }

    @Override
    public R visitObjectLiteralPart(ObjectLiteralPartTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitOnReplace(OnReplaceTree node, P p) {
        R r = this.scan(node.getOldValue(), p);
        return this.scanAndReduce(node.getBody(), p, r);
    }

    @Override
    public R visitTrigger(TriggerTree node, P p) {
        R r = this.scan(node.getExpressionTree(), p);
        return this.scanAndReduce(node.getOnReplaceTree(), p, r);
    }

    @Override
    public R visitFunctionDefinition(FunctionDefinitionTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        return this.scanAndReduce(node.getFunctionValue(), p, r);
    }

    @Override
    public R visitFunctionValue(FunctionValueTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getParameters(), p, r);
        return this.scanAndReduce(node.getBodyExpression(), p, r);
    }

    @Override
    public R visitSequenceDelete(SequenceDeleteTree node, P p) {
        R r = this.scan(node.getSequence(), p);
        return this.scanAndReduce(node.getElement(), p, r);
    }

    @Override
    public R visitSequenceEmpty(SequenceEmptyTree node, P p) {
        return null;
    }

    @Override
    public R visitSequenceExplicit(SequenceExplicitTree node, P p) {
        return this.scan(node.getItemList(), p);
    }

    @Override
    public R visitSequenceIndexed(SequenceIndexedTree node, P p) {
        R r = this.scan(node.getSequence(), p);
        return this.scanAndReduce(node.getIndex(), p, r);
    }

    @Override
    public R visitSequenceSlice(SequenceSliceTree node, P p) {
        R r = this.scan(node.getSequence(), p);
        r = this.scanAndReduce(node.getFirstIndex(), p, r);
        return this.scanAndReduce(node.getLastIndex(), p, r);
    }

    @Override
    public R visitSequenceInsert(SequenceInsertTree node, P p) {
        R r = this.scan(node.getSequence(), p);
        return this.scanAndReduce(node.getElement(), p, r);
    }

    @Override
    public R visitSequenceRange(SequenceRangeTree node, P p) {
        R r = this.scan(node.getLower(), p);
        r = this.scanAndReduce(node.getUpper(), p, r);
        return this.scanAndReduce(node.getStepOrNull(), p, r);
    }

    @Override
    public R visitStringExpression(StringExpressionTree node, P p) {
        return this.scan(node.getPartList(), p);
    }

    @Override
    public R visitTimeLiteral(TimeLiteralTree node, P p) {
        return null;
    }

    @Override
    public R visitTypeAny(TypeAnyTree node, P p) {
        return null;
    }

    @Override
    public R visitTypeClass(TypeClassTree node, P p) {
        return this.scan(node.getClassName(), p);
    }

    @Override
    public R visitTypeFunctional(TypeFunctionalTree node, P p) {
        R r = this.scan(node.getReturnType(), p);
        return this.scanAndReduce(node.getParameters(), p, r);
    }

    @Override
    public R visitTypeUnknown(TypeUnknownTree node, P p) {
        return null;
    }

    @Override
    public R visitVariable(VariableTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getInitializer(), p, r);
        r = this.scanAndReduce(node.getJFXType(), p, r);
        return this.scanAndReduce(node.getOnReplaceTree(), p, r);
    }

    @Override
    public R visitMissingExpression(ExpressionTree node, P p) {
        return null;
    }
}

