/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.Numerics;
import com.sun.javafx.runtime.location.BooleanLocation;
import com.sun.javafx.runtime.location.DoubleLocation;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.Locations;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.Sequence;
import javafx.animation.KeyValueTarget;

public class Pointer
implements KeyValueTarget {
    private final Location location;
    private final KeyValueTarget.Type type;

    public static Pointer make(Location location) {
        KeyValueTarget.Type type = location instanceof IntLocation ? KeyValueTarget.Type.INTEGER : (location instanceof DoubleLocation ? KeyValueTarget.Type.DOUBLE : (location instanceof BooleanLocation ? KeyValueTarget.Type.BOOLEAN : (location instanceof SequenceLocation ? KeyValueTarget.Type.SEQUENCE : KeyValueTarget.Type.OBJECT)));
        return new Pointer(location, type);
    }

    static Pointer make(IntLocation location) {
        return new Pointer(location, KeyValueTarget.Type.INTEGER);
    }

    static Pointer make(DoubleLocation location) {
        return new Pointer(location, KeyValueTarget.Type.DOUBLE);
    }

    static Pointer make(BooleanLocation location) {
        return new Pointer(location, KeyValueTarget.Type.BOOLEAN);
    }

    static Pointer make(SequenceLocation location) {
        return new Pointer(location, KeyValueTarget.Type.SEQUENCE);
    }

    static Pointer make(ObjectLocation location) {
        return new Pointer(location, KeyValueTarget.Type.OBJECT);
    }

    public static boolean equals(Pointer p1, Pointer p2) {
        return p1 == null ? p2 == null : p1.equals(p2);
    }

    private Pointer(Location location, KeyValueTarget.Type type) {
        this.location = location;
        this.type = type;
    }

    public KeyValueTarget.Type getType() {
        return this.type;
    }

    public Pointer unwrap() {
        return this;
    }

    public Object get() {
        switch (this.type) {
            case INTEGER: {
                return ((IntLocation)this.location).getAsInt();
            }
            case DOUBLE: {
                return ((DoubleLocation)this.location).getAsDouble();
            }
            case BOOLEAN: {
                return ((BooleanLocation)this.location).getAsBoolean();
            }
            case SEQUENCE: {
                return ((SequenceLocation)this.location).getAsSequence();
            }
        }
        return ((ObjectLocation)this.location).get();
    }

    public void set(Object value) {
        switch (this.type) {
            case INTEGER: {
                ((IntLocation)this.location).setAsInt(Numerics.toInt(value));
                break;
            }
            case DOUBLE: {
                ((DoubleLocation)this.location).setAsDouble(Numerics.toDouble(value));
                break;
            }
            case BOOLEAN: {
                ((BooleanLocation)this.location).setAsBoolean((Boolean)value);
                break;
            }
            case SEQUENCE: {
                ((SequenceLocation)this.location).setAsSequence((Sequence)value);
                break;
            }
            case OBJECT: {
                ((ObjectLocation)this.location).set(value);
            }
        }
    }

    public Object getValue() {
        return this.get();
    }

    public void setValue(Object o) {
        this.set(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Pointer && Locations.getUnderlyingLocation(this.location) == Locations.getUnderlyingLocation(((Pointer)o).location);
    }

    public int hashCode() {
        Location loc = Locations.getUnderlyingLocation(this.location);
        return loc != null ? loc.hashCode() : 0;
    }
}

