/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import java.io.InputStream;
import java.util.Hashtable;

public class SystemProperties {
    private static String[] sysprop_table = new String[]{"application.codebase", "jfx_specific"};
    private static String[] jfxprop_table = new String[]{"application.codebase", ""};
    private static Hashtable sysprop_list = new Hashtable();
    private static Hashtable jfxprop_list = new Hashtable();
    private static final String versionRBName = "com.sun.javafx.runtime.version";
    public static final String codebase = "javafx.application.codebase";

    private static String getVersion() {
        String release_version = "unknown";
        InputStream is = SystemProperties.class.getResourceAsStream("/com/sun/javafx/runtime/version.txt");
        try {
            int size = is.available();
            byte[] b = new byte[size];
            int n = is.read(b);
            release_version = new String(b, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return release_version;
    }

    public static void addProperties(String[] table, boolean jfx_specific) {
        if (table == null) {
            return;
        }
        Hashtable props = jfx_specific ? jfxprop_list : sysprop_list;
        for (int i = 0; i < table.length; i += 2) {
            props.put(table[i], table[i + 1]);
        }
    }

    public static String getProperty(String key) {
        Hashtable props = sysprop_list;
        String prefix = "javafx.";
        if (key == null) {
            return null;
        }
        if (!key.startsWith("javafx.".toString())) {
            return null;
        }
        key = key.substring("javafx.".length());
        String found = (String)props.get(key);
        if (found == null || found.equals("")) {
            return null;
        }
        if (found.equals("jfx_specific")) {
            props = jfxprop_list;
            return (String)props.get(key);
        }
        return System.getProperty(found);
    }

    public static void clearProperty(String key) {
        if (key == null) {
            return;
        }
        Hashtable props = sysprop_list;
        String prefix = "javafx.";
        if (!key.startsWith("javafx.".toString())) {
            return;
        }
        key = key.substring("javafx.".length());
        String value = (String)props.get(key);
        if (value == null) {
            return;
        }
        props.remove(key);
        if (value.equals("jfx_specific")) {
            props = jfxprop_list;
            props.remove(key);
        }
    }

    public static void setFXProperty(String key, String value) {
        Hashtable props = sysprop_list;
        String prefix = "javafx.";
        if (key.startsWith("javafx.")) {
            String k = (String)props.get(key = key.substring("javafx.".length()));
            if (k == null) {
                props.put(key, "jfx_specific");
                props = jfxprop_list;
                props.put(key, value);
            } else if (k.equals("jfx_specific")) {
                props = jfxprop_list;
                props.put(key, value);
            }
        }
    }

    static {
        SystemProperties.addProperties(sysprop_table, false);
        SystemProperties.addProperties(jfxprop_table, true);
        SystemProperties.setFXProperty("javafx.version", SystemProperties.getVersion());
    }
}

