/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.async;

import com.sun.javafx.runtime.Entry;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.runtime.async.BackgroundExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsyncOperation<V>
implements Callable<V> {
    private final FutureTask<V> future;
    protected final AsyncOperationListener listener;
    private int progressGranularity = 100;
    private int progressMax;
    private int lastProgress;
    private int progressIncrement;
    private int nextProgress;
    private int bytesRead;

    protected AbstractAsyncOperation(final AsyncOperationListener<V> listener) {
        this.listener = listener;
        Callable callable = new Callable<V>(){

            @Override
            public V call() throws Exception {
                return AbstractAsyncOperation.this.call();
            }
        };
        final Runnable completionRunnable = new Runnable(){

            public void run() {
                if (AbstractAsyncOperation.this.future.isCancelled()) {
                    listener.onCancel();
                } else {
                    try {
                        listener.onCompletion(AbstractAsyncOperation.this.future.get());
                    }
                    catch (InterruptedException e) {
                        listener.onCancel();
                    }
                    catch (ExecutionException e) {
                        listener.onException(e);
                    }
                }
            }
        };
        this.future = new FutureTask<V>(callable){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    Entry.deferAction(completionRunnable);
                }
                finally {
                    super.done();
                }
            }
        };
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public void cancel() {
        this.future.cancel(true);
    }

    public void start() {
        BackgroundExecutor.getExecutor().execute(this.future);
    }

    protected void notifyProgress() {
        final int last = this.lastProgress;
        final int max = this.progressMax;
        Entry.deferAction(new Runnable(){

            public void run() {
                AbstractAsyncOperation.this.listener.onProgress(last, max);
            }
        });
    }

    protected void addProgress(int amount) {
        this.bytesRead += amount;
        if (this.bytesRead > this.nextProgress) {
            this.lastProgress = this.bytesRead;
            this.notifyProgress();
            this.nextProgress = (this.lastProgress / this.progressIncrement + 1) * this.progressIncrement;
        }
    }

    protected int getProgressMax() {
        return this.progressMax;
    }

    protected void setProgressMax(int progressMax) {
        if (progressMax == 0) {
            this.progressIncrement = this.progressGranularity;
        } else if (progressMax == -1) {
            this.progressIncrement = this.progressGranularity;
        } else {
            this.progressMax = progressMax;
            this.progressIncrement = progressMax / this.progressGranularity;
            if (this.progressIncrement < 1) {
                this.progressIncrement = 1;
            }
        }
        this.nextProgress = (this.lastProgress / this.progressIncrement + 1) * this.progressIncrement;
        this.notifyProgress();
    }

    protected int getProgressGranularity() {
        return this.progressGranularity;
    }

    protected void setProgressGranularity(int progressGranularity) {
        this.progressGranularity = progressGranularity;
        this.progressIncrement = this.progressMax / progressGranularity;
        this.nextProgress = (this.lastProgress / this.progressIncrement + 1) * this.progressIncrement;
        this.notifyProgress();
    }
}

