/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.async;

import com.sun.javafx.runtime.async.AbstractAsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteResource<T>
extends AbstractAsyncOperation<T> {
    protected final String url;
    protected final String method;
    protected final String outboundContent;
    protected int fileSize;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();

    protected AbstractRemoteResource(String url, AsyncOperationListener<T> listener) {
        this(url, "GET", listener);
    }

    protected AbstractRemoteResource(String url, String method, AsyncOperationListener<T> listener) {
        this(url, method, null, listener);
    }

    protected AbstractRemoteResource(String url, String method, String outboundContent, AsyncOperationListener<T> listener) {
        super(listener);
        this.url = url;
        this.method = method;
        this.outboundContent = outboundContent;
    }

    protected abstract T processStream(InputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws IOException {
        URL u = new URL(this.url);
        ProgressInputStream stream = null;
        String protocol = u.getProtocol();
        if (protocol.equals("http") || protocol.equals("https")) {
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod(this.method);
            conn.setDoInput(true);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null || value.equals("")) continue;
                conn.setRequestProperty(key, value);
            }
            if (this.outboundContent != null && this.method.equals("POST")) {
                conn.setDoOutput(true);
                byte[] outBytes = this.outboundContent.getBytes("utf-8");
                conn.setRequestProperty("Content-Length", String.valueOf(outBytes.length));
                OutputStream out = conn.getOutputStream();
                out.write(outBytes);
                out.close();
            }
            conn.connect();
            this.fileSize = conn.getContentLength();
            this.setProgressMax(this.fileSize);
            this.responseHeaders = conn.getHeaderFields();
            stream = new ProgressInputStream(conn.getInputStream());
        } else {
            URLConnection con = u.openConnection();
            this.setProgressMax(con.getContentLength());
            stream = new ProgressInputStream(con.getInputStream());
        }
        try {
            T t = this.processStream(stream);
            return t;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public void setHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public String getResponseHeader(String header) {
        String value = null;
        List<String> list = this.responseHeaders.get(header);
        if (list != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iter = list.iterator();
            while (iter.hasNext()) {
                sb.append((Object)iter.next());
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            value = sb.toString();
        }
        return value;
    }

    protected class ProgressInputStream
    extends BufferedInputStream {
        public ProgressInputStream(InputStream in) {
            super(in);
        }

        public synchronized int read() throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int ch = super.read();
            AbstractRemoteResource.this.addProgress(1);
            return ch;
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int bytes = super.read(b, off, len);
            AbstractRemoteResource.this.addProgress(bytes);
            return bytes;
        }

        public int read(byte[] b) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int bytes = super.read(b);
            AbstractRemoteResource.this.addProgress(bytes);
            return bytes;
        }
    }
}

