/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.liveconnect;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.JavaNameSpace;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import com.sun.javafx.runtime.liveconnect.FXClassDelegate;
import com.sun.javafx.runtime.liveconnect.FXSequenceDelegate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.reflect.FXClassType;
import javafx.reflect.FXLocal;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXSequenceValue;

public class FXDelegate
implements InvocationDelegate {
    private Bridge bridge;
    private String scriptClassName;
    private FXLocal.Context context = FXLocal.getContext();
    private Map<FXClassType, FXClassDelegate> classDelegates = new HashMap<FXClassType, FXClassDelegate>();
    private Set<String> notFXClasses = new HashSet<String>();
    private FXSequenceDelegate sequenceDelegate;
    private FXClassType scriptClass;

    public FXDelegate(Bridge bridge, String scriptClassName) {
        this.bridge = bridge;
        this.scriptClassName = scriptClassName;
    }

    public boolean invoke(String methodName, Object receiver, Object[] arguments, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
        Object[] box = new Object[]{receiver};
        InvocationDelegate delegate = this.getDelegate(box, isStatic, objectIsApplet);
        if (delegate == null) {
            return false;
        }
        return delegate.invoke(methodName, isStatic ? null : box[0], arguments, isStatic, objectIsApplet, result);
    }

    public boolean getField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
        if (objectIsApplet && fieldName.equalsIgnoreCase("script")) {
            result[0] = new Result((Object)new JavaNameSpace(this.scriptClassName), false);
            return true;
        }
        Object[] box = new Object[]{receiver};
        InvocationDelegate delegate = this.getDelegate(box, isStatic, objectIsApplet);
        if (delegate == null) {
            return false;
        }
        return delegate.getField(fieldName, isStatic ? null : box[0], isStatic, objectIsApplet, result);
    }

    public boolean setField(String fieldName, Object receiver, Object value, boolean isStatic, boolean objectIsApplet) throws Exception {
        Object[] box = new Object[]{receiver};
        InvocationDelegate delegate = this.getDelegate(box, isStatic, objectIsApplet);
        if (delegate == null) {
            return false;
        }
        return delegate.setField(fieldName, isStatic ? null : box[0], value, isStatic, objectIsApplet);
    }

    public boolean hasField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        if (objectIsApplet && fieldName.equalsIgnoreCase("script")) {
            result[0] = true;
            return true;
        }
        Object[] box = new Object[]{receiver};
        InvocationDelegate delegate = this.getDelegate(box, isStatic, objectIsApplet);
        if (delegate == null) {
            return false;
        }
        return delegate.hasField(fieldName, isStatic ? null : box[0], isStatic, objectIsApplet, result);
    }

    public boolean hasMethod(String methodName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        Object[] box = new Object[]{receiver};
        InvocationDelegate delegate = this.getDelegate(box, isStatic, objectIsApplet);
        if (delegate == null) {
            return false;
        }
        return delegate.hasMethod(methodName, isStatic ? null : box[0], isStatic, objectIsApplet, result);
    }

    public boolean hasFieldOrMethod(String name, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        if (objectIsApplet && name.equalsIgnoreCase("script")) {
            result[0] = true;
            return true;
        }
        Object[] box = new Object[]{receiver};
        InvocationDelegate delegate = this.getDelegate(box, isStatic, objectIsApplet);
        if (delegate == null) {
            return false;
        }
        return delegate.hasFieldOrMethod(name, isStatic ? null : box[0], isStatic, objectIsApplet, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findClass(String name) {
        if (this.notFXClasses.contains(name)) {
            return null;
        }
        try {
            FXClassType clazz = this.context.findClass(name);
            if (clazz != null && clazz.isJfxType()) {
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FXDelegate fXDelegate = this;
        synchronized (fXDelegate) {
            this.notFXClasses.add(name);
        }
        return null;
    }

    public Object newInstance(Object clazz, Object[] arguments) throws Exception {
        throw new UnsupportedOperationException("Instantiation of JavaFX classes not yet supported");
    }

    private synchronized InvocationDelegate getDelegate(Object[] box, boolean isStatic, boolean objectIsApplet) {
        FXObjectValue fxObj;
        FXClassType fxClass;
        Object obj = box[0];
        if (obj instanceof FXClassType || obj instanceof FXObjectValue) {
            if (isStatic) {
                return this.getClassDelegate((FXClassType)obj);
            }
            FXObjectValue fxObj2 = (FXObjectValue)obj;
            return this.getClassDelegate(fxObj2.getClassType());
        }
        if (obj instanceof FXSequenceValue) {
            if (this.sequenceDelegate == null) {
                this.sequenceDelegate = new FXSequenceDelegate(this.bridge);
            }
            return this.sequenceDelegate;
        }
        if (objectIsApplet && (fxClass = (fxObj = this.context.mirrorOf(obj)).getClassType()).isJfxType()) {
            box[0] = fxObj;
            return this.getClassDelegate(fxClass);
        }
        return null;
    }

    private InvocationDelegate getClassDelegate(FXClassType fxClass) {
        FXClassDelegate delegate = this.classDelegates.get(fxClass);
        if (delegate == null) {
            delegate = new FXClassDelegate(fxClass, this.bridge);
            this.classDelegates.put(fxClass, delegate);
        }
        return delegate;
    }

    private FXClassType getScriptClass(String className) {
        if (this.scriptClass == null) {
            this.scriptClass = this.context.findClass(className);
        }
        return this.scriptClass;
    }
}

