/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.location.AbstractVariable;
import com.sun.javafx.runtime.location.DeferredInitializer;
import com.sun.javafx.runtime.location.IntBindingExpression;
import com.sun.javafx.runtime.location.IntChangeListener;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectChangeListener;
import com.sun.javafx.runtime.location.ObjectVariable;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntVariable
extends AbstractVariable<Integer, IntLocation, IntBindingExpression, IntChangeListener>
implements IntLocation {
    public static final int DEFAULT = 0;
    protected int $value = 0;

    public static IntVariable make() {
        return new IntVariable();
    }

    public static IntVariable make(int value) {
        return new IntVariable(value);
    }

    public static IntVariable make(boolean lazy, IntBindingExpression binding, Location ... dependencies) {
        return new IntVariable(lazy, binding, dependencies);
    }

    public static IntVariable make(IntBindingExpression binding, Location ... dependencies) {
        return new IntVariable(false, binding, dependencies);
    }

    public static IntVariable makeBijective(ObjectVariable<Integer> other) {
        IntVariable me = IntVariable.make();
        me.bijectiveBind(other);
        return me;
    }

    protected IntVariable() {
    }

    protected IntVariable(int value) {
        super((byte)2);
        this.$value = value;
        this.setValid();
    }

    protected IntVariable(boolean lazy, IntBindingExpression binding, Location ... dependencies) {
        this();
        this.bind(lazy, binding, new Location[0]);
        this.addDependency(dependencies);
    }

    @Override
    public int getAsInt() {
        if (this.isUnidirectionallyBound() && !this.isValid()) {
            this.update();
        }
        return this.$value;
    }

    @Override
    public Integer get() {
        return this.getAsInt();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    protected int replaceValue(int newValue) {
        int oldValue = this.$value;
        if (this.preReplace(oldValue != newValue)) {
            boolean invalidateDependencies = this.isValid() || this.state == 2;
            this.$value = newValue;
            this.setValid();
            this.notifyListeners(oldValue, newValue, invalidateDependencies);
        } else {
            this.setValid();
        }
        return newValue;
    }

    @Override
    protected IntBindingExpression makeBindingExpression(final IntLocation otherLocation) {
        return new IntBindingExpression(){

            public int computeValue() {
                return otherLocation.getAsInt();
            }
        };
    }

    @Override
    public int setAsInt(int value) {
        if (this.isUnidirectionallyBound() && this.$value != value) {
            throw new AssignToBoundException("Cannot assign to bound variable");
        }
        return this.replaceValue(value);
    }

    @Override
    public int setAsIntFromLiteral(final int value) {
        this.deferredLiteral = new DeferredInitializer(){

            public void apply() {
                IntVariable.this.setAsInt(value);
            }
        };
        return value;
    }

    @Override
    public void setDefault() {
        if (this.state == 0) {
            this.$value = 0;
            this.state = 1;
            this.notifyListeners(0, 0, true);
        } else {
            this.setAsInt(0);
        }
    }

    @Override
    public Integer set(Integer value) {
        if (value == null) {
            ErrorHandler.nullToPrimitiveCoercion("Integer");
            this.setDefault();
        } else {
            this.setAsInt(value);
        }
        return value;
    }

    @Override
    public void update() {
        block3: {
            try {
                if (this.isUnidirectionallyBound() && !this.isValid()) {
                    this.replaceValue(((IntBindingExpression)this.binding).computeValue());
                }
            }
            catch (RuntimeException e) {
                ErrorHandler.bindException(e);
                if (!this.isInitialized()) break block3;
                this.replaceValue(0);
            }
        }
    }

    @Override
    public void addChangeListener(final ObjectChangeListener<Integer> listener) {
        this.addChangeListener(new IntChangeListener(){

            public void onChange(int oldValue, int newValue) {
                listener.onChange(oldValue, newValue);
            }
        });
    }

    private void notifyListeners(final int oldValue, final int newValue, boolean invalidateDependencies) {
        if (invalidateDependencies) {
            this.invalidateDependencies();
        }
        if (this.replaceListeners != null) {
            AbstractLinkable.iterate(this.replaceListeners, new Linkable.IterationClosure<IntChangeListener>(){

                @Override
                public void action(IntChangeListener listener) {
                    try {
                        listener.onChange(oldValue, newValue);
                    }
                    catch (RuntimeException e) {
                        ErrorHandler.triggerException(e);
                    }
                }
            });
        }
    }
}

