/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.Numerics;
import com.sun.javafx.runtime.location.BooleanChangeListener;
import com.sun.javafx.runtime.location.BooleanConstant;
import com.sun.javafx.runtime.location.BooleanLocation;
import com.sun.javafx.runtime.location.ChangeListener;
import com.sun.javafx.runtime.location.DoubleChangeListener;
import com.sun.javafx.runtime.location.DoubleConstant;
import com.sun.javafx.runtime.location.DoubleLocation;
import com.sun.javafx.runtime.location.DynamicViewLocation;
import com.sun.javafx.runtime.location.IntChangeListener;
import com.sun.javafx.runtime.location.IntConstant;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectChangeListener;
import com.sun.javafx.runtime.location.ObjectConstant;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceConstant;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.location.StaticViewLocation;
import com.sun.javafx.runtime.location.WeakLocation;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Locations {
    private Locations() {
    }

    public static Location getUnderlyingLocation(Location loc) {
        while (loc instanceof DynamicViewLocation) {
            loc = ((DynamicViewLocation)((Object)loc)).getUnderlyingLocation();
        }
        return loc;
    }

    public static IntLocation constant(int value) {
        return IntConstant.make(value);
    }

    public static DoubleLocation constant(double value) {
        return DoubleConstant.make(value);
    }

    public static BooleanLocation constant(boolean value) {
        return BooleanConstant.make(value);
    }

    public static <T> ObjectLocation<T> constant(T value) {
        return ObjectConstant.make(value);
    }

    public static <T> SequenceLocation<T> constant(Class<T> clazz, Sequence<T> value) {
        return SequenceConstant.make(clazz, value);
    }

    public static ObjectLocation<Integer> asObjectLocation(IntLocation loc) {
        return loc;
    }

    public static ObjectLocation<Double> asObjectLocation(DoubleLocation loc) {
        return loc;
    }

    public static ObjectLocation<Boolean> asObjectLocation(BooleanLocation loc) {
        return loc;
    }

    public static BooleanLocation asBooleanLocation(ObjectLocation<Boolean> loc) {
        return new ObjectBooleanLocation(loc);
    }

    public static <T> DoubleLocation asDoubleLocation(ObjectLocation<T> loc) {
        return new ObjectDoubleLocation(loc);
    }

    public static DoubleLocation asDoubleLocation(IntLocation loc) {
        return new IntDoubleLocation(loc);
    }

    public static IntLocation asIntLocation(DoubleLocation loc) {
        return new DoubleIntLocation(loc);
    }

    public static IntLocation asIntLocation(ObjectLocation<Integer> loc) {
        return new ObjectIntLocation(loc);
    }

    public static IntLocation unmodifiableLocation(IntLocation loc) {
        return new UnmodifiableIntLocation(loc);
    }

    public static DoubleLocation unmodifiableLocation(DoubleLocation loc) {
        return new UnmodifiableDoubleLocation(loc);
    }

    public static BooleanLocation unmodifiableLocation(BooleanLocation loc) {
        return new UnmodifiableBooleanLocation(loc);
    }

    public static <T> ObjectLocation<T> unmodifiableLocation(ObjectLocation<T> loc) {
        return new UnmodifiableObjectLocation<T>(loc);
    }

    public static <T> SequenceLocation<T> unmodifiableLocation(SequenceLocation<T> loc) {
        return new UnmodifiableSequenceLocation<T>(loc);
    }

    public static <T, V extends T> ObjectLocation<T> upcast(Class clazz, ObjectLocation<V> loc) {
        return new UpcastLocation(clazz, loc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSequenceLocation<T>
    extends LocationWrapper
    implements SequenceLocation<T> {
        private final SequenceLocation<T> location;

        public UnmodifiableSequenceLocation(SequenceLocation<T> location) {
            this.location = location;
        }

        @Override
        public SequenceLocation<T> getLocation() {
            return this.location;
        }

        @Override
        public void invalidate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public T get(int position) {
            return this.location.get(position);
        }

        @Override
        public Class<T> getElementType() {
            return this.location.getElementType();
        }

        @Override
        public Sequence<T> getAsSequence() {
            return this.location.getAsSequence();
        }

        @Override
        public Sequence<T> get() {
            return (Sequence)this.location.get();
        }

        @Override
        public Sequence<T> set(Sequence<T> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Sequence<T> setFromLiteral(Sequence<T> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this.location.iterator();
        }

        @Override
        public Sequence<T> setAsSequence(Sequence<? extends T> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Sequence<T> setAsSequenceFromLiteral(Sequence<? extends T> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addChangeListener(ObjectChangeListener<Sequence<T>> listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public void addChangeListener(SequenceChangeListener<T> sequenceChangeListener) {
            this.location.addChangeListener(sequenceChangeListener);
        }

        @Override
        public void removeChangeListener(SequenceChangeListener<T> sequenceChangeListener) {
            this.location.removeChangeListener(sequenceChangeListener);
        }

        @Override
        public T set(int position, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Sequence<T> getSlice(int startPos, int endPos) {
            return this.getAsSequence().getSlice(startPos, endPos);
        }

        @Override
        public Sequence<? extends T> replaceSlice(int startPos, int endPos, Sequence<? extends T> newValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(int position) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteSlice(int startPos, int endPos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteValue(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(SequencePredicate<T> sequencePredicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insert(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insert(Sequence<? extends T> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertFirst(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertFirst(Sequence<? extends T> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBefore(T value, int position) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBefore(T value, SequencePredicate<T> sequencePredicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBefore(Sequence<? extends T> values, int position) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBefore(Sequence<? extends T> values, SequencePredicate<T> sequencePredicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertAfter(T value, int position) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertAfter(T value, SequencePredicate<T> sequencePredicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertAfter(Sequence<? extends T> values, int position) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertAfter(Sequence<? extends T> values, SequencePredicate<T> sequencePredicate) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpcastLocation<T, V extends T>
    extends LocationWrapper
    implements ObjectLocation<T> {
        private final ObjectLocation<V> location;
        private final Class<V> clazz;

        public UpcastLocation(Class<V> clazz, ObjectLocation<V> location) {
            this.location = location;
            this.clazz = clazz;
        }

        @Override
        protected Location getLocation() {
            return this.location;
        }

        @Override
        public V get() {
            return this.location.get();
        }

        @Override
        public V set(T value) {
            return this.location.set(value);
        }

        @Override
        public T setFromLiteral(T value) {
            return (T)this.location.setFromLiteral(value);
        }

        @Override
        public void setDefault() {
            this.location.setDefault();
        }

        @Override
        public void addChangeListener(final ObjectChangeListener<T> listener) {
            this.location.addChangeListener(new ObjectChangeListener<V>(){

                @Override
                public void onChange(V oldValue, V newValue) {
                    listener.onChange(oldValue, newValue);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableObjectLocation<T>
    extends LocationWrapper
    implements ObjectLocation<T> {
        private final ObjectLocation<T> location;

        public UnmodifiableObjectLocation(ObjectLocation<T> location) {
            this.location = location;
        }

        @Override
        public ObjectLocation<T> getLocation() {
            return this.location;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public T get() {
            return this.location.get();
        }

        @Override
        public T set(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T setFromLiteral(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addChangeListener(ObjectChangeListener<T> listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public void invalidate() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableBooleanLocation
    extends LocationWrapper
    implements BooleanLocation {
        private final BooleanLocation location;

        @Override
        protected Location getLocation() {
            return this.location;
        }

        public UnmodifiableBooleanLocation(BooleanLocation location) {
            this.location = location;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public boolean getAsBoolean() {
            return this.location.getAsBoolean();
        }

        @Override
        public Boolean get() {
            return this.getAsBoolean();
        }

        @Override
        public void addChangeListener(BooleanChangeListener listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public void addChangeListener(ObjectChangeListener<Boolean> listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public boolean setAsBoolean(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAsBooleanFromLiteral(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean set(Boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean setFromLiteral(Boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invalidate() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableDoubleLocation
    extends LocationWrapper
    implements DoubleLocation {
        private final DoubleLocation location;

        @Override
        protected Location getLocation() {
            return this.location;
        }

        public UnmodifiableDoubleLocation(DoubleLocation location) {
            this.location = location;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public double getAsDouble() {
            return this.location.getAsDouble();
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        @Override
        public void addChangeListener(DoubleChangeListener listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public void addChangeListener(ObjectChangeListener<Double> listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public double setAsDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double setAsDoubleFromLiteral(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double set(Double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double setFromLiteral(Double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invalidate() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableIntLocation
    extends LocationWrapper
    implements IntLocation {
        private final IntLocation location;

        @Override
        protected Location getLocation() {
            return this.location;
        }

        public UnmodifiableIntLocation(IntLocation location) {
            this.location = location;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public int getAsInt() {
            return this.location.getAsInt();
        }

        @Override
        public Integer get() {
            return this.getAsInt();
        }

        @Override
        public void addChangeListener(IntChangeListener listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public void addChangeListener(ObjectChangeListener<Integer> listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public int setAsInt(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setAsIntFromLiteral(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer set(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer setFromLiteral(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invalidate() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleIntLocation
    extends LocationWrapper
    implements IntLocation,
    StaticViewLocation {
        private final DoubleLocation location;

        @Override
        protected DoubleLocation getLocation() {
            return this.location;
        }

        public DoubleIntLocation(DoubleLocation location) {
            this.location = location;
        }

        @Override
        public int getAsInt() {
            return (int)this.location.getAsDouble();
        }

        public void addChangeListener(DoubleChangeListener listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public Integer get() {
            return this.getAsInt();
        }

        @Override
        public int setAsInt(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setAsIntFromLiteral(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer set(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer setFromLiteral(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Location getUnderlyingLocation() {
            return this.location;
        }

        @Override
        public void addChangeListener(final IntChangeListener listener) {
            this.location.addChangeListener(new DoubleChangeListener(){

                public void onChange(double oldValue, double newValue) {
                    listener.onChange((int)oldValue, (int)newValue);
                }
            });
        }

        @Override
        public void addChangeListener(final ObjectChangeListener<Integer> listener) {
            this.location.addChangeListener(new DoubleChangeListener(){

                public void onChange(double oldValue, double newValue) {
                    listener.onChange((int)oldValue, (int)newValue);
                }
            });
        }

        public double getAsDouble() {
            return this.location.getAsDouble();
        }

        public double setAsDouble(double value) {
            return this.location.setAsDouble(value);
        }

        public double setAsDoubleFromDefault(double value) {
            return this.location.setAsDoubleFromLiteral(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectBooleanLocation
    extends LocationWrapper
    implements BooleanLocation,
    StaticViewLocation {
        private final ObjectLocation<Boolean> location;

        private ObjectBooleanLocation(ObjectLocation<Boolean> location) {
            this.location = location;
        }

        @Override
        protected Location getLocation() {
            return this.location;
        }

        @Override
        public boolean getAsBoolean() {
            Boolean val = this.location.get();
            return val == null ? false : val;
        }

        @Override
        public boolean setAsBoolean(boolean value) {
            return this.location.set(value);
        }

        @Override
        public boolean setAsBooleanFromLiteral(boolean value) {
            return this.location.setFromLiteral(value);
        }

        @Override
        public void setDefault() {
            this.location.setDefault();
        }

        @Override
        public void addChangeListener(final BooleanChangeListener listener) {
            this.location.addChangeListener(new ObjectChangeListener<Boolean>(){

                @Override
                public void onChange(Boolean oldValue, Boolean newValue) {
                    listener.onChange(oldValue, newValue);
                }
            });
        }

        @Override
        public Boolean get() {
            return this.location.get();
        }

        @Override
        public Boolean set(Boolean value) {
            return this.location.set(value);
        }

        @Override
        public Boolean setFromLiteral(Boolean value) {
            return this.location.setFromLiteral(value);
        }

        @Override
        public void addChangeListener(ObjectChangeListener<Boolean> listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public Location getUnderlyingLocation() {
            return this.location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectDoubleLocation<T>
    extends LocationWrapper
    implements DoubleLocation,
    StaticViewLocation {
        private final ObjectLocation<T> location;

        private ObjectDoubleLocation(ObjectLocation<T> location) {
            this.location = location;
        }

        @Override
        protected Location getLocation() {
            return this.location;
        }

        @Override
        public double getAsDouble() {
            T val = this.location.get();
            return val == null ? 0.0 : Numerics.toDouble(val);
        }

        @Override
        public double setAsDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double setAsDoubleFromLiteral(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            this.location.setDefault();
        }

        @Override
        public void addChangeListener(final DoubleChangeListener listener) {
            this.location.addChangeListener(new ObjectChangeListener<T>(){

                @Override
                public void onChange(T oldValue, T newValue) {
                    listener.onChange(Numerics.toDouble(oldValue), Numerics.toDouble(newValue));
                }
            });
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        @Override
        public Double set(Double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double setFromLiteral(Double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addChangeListener(final ObjectChangeListener<Double> listener) {
            this.location.addChangeListener(new ObjectChangeListener<T>(){

                @Override
                public void onChange(T oldValue, T newValue) {
                    listener.onChange(Numerics.toDouble(oldValue), Numerics.toDouble(newValue));
                }
            });
        }

        @Override
        public Location getUnderlyingLocation() {
            return this.location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectIntLocation
    extends LocationWrapper
    implements IntLocation,
    StaticViewLocation {
        private final ObjectLocation<Integer> location;

        private ObjectIntLocation(ObjectLocation<Integer> location) {
            this.location = location;
        }

        @Override
        protected Location getLocation() {
            return this.location;
        }

        @Override
        public int getAsInt() {
            Integer val = this.location.get();
            return val == null ? 0 : val;
        }

        @Override
        public int setAsInt(int value) {
            return this.location.set(value);
        }

        @Override
        public int setAsIntFromLiteral(int value) {
            return this.location.setFromLiteral(value);
        }

        @Override
        public void setDefault() {
            this.location.setDefault();
        }

        @Override
        public void addChangeListener(final IntChangeListener listener) {
            this.location.addChangeListener(new ObjectChangeListener<Integer>(){

                @Override
                public void onChange(Integer oldValue, Integer newValue) {
                    listener.onChange(oldValue, newValue);
                }
            });
        }

        @Override
        public Integer get() {
            return this.location.get();
        }

        @Override
        public Integer set(Integer value) {
            return this.location.set(value);
        }

        @Override
        public Integer setFromLiteral(Integer value) {
            return this.location.setFromLiteral(value);
        }

        @Override
        public void addChangeListener(ObjectChangeListener<Integer> listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public Location getUnderlyingLocation() {
            return this.location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntDoubleLocation
    extends LocationWrapper
    implements DoubleLocation,
    StaticViewLocation {
        private final IntLocation location;

        @Override
        protected IntLocation getLocation() {
            return this.location;
        }

        public IntDoubleLocation(IntLocation location) {
            this.location = location;
        }

        @Override
        public double getAsDouble() {
            return this.location.getAsInt();
        }

        public void addChangeListener(IntChangeListener listener) {
            this.location.addChangeListener(listener);
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        @Override
        public double setAsDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double setAsDoubleFromLiteral(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double set(Double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double setFromLiteral(Double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Location getUnderlyingLocation() {
            return this.location;
        }

        @Override
        public void addChangeListener(final DoubleChangeListener listener) {
            this.location.addChangeListener(new IntChangeListener(){

                public void onChange(int oldValue, int newValue) {
                    listener.onChange(oldValue, newValue);
                }
            });
        }

        @Override
        public void addChangeListener(final ObjectChangeListener<Double> listener) {
            this.location.addChangeListener(new IntChangeListener(){

                public void onChange(int oldValue, int newValue) {
                    listener.onChange(Double.valueOf(oldValue), Double.valueOf(newValue));
                }
            });
        }

        public int getAsInt() {
            return this.location.getAsInt();
        }

        public int setAsInt(int value) {
            return this.location.setAsInt(value);
        }

        public int setAsIntFromDefault(int value) {
            return this.location.setAsIntFromLiteral(value);
        }
    }

    private static abstract class LocationWrapper
    implements Location {
        private LocationWrapper() {
        }

        protected abstract Location getLocation();

        public boolean isValid() {
            return this.getLocation().isValid();
        }

        public boolean isNull() {
            return this.getLocation().isNull();
        }

        public boolean isMutable() {
            return this.getLocation().isMutable();
        }

        public boolean hasDependencies() {
            return this.getLocation().hasDependencies();
        }

        public void invalidate() {
            this.getLocation().invalidate();
        }

        public void update() {
            this.getLocation().update();
        }

        public void addChangeListener(ChangeListener listener) {
            this.getLocation().addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.getLocation().removeChangeListener(listener);
        }

        public ChangeListener getListeners() {
            return this.getLocation().getListeners();
        }

        public void addDependency(Location ... location) {
            this.getLocation().addDependency(location);
        }

        public void addDependency(Location location) {
            this.getLocation().addDependency(location);
        }

        public void addDynamicDependency(Location location) {
            this.getLocation().addDynamicDependency(location);
        }

        public void clearDynamicDependencies() {
            this.getLocation().clearDynamicDependencies();
        }

        public void addDependentLocation(WeakLocation location) {
            this.getLocation().addDependentLocation(location);
        }
    }
}

