/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.location;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.location.AbstractVariable;
import com.sun.javafx.runtime.location.Location;
import com.sun.javafx.runtime.location.ObjectBindingExpression;
import com.sun.javafx.runtime.location.ObjectChangeListener;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.util.AbstractLinkable;
import com.sun.javafx.runtime.util.Linkable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectVariable<T>
extends AbstractVariable<T, ObjectLocation<T>, ObjectBindingExpression<T>, ObjectChangeListener<T>>
implements ObjectLocation<T> {
    protected T $value;
    protected T $default;

    public static <T> ObjectVariable<T> make() {
        return new ObjectVariable<T>();
    }

    public static <T> ObjectVariable<T> makeWithDefault(T deflt) {
        ObjectVariable<T> result = new ObjectVariable<T>();
        result.$default = deflt;
        result.$value = deflt;
        return result;
    }

    public static <T> ObjectVariable<T> make(T value) {
        return new ObjectVariable<T>(value);
    }

    public static <T> ObjectVariable<T> make(boolean lazy, ObjectBindingExpression<T> binding, Location ... dependencies) {
        return new ObjectVariable<Object>(null, lazy, binding, dependencies);
    }

    public static <T> ObjectVariable<T> make(ObjectBindingExpression<T> binding, Location ... dependencies) {
        return new ObjectVariable<Object>(null, false, binding, dependencies);
    }

    public static <T> ObjectVariable<T> make(T dflt, boolean lazy, ObjectBindingExpression<T> binding, Location ... dependencies) {
        return new ObjectVariable<T>(dflt, lazy, binding, dependencies);
    }

    public static <T> ObjectVariable<T> make(T dflt, ObjectBindingExpression<T> binding, Location ... dependencies) {
        return new ObjectVariable<T>(dflt, false, binding, dependencies);
    }

    public static <T> ObjectVariable<T> makeBijective(ObjectLocation<T> other) {
        ObjectVariable<T> me = ObjectVariable.make();
        me.bijectiveBind(other);
        return me;
    }

    protected ObjectVariable() {
    }

    protected ObjectVariable(T value) {
        super((byte)2);
        this.$value = value;
        this.setValid();
    }

    protected ObjectVariable(T dflt, boolean lazy, ObjectBindingExpression<T> binding, Location ... dependencies) {
        this();
        this.$default = dflt;
        this.bind(lazy, binding, new Location[0]);
        this.addDependency(dependencies);
    }

    @Override
    protected ObjectBindingExpression<T> makeBindingExpression(final ObjectLocation<T> otherLocation) {
        return new ObjectBindingExpression<T>(){

            @Override
            public T computeValue() {
                return otherLocation.get();
            }
        };
    }

    @Override
    public T get() {
        if (this.isUnidirectionallyBound() && !this.isValid()) {
            this.update();
        }
        return this.$value;
    }

    protected T replaceValue(T newValue) {
        T oldValue = this.$value;
        if (this.preReplace(!Util.isEqual(oldValue, newValue))) {
            boolean invalidateDependencies = this.isValid() || this.state == 2;
            this.$value = newValue;
            this.setValid();
            this.notifyListeners(oldValue, newValue, invalidateDependencies);
        } else {
            this.setValid();
        }
        return newValue;
    }

    @Override
    public T set(T value) {
        if (this.isUnidirectionallyBound() && !Util.isEqual(this.$value, value)) {
            throw new AssignToBoundException("Cannot assign to bound variable");
        }
        return this.replaceValue(value);
    }

    @Override
    public void setDefault() {
        if (this.state == 0) {
            this.$value = this.$default;
            this.state = 1;
            this.notifyListeners(this.$default, this.$default, true);
        } else {
            this.set(this.$default);
        }
    }

    @Override
    public void update() {
        block3: {
            try {
                if (this.isUnidirectionallyBound() && !this.isValid()) {
                    this.replaceValue(((ObjectBindingExpression)this.binding).computeValue());
                }
            }
            catch (RuntimeException e) {
                ErrorHandler.bindException(e);
                if (!this.isInitialized()) break block3;
                this.replaceValue(this.$default);
            }
        }
    }

    @Override
    public boolean isNull() {
        return this.$value == null;
    }

    private void notifyListeners(final T oldValue, final T newValue, boolean invalidateDependencies) {
        if (invalidateDependencies) {
            this.invalidateDependencies();
        }
        if (this.replaceListeners != null) {
            AbstractLinkable.iterate(this.replaceListeners, new Linkable.IterationClosure<ObjectChangeListener<T>>(){

                @Override
                public void action(ObjectChangeListener<T> listener) {
                    try {
                        listener.onChange(oldValue, newValue);
                    }
                    catch (RuntimeException e) {
                        ErrorHandler.triggerException(e);
                    }
                }
            });
        }
    }
}

