/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.IntVariable;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.BoundCompositeSequence;
import com.sun.javafx.runtime.sequence.DumbMutableSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBoundComprehension<T, L extends ObjectLocation<T>, V>
extends AbstractBoundSequence<V>
implements SequenceLocation<V> {
    private final SequenceLocation<T> sequenceLocation;
    protected final boolean useIndex;
    private DumbMutableSequence<State<T, L, V>> state;
    private BoundCompositeSequence<V> underlying;

    public AbstractBoundComprehension(Class<V> clazz, SequenceLocation<T> sequenceLocation, boolean useIndex) {
        super(clazz);
        this.sequenceLocation = sequenceLocation;
        this.useIndex = useIndex;
        this.setInitialValue(this.computeValue());
        this.addTriggers();
    }

    public AbstractBoundComprehension(Class<V> clazz, SequenceLocation<T> sequenceLocation) {
        this(clazz, sequenceLocation, false);
    }

    private Sequence<V> computeValue() {
        Sequence<T> sequence = this.sequenceLocation.getAsSequence();
        this.state = new DumbMutableSequence(sequence.size());
        SequenceLocation<T>[] locationsArray = Util.newSequenceLocationArray(sequence.size());
        State[] newStates = State.newArray(sequence.size());
        this.fillInNewValues(sequence, newStates, locationsArray, 0);
        this.state.replaceSlice(0, -1, newStates);
        this.underlying = new BoundCompositeSequence(this.getClazz(), locationsArray);
        return this.underlying.getAsSequence();
    }

    private void fillInNewValues(Sequence<? extends T> sequence, State<T, L, V>[] newStates, SequenceLocation<V>[] locationsArray, int offset) {
        int i = 0;
        for (T value : sequence) {
            State<T, L, V> stateElt = this.makeState(i + offset, value);
            newStates[i] = stateElt;
            locationsArray[i++] = ((State)stateElt).mapped;
        }
    }

    protected abstract SequenceLocation<V> computeElements$(L var1, IntLocation var2);

    protected abstract L makeInductionLocation(T var1);

    private State<T, L, V> makeState(int index, T value) {
        L elementLocation = this.makeInductionLocation(value);
        IntVariable indexLocation = this.useIndex ? IntVariable.make(index) : null;
        SequenceLocation<V> mapped = this.computeElements$(elementLocation, indexLocation);
        return new State(elementLocation, indexLocation, mapped);
    }

    private void addTriggers() {
        this.underlying.addChangeListener(new SequenceChangeListener<V>(){

            @Override
            public void onChange(int startPos, int endPos, Sequence<? extends V> newElements, Sequence<V> oldValue, Sequence<V> newValue) {
                AbstractBoundComprehension.this.updateSlice(startPos, endPos, newElements);
            }
        });
        this.sequenceLocation.addChangeListener(new SequenceChangeListener<T>(){

            @Override
            public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                block3: {
                    block2: {
                        int deletedCount;
                        int insertedCount = Sequences.size(newElements);
                        int netAdded = insertedCount - (deletedCount = endPos - startPos + 1);
                        if (netAdded != 0) break block2;
                        for (int i = startPos; i <= endPos; ++i) {
                            ((State)AbstractBoundComprehension.this.state.get(i)).element.set(newElements.get(i - startPos));
                        }
                        break block3;
                    }
                    SequenceLocation[] locationsArray = Util.newSequenceLocationArray(newElements.size());
                    State[] newStates = State.newArray(newElements.size());
                    AbstractBoundComprehension.this.fillInNewValues(newElements, newStates, locationsArray, startPos);
                    AbstractBoundComprehension.this.underlying.replaceSlice(startPos, endPos, locationsArray);
                    AbstractBoundComprehension.this.state.replaceSlice(startPos, endPos, newStates);
                    if (!AbstractBoundComprehension.this.useIndex) break block3;
                    int length = AbstractBoundComprehension.this.state.size();
                    for (int i = endPos + 1 + netAdded; i < length; ++i) {
                        ((State)AbstractBoundComprehension.this.state.get(i)).index.set(i);
                    }
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class State<T, L extends ObjectLocation<T>, V> {
        private SequenceLocation<V> mapped;
        private final L element;
        private final IntLocation index;

        State(L element, IntLocation index, SequenceLocation<V> mapped) {
            this.element = element;
            this.index = index;
            this.mapped = mapped;
        }

        private static <T, L extends ObjectLocation<T>, V> State<T, L, V>[] newArray(int size) {
            return new State[size];
        }
    }
}

