/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.location.IntChangeListener;
import com.sun.javafx.runtime.location.IntLocation;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BoundSequenceSlice<T>
extends AbstractBoundSequence<T>
implements SequenceLocation<T> {
    private final SequenceLocation<T> sequenceLoc;
    private final IntLocation lowerLoc;
    private final IntLocation upperLoc;
    private final boolean isExclusive;
    private int lower;
    private int upper;
    private int size;

    BoundSequenceSlice(Class<T> clazz, SequenceLocation<T> sequenceLoc, IntLocation lowerLoc, IntLocation upperLoc, boolean isExclusive) {
        super(clazz);
        this.sequenceLoc = sequenceLoc;
        this.lowerLoc = lowerLoc;
        this.upperLoc = upperLoc;
        this.isExclusive = isExclusive;
        this.setInitialValue(this.computeValue());
        this.addTriggers();
    }

    private Sequence<T> computeValue() {
        this.computeBounds(true, true);
        return ((Sequence)this.sequenceLoc.get()).getSlice(this.lower, this.upper);
    }

    private int adjusted(int upperValue) {
        return (this.isExclusive ? -1 : 0) + upperValue;
    }

    private void computeBounds(boolean updateLower, boolean updateUpper) {
        int seqSize = this.sequenceLoc.getAsSequence().size();
        if (updateLower) {
            this.lower = (Integer)this.lowerLoc.get();
        }
        if (updateUpper) {
            this.upper = this.adjusted(this.upperLoc == null ? seqSize - 1 : (Integer)this.upperLoc.get());
        }
        if (seqSize == 0) {
            this.size = 0;
        } else {
            int range = (this.upper >= seqSize ? seqSize - 1 : this.upper) - (this.lower < 0 ? 0 : this.lower);
            this.size = range >= 0 ? range + 1 : 0;
        }
    }

    protected Sequence<T> computeFull(int lower, int upper) {
        return this.sequenceLoc.getSlice(lower, upper);
    }

    private void addTriggers() {
        this.sequenceLoc.addChangeListener(new SequenceChangeListener<T>(){

            @Override
            public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                BoundSequenceSlice.this.computeBounds(true, true);
                Sequence newSeq = newValue.getSlice(BoundSequenceSlice.this.lower, BoundSequenceSlice.this.upper);
                BoundSequenceSlice.this.updateSlice(0, BoundSequenceSlice.this.size == 0 ? 0 : BoundSequenceSlice.this.size - 1, newSeq, newSeq);
            }
        });
        this.lowerLoc.addChangeListener(new IntChangeListener(){

            public void onChange(int oldValue, int newValue) {
                assert (oldValue != newValue);
                int oldSize = BoundSequenceSlice.this.size;
                BoundSequenceSlice.this.computeBounds(true, false);
                if (BoundSequenceSlice.this.sequenceLoc.getAsSequence().size() > 0 && BoundSequenceSlice.this.size != oldSize) {
                    if (BoundSequenceSlice.this.size > oldSize) {
                        BoundSequenceSlice.this.updateSlice(0, -1, BoundSequenceSlice.this.sequenceLoc.getSlice(newValue, oldSize == 0 ? BoundSequenceSlice.this.upper : oldValue - 1));
                    } else {
                        BoundSequenceSlice.this.updateSlice(0, oldSize - BoundSequenceSlice.this.size - 1, BoundSequenceSlice.this.sequenceLoc.getAsSequence().getEmptySequence());
                    }
                }
            }
        });
        if (this.upperLoc != null) {
            this.upperLoc.addChangeListener(new IntChangeListener(){

                public void onChange(int oldValue, int newValue) {
                    assert (oldValue != newValue);
                    int oldSize = BoundSequenceSlice.this.size;
                    BoundSequenceSlice.this.computeBounds(false, true);
                    if (BoundSequenceSlice.this.sequenceLoc.getAsSequence().size() > 0 && BoundSequenceSlice.this.size != oldSize) {
                        if (BoundSequenceSlice.this.size > oldSize) {
                            int oldUpper = BoundSequenceSlice.this.adjusted(oldValue);
                            BoundSequenceSlice.this.updateSlice(oldSize, oldSize - 1, BoundSequenceSlice.this.sequenceLoc.getSlice(oldUpper >= BoundSequenceSlice.this.lower ? oldUpper + 1 : BoundSequenceSlice.this.lower, BoundSequenceSlice.this.upper));
                        } else {
                            BoundSequenceSlice.this.updateSlice(BoundSequenceSlice.this.size, oldSize - 1, BoundSequenceSlice.this.sequenceLoc.getAsSequence().getEmptySequence());
                        }
                    }
                }
            });
        }
    }
}

