/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianProduct2D<T, U, V>
extends AbstractSequence<T>
implements Sequence<T> {
    private final Sequence<U> seq1;
    private final Sequence<V> seq2;
    private final Mapper<T, U, V> mapper;

    public CartesianProduct2D(TypeInfo<T> ti, Sequence<U> seq1, Sequence<V> seq2, Mapper<T, U, V> mapper) {
        super(ti);
        this.seq1 = seq1;
        this.seq2 = seq2;
        this.mapper = mapper;
    }

    @Override
    public int getDepth() {
        return Math.max(this.seq1.getDepth(), this.seq2.getDepth()) + 1;
    }

    @Override
    public int size() {
        return this.seq1.size() * this.seq2.size();
    }

    @Override
    public T get(int position) {
        int index1 = position / this.seq2.size();
        int index2 = position % this.seq2.size();
        return this.mapper.map(index1, this.seq1.get(index1), index2, this.seq2.get(index2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mapper<T, U, V> {
        public T map(int var1, U var2, int var3, V var4);
    }
}

