/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeSequence<T>
extends AbstractSequence<T>
implements Sequence<T> {
    private final Sequence<? extends T>[] sequences;
    private final int[] startPositions;
    private final int size;
    private final int depth;

    public CompositeSequence(TypeInfo<T> ti, Sequence<? extends T> ... sequences) {
        super(ti);
        this.sequences = Util.newSequenceArray(sequences.length);
        System.arraycopy(sequences, 0, this.sequences, 0, sequences.length);
        this.startPositions = new int[sequences.length];
        int tmpSize = 0;
        int tmpDepth = 0;
        int offset = 0;
        for (int i = 0; i < sequences.length; ++i) {
            this.startPositions[i] = offset;
            tmpSize += sequences[i].size();
            offset += sequences[i].size();
            tmpDepth = Math.max(tmpDepth, sequences[i].getDepth());
        }
        this.size = tmpSize;
        this.depth = tmpDepth + 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public T get(int position) {
        int chunk;
        if (position < 0 || position >= this.size) {
            return this.getDefaultValue();
        }
        for (chunk = 0; chunk < this.sequences.length - 1 && (position >= this.startPositions[chunk + 1] || this.sequences[chunk].size() == 0); ++chunk) {
        }
        return this.sequences[chunk].get(position - this.startPositions[chunk]);
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int chunk = 0; chunk < this.sequences.length && length > 0; ++chunk) {
            if (sourceOffset <= this.sequences[chunk].size()) {
                int chunk_length = Math.min(length, this.sequences[chunk].size() - sourceOffset);
                this.sequences[chunk].toArray(sourceOffset, chunk_length, dest, destOffset);
                length -= chunk_length;
                destOffset += chunk_length;
            }
            sourceOffset -= Math.min(sourceOffset, this.sequences[chunk].size());
        }
    }
}

