/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.sequence.DerivedSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementReplacementSequence<T>
extends DerivedSequence<T>
implements Sequence<T> {
    private final int gapPos;
    private final int gapSize;
    private final T newValue;

    ElementReplacementSequence(Sequence<T> sequence, int gapStartPos, int gapEndPos, T newValue) {
        super(sequence.getElementType(), sequence, Sequences.size(sequence) + 1 - (gapEndPos - gapStartPos));
        this.gapPos = gapStartPos;
        this.gapSize = gapEndPos - gapStartPos;
        this.newValue = newValue;
    }

    @Override
    public T get(int position) {
        if (position < this.gapPos) {
            return this.sequence.get(position);
        }
        if (position == this.gapPos) {
            return this.newValue;
        }
        return this.sequence.get(position + this.gapSize - 1);
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int lengthFirstSeq = 0;
        if (sourceOffset < this.gapPos) {
            lengthFirstSeq = Math.min(this.gapPos - sourceOffset, length);
            this.sequence.toArray(sourceOffset, lengthFirstSeq, dest, destOffset);
        }
        int lengthReplacement = 0;
        if (sourceOffset <= this.gapPos && sourceOffset + length > this.gapPos) {
            lengthReplacement = 1;
            dest[destOffset + lengthFirstSeq] = this.newValue;
        }
        if (sourceOffset + length > this.gapPos + 1) {
            int startSecondSeq = this.gapSize + Math.max(this.gapPos, sourceOffset - 1);
            int lengthSecondSeq = length - lengthFirstSeq - lengthReplacement;
            this.sequence.toArray(startSecondSeq, lengthSecondSeq, dest, destOffset + lengthFirstSeq + lengthReplacement);
        }
    }
}

