/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NumberRangeSequence
extends AbstractSequence<Double>
implements Sequence<Double> {
    private final double start;
    private final double step;
    private final int size;

    public NumberRangeSequence(double start, double bound, double step, boolean exclusive) {
        super(TypeInfo.Double);
        this.start = start;
        this.step = step;
        if (bound == start) {
            this.size = exclusive ? 0 : 1;
        } else {
            long size;
            long l = size = bound < start && step > 0.0 || bound > start && step < 0.0 ? 0L : Math.max(0L, (long)((bound - start) / step) + 1L);
            if (exclusive) {
                boolean tooBig;
                boolean bl = step > 0.0 ? start + (double)(size - 1L) * step >= bound : (tooBig = start + (double)(size - 1L) * step <= bound);
                if (tooBig && size > 0L) {
                    --size;
                }
            }
            if (size > Integer.MAX_VALUE || size < 0L) {
                throw new IllegalArgumentException("Range sequence too big");
            }
            this.size = (int)size;
        }
    }

    public NumberRangeSequence(double start, double bound, double step) {
        this(start, bound, step, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Double get(int position) {
        if (position < 0 || position >= this.size) {
            return 0.0;
        }
        return this.start + (double)position * this.step;
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double value = this.start + (double)sourceOffset * this.step;
        for (int index = destOffset; index < destOffset + length; ++index) {
            dest[index] = value;
            value += this.step;
        }
    }
}

