/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.CompositeSequence;
import com.sun.javafx.runtime.sequence.ElementReplacementSequence;
import com.sun.javafx.runtime.sequence.FilterSequence;
import com.sun.javafx.runtime.sequence.IntRangeSequence;
import com.sun.javafx.runtime.sequence.MapSequence;
import com.sun.javafx.runtime.sequence.NumberRangeSequence;
import com.sun.javafx.runtime.sequence.ReplacementSequence;
import com.sun.javafx.runtime.sequence.ReverseSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequenceConversions;
import com.sun.javafx.runtime.sequence.SequenceMapper;
import com.sun.javafx.runtime.sequence.SequenceMutator;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.SingletonSequence;
import com.sun.javafx.runtime.sequence.SliceReplacementSequence;
import com.sun.javafx.runtime.sequence.SubSequence;
import com.sun.javafx.runtime.util.MathUtil;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sequences
extends SequenceConversions {
    public static final int FLATTENING_THRESHOLD = 16;

    private Sequences() {
    }

    public static <T> Sequence<T> make(TypeInfo<T> ti, T ... values) {
        if (values == null || values.length == 0) {
            return ti.emptySequence;
        }
        return new ArraySequence<T>(ti, values);
    }

    public static <T> Sequence<T> make(TypeInfo<T> ti, T[] values, int size) {
        if (values == null || size <= 0) {
            return ti.emptySequence;
        }
        return new ArraySequence<T>(ti, values, size);
    }

    public static <T> Sequence<T> makeViaHandoff(TypeInfo<T> ti, T[] values) {
        return new ArraySequence<T>(ti, values, true);
    }

    public static <T> Sequence<T> make(TypeInfo<T> ti, List<? extends T> values) {
        if (values == null || values.size() == 0) {
            return ti.emptySequence;
        }
        return new ArraySequence<T>(ti, values);
    }

    static <T> Sequence<T> flatten(Sequence<T> seq) {
        if (seq.getDepth() == 0) {
            return seq;
        }
        return new ArraySequence<T>(seq.getElementType(), seq);
    }

    static <T> boolean shouldFlatten(Sequence<T> sequence) {
        int size = Sequences.size(sequence);
        return 0 < size && size <= 16 || sequence.getDepth() > MathUtil.log2(size);
    }

    public static <T> Sequence<T> concatenate(TypeInfo<T> ti, Sequence<? extends T> first, Sequence<? extends T> second) {
        int size1 = Sequences.size(first);
        int size2 = Sequences.size(second);
        if (size1 == 0) {
            return Sequences.upcast(second);
        }
        if (size2 == 0) {
            return Sequences.upcast(first);
        }
        if (size1 + size2 <= 16) {
            return new ArraySequence<T>(ti, first, second);
        }
        return new CompositeSequence<T>(ti, first, second);
    }

    public static <T> Sequence<T> concatenate(TypeInfo<T> ti, Sequence<? extends T> ... seqs) {
        int size = 0;
        for (Sequence<? extends T> i : seqs) {
            size += Sequences.size(i);
        }
        if (size <= 16) {
            return new ArraySequence<T>(ti, seqs);
        }
        return new CompositeSequence<T>(ti, seqs);
    }

    public static Sequence<Integer> range(int lower, int upper) {
        return new IntRangeSequence(lower, upper);
    }

    public static Sequence<Integer> range(int lower, int upper, int step) {
        return new IntRangeSequence(lower, upper, step);
    }

    public static Sequence<Integer> rangeExclusive(int lower, int upper) {
        return new IntRangeSequence(lower, upper, true);
    }

    public static Sequence<Integer> rangeExclusive(int lower, int upper, int step) {
        return new IntRangeSequence(lower, upper, step, true);
    }

    public static Sequence<Double> range(double lower, double upper) {
        return new NumberRangeSequence(lower, upper, 1.0);
    }

    public static Sequence<Double> range(double lower, double upper, double step) {
        return new NumberRangeSequence(lower, upper, step);
    }

    public static Sequence<Double> rangeExclusive(double lower, double upper) {
        return new NumberRangeSequence(lower, upper, 1.0, true);
    }

    public static Sequence<Double> rangeExclusive(double lower, double upper, double step) {
        return new NumberRangeSequence(lower, upper, step, true);
    }

    public static <T> Sequence<T> filter(Sequence<T> seq, BitSet bits) {
        if (bits.cardinality() == seq.size() && bits.nextClearBit(0) == seq.size()) {
            return seq;
        }
        if (bits.cardinality() == 0) {
            return seq.getEmptySequence();
        }
        FilterSequence<T> result = new FilterSequence<T>(seq, bits);
        if (Sequences.shouldFlatten(result)) {
            return Sequences.flatten(result);
        }
        return result;
    }

    public static <T> Sequence<T> subsequence(Sequence<T> seq, int start, int end) {
        if (start >= end) {
            return seq.getEmptySequence();
        }
        if (start <= 0 && end >= seq.size()) {
            return seq;
        }
        start = Math.max(start, 0);
        end = Math.min(end, seq.size());
        return new SubSequence<T>(seq, start, end);
    }

    public static <T> Sequence<T> singleton(TypeInfo<T> ti, T t) {
        if (t == null) {
            return ti.emptySequence;
        }
        return new SingletonSequence<T>(ti, t);
    }

    public static <T> Sequence<T> emptySequence(Class<T> clazz) {
        return TypeInfo.getTypeInfo(clazz).emptySequence;
    }

    public static <T> Sequence<T> reverse(Sequence<T> sequence) {
        return new ReverseSequence<T>(sequence);
    }

    public static <T, U> Sequence<U> map(TypeInfo<U> ti, Sequence<T> sequence, SequenceMapper<T, U> mapper) {
        return new MapSequence<T, U>(ti, sequence, mapper);
    }

    public static <T> Sequence<T> fromCollection(TypeInfo<T> ti, Collection<T> values) {
        if (values == null) {
            return ti.emptySequence;
        }
        return new ArraySequence<Object>(ti, values.toArray());
    }

    public static <T> Sequence<T> replace(Sequence<T> sequence, int startPos, int endPos, Sequence<? extends T> replacement) {
        int seqSize = Sequences.size(sequence);
        startPos = Math.min(Math.max(0, startPos), seqSize);
        endPos = Math.min(Math.max(startPos, endPos), seqSize);
        return new SliceReplacementSequence<T>(sequence, startPos, endPos, replacement);
    }

    public static <T> Sequence<T> replace(Sequence<T> sequence, int startPos, int endPos, T value) {
        int seqSize = Sequences.size(sequence);
        startPos = Math.min(Math.max(0, startPos), seqSize);
        endPos = Math.min(Math.max(startPos, endPos), seqSize);
        return new ElementReplacementSequence<T>(sequence, startPos, endPos, value);
    }

    public static <T> Sequence<T> replace(Sequence<T> sequence, int startPos, T value) {
        return new ReplacementSequence<T>(sequence, startPos, value);
    }

    public static <T> Sequence<T> upcast(Sequence<? extends T> sequence) {
        return sequence;
    }

    public static Sequence<Double> integerSequenceToNumberSequence(Sequence<Integer> seq) {
        if (seq == null || seq.size() == 0) {
            return TypeInfo.Double.emptySequence;
        }
        int length = seq.size();
        Double[] dArray = (Double[])Util.newObjectArray(length);
        for (int i = 0; i < length; ++i) {
            dArray[i] = (double)seq.get(i);
        }
        return new ArraySequence<Double>(TypeInfo.Double, (T[])dArray, length);
    }

    public static int size(Object seq) {
        if (seq instanceof Sequence) {
            return ((Sequence)seq).size();
        }
        return seq == null ? 0 : 1;
    }

    public static int size(Sequence seq) {
        return seq == null ? 0 : seq.size();
    }

    public static <T> boolean isEqual(Sequence<?> one, Sequence<?> other) {
        int oneSize = Sequences.size(one);
        int otherSize = Sequences.size(other);
        if (oneSize == 0) {
            return otherSize == 0;
        }
        if (oneSize != otherSize) {
            return false;
        }
        Iterator<?> it1 = one.iterator();
        Iterator<?> it2 = other.iterator();
        while (it1.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEqualByContentIdentity(Sequence<? extends T> one, Sequence<? extends T> other) {
        int oneSize = Sequences.size(one);
        if (oneSize == 0) {
            return Sequences.size(other) == 0;
        }
        if (oneSize != Sequences.size(other)) {
            return false;
        }
        Iterator<T> it1 = one.iterator();
        Iterator<T> it2 = other.iterator();
        while (it1.hasNext()) {
            if (it1.next() == it2.next()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean sliceEqual(Sequence<T> seq, int startPos, int endPos, Sequence<? extends T> slice) {
        if (endPos - startPos + 1 != Sequences.size(slice)) {
            return false;
        }
        for (int i = startPos; i <= endPos; ++i) {
            if (seq.get(i).equals(slice.get(i - startPos))) continue;
            return false;
        }
        return true;
    }

    public static <T> Sequence<? extends T> forceNonNull(Class<T> clazz, Sequence<? extends T> seq) {
        return seq == null ? Sequences.emptySequence(clazz) : seq;
    }

    public static <T> T getSingleValue(Sequence<T> seq) {
        if (seq == null || seq.size() != 1) {
            return null;
        }
        return seq.get(0);
    }

    public static <T extends Comparable> int binarySearch(Sequence<? extends T> seq, T key) {
        if (seq.isEmpty()) {
            return -1;
        }
        int length = seq.size();
        Object[] array = Util.newComparableArray((int)length);
        seq.toArray(0, length, array, 0);
        return Arrays.binarySearch(array, key);
    }

    public static <T> int binarySearch(Sequence<? extends T> seq, T key, Comparator<? super T> c) {
        if (seq.isEmpty()) {
            return -1;
        }
        int length = seq.size();
        Object[] array = Util.newObjectArray(length);
        seq.toArray(0, length, array, 0);
        return Arrays.binarySearch(array, key, c);
    }

    public static <T> int indexByIdentity(Sequence<? extends T> seq, T key) {
        return Sequences.nextIndexByIdentity(seq, key, 0);
    }

    public static <T> int indexOf(Sequence<? extends T> seq, T key) {
        return Sequences.nextIndexOf(seq, key, 0);
    }

    public static <T extends Comparable> T max(Sequence<T> seq) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.max");
        }
        Iterator<T> it = seq.iterator();
        Comparable result = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable current = (Comparable)it.next();
            if (current.compareTo(result) <= 0) continue;
            result = current;
        }
        return (T)result;
    }

    public static <T> T max(Sequence<T> seq, Comparator<? super T> c) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.max");
        }
        if (c == null) {
            return Sequences.max(seq);
        }
        Iterator<T> it = seq.iterator();
        T result = it.next();
        while (it.hasNext()) {
            T current = it.next();
            if (c.compare(current, result) <= 0) continue;
            result = current;
        }
        return result;
    }

    public static <T extends Comparable> T min(Sequence<T> seq) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.min");
        }
        Iterator<T> it = seq.iterator();
        Comparable result = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable current = (Comparable)it.next();
            if (current.compareTo(result) >= 0) continue;
            result = current;
        }
        return (T)result;
    }

    public static <T> T min(Sequence<T> seq, Comparator<? super T> c) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.min");
        }
        if (c == null) {
            return Sequences.min(seq);
        }
        Iterator<T> it = seq.iterator();
        T result = it.next();
        while (it.hasNext()) {
            T current = it.next();
            if (c.compare(current, result) >= 0) continue;
            result = current;
        }
        return result;
    }

    public static <T> int nextIndexByIdentity(Sequence<? extends T> seq, T key, int pos) {
        int i;
        if (seq == null) {
            return -1;
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Iterator<T> it = seq.iterator();
        for (i = 0; i < pos && it.hasNext(); ++i) {
            it.next();
        }
        while (it.hasNext()) {
            if (it.next() == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int nextIndexOf(Sequence<? extends T> seq, T key, int pos) {
        int i;
        if (seq == null) {
            return -1;
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Iterator<T> it = seq.iterator();
        for (i = 0; i < pos && it.hasNext(); ++i) {
            it.next();
        }
        while (it.hasNext()) {
            if (it.next().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T extends Comparable> Sequence<T> sort(Sequence<T> seq) {
        if (seq.isEmpty()) {
            return seq.getEmptySequence();
        }
        int length = seq.size();
        Object[] array = Util.newComparableArray((int)length);
        seq.toArray(0, length, array, 0);
        Arrays.sort(array);
        return Sequences.make(seq.getElementType(), array);
    }

    public static <T> Sequence<T> sort(Sequence<T> seq, Comparator<? super T> c) {
        if (seq.isEmpty()) {
            return seq.getEmptySequence();
        }
        int length = seq.size();
        Object[] array = Util.newObjectArray(length);
        seq.toArray(0, length, array, 0);
        Arrays.sort(array, c);
        return Sequences.make(seq.getElementType(), array);
    }

    public static <T> Sequence<T> insert(Sequence<T> sequence, T value) {
        return SequenceMutator.insert(sequence, (SequenceMutator.Listener)null, value);
    }

    public static <T> Sequence<T> insert(Sequence<T> sequence, Sequence<? extends T> values) {
        return SequenceMutator.insert(sequence, (SequenceMutator.Listener)null, values);
    }

    public static <T> Sequence<T> insertFirst(Sequence<T> sequence, T value) {
        return SequenceMutator.insertFirst(sequence, null, value);
    }

    public static <T> Sequence<T> insertFirst(Sequence<T> sequence, Sequence<? extends T> values) {
        return SequenceMutator.insertFirst(sequence, (SequenceMutator.Listener)null, values);
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> sequence, T value, int position) {
        return SequenceMutator.insertBefore(sequence, null, value, position);
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> sequence, Sequence<? extends T> values, int position) {
        return SequenceMutator.insertBefore(sequence, null, values, position);
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> sequence, T value, int position) {
        return SequenceMutator.insertAfter(sequence, null, value, position);
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> sequence, Sequence<? extends T> values, int position) {
        return SequenceMutator.insertAfter(sequence, null, values, position);
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> sequence, T value, SequencePredicate<? super T> predicate) {
        return SequenceMutator.insertBefore(sequence, null, value, predicate);
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> sequence, Sequence<? extends T> values, SequencePredicate<? super T> predicate) {
        return SequenceMutator.insertBefore(sequence, null, values, predicate);
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> sequence, T value, SequencePredicate<? super T> predicate) {
        return SequenceMutator.insertAfter(sequence, null, value, predicate);
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> sequence, Sequence<? extends T> values, SequencePredicate<? super T> predicate) {
        return SequenceMutator.insertAfter(sequence, null, values, predicate);
    }

    public static <T> Sequence<T> delete(Sequence<T> sequence, int position) {
        return SequenceMutator.delete(sequence, null, position);
    }

    public static <T> Sequence<T> delete(Sequence<T> sequence, SequencePredicate<? super T> predicate) {
        return SequenceMutator.delete(sequence, (SequenceMutator.Listener)null, predicate);
    }

    public static <T> Sequence<T> set(Sequence<T> sequence, int position, T value) {
        return SequenceMutator.set(sequence, null, position, value);
    }

    public static <T> Sequence<T> replaceSlice(Sequence<T> sequence, int startPos, int endPos, Sequence<? extends T> newValues) {
        return SequenceMutator.replaceSlice(sequence, null, startPos, endPos, newValues);
    }

    public static <T> Sequence<T> shuffle(Sequence<T> seq) {
        T[] array = Sequences.toArray(seq);
        List<T> list = Arrays.asList(array);
        Collections.shuffle(list);
        return Sequences.make(seq.getElementType(), list);
    }
}

