/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.sequence.DerivedSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SliceReplacementSequence<T>
extends DerivedSequence<T>
implements Sequence<T> {
    private final int gapPos;
    private final int gapSize;
    private final Sequence<? extends T> replacementSequence;

    SliceReplacementSequence(Sequence<T> sequence, int gapStartPos, int gapEndPos, Sequence<? extends T> replacementSequence) {
        super(sequence.getElementType(), sequence, Sequences.size(sequence) + Sequences.size(replacementSequence) - (gapEndPos - gapStartPos));
        this.gapPos = gapStartPos;
        this.gapSize = gapEndPos - gapStartPos;
        this.replacementSequence = replacementSequence;
    }

    @Override
    public T get(int position) {
        if (position < this.gapPos) {
            return this.sequence.get(position);
        }
        int pos = position - this.gapPos;
        int replacementSize = Sequences.size(this.replacementSequence);
        if (pos < replacementSize) {
            return this.replacementSequence.get(pos);
        }
        return this.sequence.get(position + this.gapSize - replacementSize);
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int lengthFirstSeq = 0;
        if (sourceOffset < this.gapPos) {
            lengthFirstSeq = Math.min(this.gapPos - sourceOffset, length);
            this.sequence.toArray(sourceOffset, lengthFirstSeq, dest, destOffset);
        }
        int replacementSize = Sequences.size(this.replacementSequence);
        int lengthReplacement = 0;
        if (replacementSize > 0 && sourceOffset < this.gapPos + replacementSize && sourceOffset + length > this.gapPos) {
            int startReplacement = Math.max(0, sourceOffset - this.gapPos);
            lengthReplacement = Math.min(replacementSize - startReplacement, length - lengthFirstSeq);
            this.replacementSequence.toArray(startReplacement, lengthReplacement, dest, destOffset + lengthFirstSeq);
        }
        if (sourceOffset + length > this.gapPos + replacementSize) {
            int startSecondSeq = this.gapSize + Math.max(this.gapPos, sourceOffset - replacementSize);
            int lengthSecondSeq = length - lengthFirstSeq - lengthReplacement;
            this.sequence.toArray(startSecondSeq, lengthSecondSeq, dest, destOffset + lengthFirstSeq + lengthReplacement);
        }
    }
}

