/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.zip;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.zip.ZipFileIndexEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileIndex {
    private static final String MIN_CHAR = String.valueOf('\u0000');
    private static final String MAX_CHAR = String.valueOf('\uffff');
    public static final long NOT_MODIFIED = Long.MIN_VALUE;
    private static Map<File, ZipFileIndex> zipFileIndexCache = new HashMap<File, ZipFileIndex>();
    private static ReentrantLock lock = new ReentrantLock();
    private static boolean NON_BATCH_MODE = System.getProperty("nonBatchMode") != null;
    private Map<String, DirectoryEntry> directories = Collections.emptyMap();
    private Set<String> allDirs = Collections.emptySet();
    private File zipFile;
    private long zipFileLastModified = Long.MIN_VALUE;
    private RandomAccessFile zipRandomFile;
    private ZipFileIndexEntry[] entries;
    private boolean readFromIndex = false;
    private File zipIndexFile = null;
    private boolean triedToReadIndex = false;
    private int symbolFilePrefixLength = 0;
    private boolean hasPopulatedData = false;
    private long lastReferenceTimeStamp = Long.MIN_VALUE;
    private boolean usePreindexedCache = false;
    private String preindexedCacheLocation = null;
    private boolean writeIndex = false;
    private static Inflater inflater;

    public static java.util.List<ZipFileIndex> getZipFileIndexes() {
        return ZipFileIndex.getZipFileIndexes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.List<ZipFileIndex> getZipFileIndexes(boolean openedOnly) {
        ArrayList<ZipFileIndex> zipFileIndexes = new ArrayList<ZipFileIndex>();
        lock.lock();
        try {
            zipFileIndexes.addAll(zipFileIndexCache.values());
            if (openedOnly) {
                for (ZipFileIndex elem : zipFileIndexes) {
                    if (elem.isOpen()) continue;
                    zipFileIndexes.remove(elem);
                }
            }
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
        return zipFileIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        lock.lock();
        try {
            boolean bl = this.zipRandomFile != null;
            Object var3_2 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFileIndex getZipFileIndex(File zipFile, int symbolFilePrefixLen, boolean useCache, String cacheLocation, boolean writeIndex) throws IOException {
        ZipFileIndex zi = null;
        lock.lock();
        try {
            zi = ZipFileIndex.getExistingZipIndex(zipFile);
            if (zi == null || zi != null && zipFile.lastModified() != zi.zipFileLastModified) {
                zi = new ZipFileIndex(zipFile, symbolFilePrefixLen, writeIndex, useCache, cacheLocation);
                zipFileIndexCache.put(zipFile, zi);
            }
            Object var7_6 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
        return zi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFileIndex getExistingZipIndex(File zipFile) {
        lock.lock();
        try {
            ZipFileIndex zipFileIndex = zipFileIndexCache.get(zipFile);
            Object var3_2 = null;
            lock.unlock();
            return zipFileIndex;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        lock.lock();
        try {
            zipFileIndexCache.clear();
            Object var1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(long timeNotUsed) {
        lock.lock();
        try {
            for (File cachedFile : zipFileIndexCache.keySet()) {
                long timeToTest;
                ZipFileIndex cachedZipIndex = zipFileIndexCache.get(cachedFile);
                if (cachedZipIndex == null || (timeToTest = cachedZipIndex.lastReferenceTimeStamp + timeNotUsed) >= cachedZipIndex.lastReferenceTimeStamp && System.currentTimeMillis() <= timeToTest) continue;
                zipFileIndexCache.remove(cachedFile);
            }
            Object var8_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromCache(File file) {
        lock.lock();
        try {
            zipFileIndexCache.remove(file);
            Object var2_1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOpenedIndexes(java.util.List<ZipFileIndex> indexes) throws IllegalStateException {
        lock.lock();
        try {
            if (zipFileIndexCache.isEmpty()) {
                throw new IllegalStateException("Setting opened indexes should be called only when the ZipFileCache is empty. Call JavacFileManager.flush() before calling this method.");
            }
            for (ZipFileIndex zfi : indexes) {
                zipFileIndexCache.put(zfi.zipFile, zfi);
            }
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private ZipFileIndex(File zipFile, int symbolFilePrefixLen, boolean writeIndex, boolean useCache, String cacheLocation) throws IOException {
        this.zipFile = zipFile;
        this.symbolFilePrefixLength = symbolFilePrefixLen;
        this.writeIndex = writeIndex;
        this.usePreindexedCache = useCache;
        this.preindexedCacheLocation = cacheLocation;
        if (zipFile != null) {
            this.zipFileLastModified = zipFile.lastModified();
        }
        this.checkIndex();
    }

    public String toString() {
        return "ZipFileIndex of file:(" + this.zipFile + ")";
    }

    protected void finalize() {
        this.closeFile();
    }

    private boolean isUpToDate() {
        return this.zipFile != null && (!NON_BATCH_MODE || this.zipFileLastModified == this.zipFile.lastModified()) && this.hasPopulatedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndex() throws IOException {
        boolean isUpToDate = true;
        if (!this.isUpToDate()) {
            this.closeFile();
            isUpToDate = false;
        }
        if (this.zipRandomFile != null || isUpToDate) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.hasPopulatedData = true;
        if (this.readIndex()) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.directories = Collections.emptyMap();
        this.allDirs = Collections.emptySet();
        try {
            this.openFile();
            long totalLength = this.zipRandomFile.length();
            ZipDirectory directory = new ZipDirectory(this.zipRandomFile, 0L, totalLength, this);
            directory.buildIndex();
            Object var6_4 = null;
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
            throw throwable;
        }
        this.lastReferenceTimeStamp = System.currentTimeMillis();
    }

    private void openFile() throws FileNotFoundException {
        if (this.zipRandomFile == null && this.zipFile != null) {
            this.zipRandomFile = new RandomAccessFile(this.zipFile, "r");
        }
    }

    private void cleanupState() {
        this.entries = ZipFileIndexEntry.EMPTY_ARRAY;
        this.directories = Collections.emptyMap();
        this.zipFileLastModified = Long.MIN_VALUE;
        this.allDirs = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        lock.lock();
        try {
            this.writeIndex();
            this.closeFile();
            Object var2_1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private void closeFile() {
        if (this.zipRandomFile != null) {
            try {
                this.zipRandomFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipRandomFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileIndexEntry getZipIndexEntry(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        lock.lock();
        try {
            this.checkIndex();
            String lookFor = "";
            int lastSepIndex = path.lastIndexOf(File.separatorChar);
            boolean noSeparator = false;
            if (lastSepIndex == -1) {
                noSeparator = true;
            }
            DirectoryEntry de = this.directories.get(noSeparator ? "" : path.substring(0, lastSepIndex));
            lookFor = path.substring(noSeparator ? 0 : lastSepIndex + 1);
            ZipFileIndexEntry zipFileIndexEntry = de == null ? null : de.getEntry(lookFor);
            Object var8_9 = null;
            lock.unlock();
            return zipFileIndexEntry;
        }
        catch (IOException e) {
            try {
                ZipFileIndexEntry zipFileIndexEntry = null;
                Object var8_10 = null;
                lock.unlock();
                return zipFileIndexEntry;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFiles(String path) {
        List ret;
        block6: {
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            lock.lock();
            this.checkIndex();
            DirectoryEntry de = this.directories.get(path);
            List list = ret = de == null ? null : de.getFiles();
            if (ret != null) break block6;
            List<String> list2 = List.nil();
            Object var6_7 = null;
            lock.unlock();
            return list2;
        }
        try {
            List list = ret;
            Object var6_8 = null;
            lock.unlock();
            return list;
        }
        catch (IOException e) {
            try {
                List<String> list = List.nil();
                Object var6_9 = null;
                lock.unlock();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<String> getAllDirectories(String path) {
        List ret;
        block6: {
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            lock.lock();
            this.checkIndex();
            path = path.intern();
            DirectoryEntry de = this.directories.get(path);
            List list = ret = de == null ? null : de.getDirectories();
            if (ret != null) break block6;
            List<String> list2 = List.nil();
            Object var6_7 = null;
            lock.unlock();
            return list2;
        }
        try {
            List list = ret;
            Object var6_8 = null;
            lock.unlock();
            return list;
        }
        catch (IOException e) {
            try {
                List<String> list = List.nil();
                Object var6_9 = null;
                lock.unlock();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllDirectories() {
        lock.lock();
        try {
            Set<String> alldirs;
            this.checkIndex();
            if (this.allDirs == Collections.EMPTY_SET) {
                alldirs = new HashSet<String>();
                Iterator<String> dirsIter = this.directories.keySet().iterator();
                while (dirsIter.hasNext()) {
                    alldirs.add(new String(dirsIter.next()));
                }
                this.allDirs = alldirs;
            }
            alldirs = this.allDirs;
            Object var4_5 = null;
            lock.unlock();
            return alldirs;
        }
        catch (IOException e) {
            try {
                Set<String> set = Collections.emptySet();
                Object var4_6 = null;
                lock.unlock();
                return set;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String path) {
        lock.lock();
        try {
            this.checkIndex();
            boolean bl = this.getZipIndexEntry(path) != null;
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (IOException e) {
            try {
                boolean bl = false;
                Object var5_5 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String path) throws IOException {
        block4: {
            lock.lock();
            try {
                if (path.length() != 0) break block4;
                this.lastReferenceTimeStamp = System.currentTimeMillis();
                boolean bl = true;
                Object var4_4 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        this.checkIndex();
        boolean bl = this.directories.get(path) != null;
        Object var4_5 = null;
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String path) throws IOException {
        lock.lock();
        try {
            ZipFileIndexEntry entry = this.getZipIndexEntry(path);
            if (entry == null) {
                throw new FileNotFoundException();
            }
            long l = entry.getLastModified();
            Object var6_4 = null;
            lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length(String path) throws IOException {
        ZipFileIndexEntry entry;
        block6: {
            block5: {
                lock.lock();
                try {
                    entry = this.getZipIndexEntry(path);
                    if (entry == null) {
                        throw new FileNotFoundException();
                    }
                    if (!entry.isDir) break block5;
                    int n = 0;
                    Object var6_5 = null;
                    lock.unlock();
                    return n;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            byte[] header = this.getHeader(entry);
            if (ZipFileIndex.get2ByteLittleEndian(header, 8) != 0) break block6;
            int n = entry.compressedSize;
            Object var6_6 = null;
            lock.unlock();
            return n;
        }
        int n = entry.size;
        Object var6_7 = null;
        lock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String path) throws IOException {
        lock.lock();
        try {
            ZipFileIndexEntry entry = this.getZipIndexEntry(path);
            if (entry == null) {
                throw new FileNotFoundException(MessageFormat.format("Path not found in ZIP: {0}", path));
            }
            byte[] byArray = this.read(entry);
            Object var5_4 = null;
            lock.unlock();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(ZipFileIndexEntry entry) throws IOException {
        lock.lock();
        try {
            this.openFile();
            byte[] result = this.readBytes(entry);
            this.closeFile();
            byte[] byArray = result;
            Object var5_4 = null;
            lock.unlock();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(String path, byte[] buffer) throws IOException {
        lock.lock();
        try {
            ZipFileIndexEntry entry = this.getZipIndexEntry(path);
            if (entry == null) {
                throw new FileNotFoundException();
            }
            int n = this.read(entry, buffer);
            Object var6_5 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ZipFileIndexEntry entry, byte[] buffer) throws IOException {
        lock.lock();
        try {
            int result;
            int n = result = this.readBytes(entry, buffer);
            Object var6_5 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private byte[] readBytes(ZipFileIndexEntry entry) throws IOException {
        byte[] header = this.getHeader(entry);
        int csize = entry.compressedSize;
        byte[] cbuf = new byte[csize];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(header, 26) + ZipFileIndex.get2ByteLittleEndian(header, 28));
        this.zipRandomFile.readFully(cbuf, 0, csize);
        if (ZipFileIndex.get2ByteLittleEndian(header, 8) == 0) {
            return cbuf;
        }
        int size = entry.size;
        byte[] buf = new byte[size];
        if (this.inflate(cbuf, buf) != size) {
            throw new ZipException("corrupted zip file");
        }
        return buf;
    }

    private int readBytes(ZipFileIndexEntry entry, byte[] buffer) throws IOException {
        byte[] header = this.getHeader(entry);
        if (ZipFileIndex.get2ByteLittleEndian(header, 8) == 0) {
            int count;
            this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(header, 26) + ZipFileIndex.get2ByteLittleEndian(header, 28));
            int size = buffer.length;
            for (int offset = 0; offset < size && (count = this.zipRandomFile.read(buffer, offset, size - offset)) != -1; offset += count) {
            }
            return entry.size;
        }
        int csize = entry.compressedSize;
        byte[] cbuf = new byte[csize];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(header, 26) + ZipFileIndex.get2ByteLittleEndian(header, 28));
        this.zipRandomFile.readFully(cbuf, 0, csize);
        int count = this.inflate(cbuf, buffer);
        if (count == -1) {
            throw new ZipException("corrupted zip file");
        }
        return entry.size;
    }

    private byte[] getHeader(ZipFileIndexEntry entry) throws IOException {
        this.zipRandomFile.seek(entry.offset);
        byte[] header = new byte[30];
        this.zipRandomFile.readFully(header);
        if (ZipFileIndex.get4ByteLittleEndian(header, 0) != 67324752) {
            throw new ZipException("corrupted zip file");
        }
        if ((ZipFileIndex.get2ByteLittleEndian(header, 6) & 1) != 0) {
            throw new ZipException("encrypted zip file");
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int inflate(byte[] src, byte[] dest) {
        if (inflater == null) {
            inflater = new Inflater(true);
        }
        Inflater inflater = ZipFileIndex.inflater;
        synchronized (inflater) {
            ZipFileIndex.inflater.reset();
            ZipFileIndex.inflater.setInput(src);
            try {
                return ZipFileIndex.inflater.inflate(dest);
            }
            catch (DataFormatException ex) {
                return -1;
            }
        }
    }

    private static int get2ByteLittleEndian(byte[] buf, int pos) {
        return (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8);
    }

    private static int get4ByteLittleEndian(byte[] buf, int pos) {
        return (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8) + ((buf[pos + 2] & 0xFF) << 16) + ((buf[pos + 3] & 0xFF) << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZipFileLastModified() throws IOException {
        lock.lock();
        try {
            this.checkIndex();
            long l = this.zipFileLastModified;
            Object var4_2 = null;
            lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean readIndex() {
        if (this.triedToReadIndex || !this.usePreindexedCache) {
            return false;
        }
        ret = false;
        ZipFileIndex.lock.lock();
        try {
            block18: {
                this.triedToReadIndex = true;
                raf = null;
                try {
                    block17: {
                        indexFileName = this.getIndexFile();
                        raf = new RandomAccessFile(indexFileName, "r");
                        fileStamp = raf.readLong();
                        if (this.zipFile.lastModified() != fileStamp) {
                            ret = false;
                            break block17;
                        }
                        this.directories = new HashMap<String, DirectoryEntry>();
                        numDirs = raf.readInt();
                        for (nDirs = 0; nDirs < numDirs; ++nDirs) {
                            dirNameBytesLen = raf.readInt();
                            dirNameBytes = new byte[dirNameBytesLen];
                            raf.read(dirNameBytes);
                            dirNameStr = new String(dirNameBytes, "UTF-8");
                            de = new DirectoryEntry(dirNameStr, this);
                            DirectoryEntry.access$1402(de, raf.readInt());
                            DirectoryEntry.access$1502(de, raf.readLong());
                            this.directories.put(dirNameStr, de);
                        }
                        ret = true;
                        this.zipFileLastModified = fileStamp;
                    }
                    var13_12 = null;
                    ** if (raf == null) goto lbl-1000
                }
                catch (Throwable var12_18) {
                    var13_14 = null;
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable tt) {
                            // empty catch block
                        }
                    }
                    throw var12_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        raf.close();
                    }
                    catch (Throwable tt) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (Throwable var3_4) {
                        var13_13 = null;
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (Throwable tt) {}
                        }
                    }
                }
            }
            if (ret) {
                this.readFromIndex = true;
            }
            var16_19 = null;
            ZipFileIndex.lock.unlock();
        }
        catch (Throwable var15_21) {
            var16_20 = null;
            ZipFileIndex.lock.unlock();
            throw var15_21;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writeIndex() {
        boolean ret;
        block17: {
            ret = false;
            if (this.readFromIndex || !this.usePreindexedCache) {
                return true;
            }
            if (!this.writeIndex) {
                return true;
            }
            File indexFile = this.getIndexFile();
            if (indexFile == null) {
                return false;
            }
            RandomAccessFile raf = null;
            long writtenSoFar = 0L;
            raf = new RandomAccessFile(indexFile, "rw");
            raf.writeLong(this.zipFileLastModified);
            writtenSoFar += 8L;
            Iterator<String> iterDirName = this.directories.keySet().iterator();
            ArrayList<DirectoryEntry> directoriesToWrite = new ArrayList<DirectoryEntry>();
            HashMap<String, Long> offsets = new HashMap<String, Long>();
            raf.writeInt(this.directories.keySet().size());
            writtenSoFar += 4L;
            while (iterDirName.hasNext()) {
                String dirName = iterDirName.next();
                DirectoryEntry dirEntry = this.directories.get(dirName);
                directoriesToWrite.add(dirEntry);
                byte[] dirNameBytes = dirName.getBytes("UTF-8");
                int dirNameBytesLen = dirNameBytes.length;
                raf.writeInt(dirNameBytesLen);
                writtenSoFar += 4L;
                raf.write(dirNameBytes);
                writtenSoFar += (long)dirNameBytesLen;
                java.util.List<ZipFileIndexEntry> dirEntries = dirEntry.getEntriesAsCollection();
                raf.writeInt(dirEntries.size());
                offsets.put(dirName, new Long(writtenSoFar += 4L));
                dirEntry.writtenOffsetOffset = 0L;
                raf.writeLong(0L);
                writtenSoFar += 8L;
            }
            for (DirectoryEntry de : directoriesToWrite) {
                long currFP = raf.getFilePointer();
                long offsetOffset = (Long)offsets.get(de.dirName);
                raf.seek(offsetOffset);
                raf.writeLong(writtenSoFar);
                raf.seek(currFP);
                java.util.List<ZipFileIndexEntry> entries = de.getEntriesAsCollection();
                for (ZipFileIndexEntry zfie : entries) {
                    byte[] zfieNameBytes = zfie.name.getBytes("UTF-8");
                    int zfieNameBytesLen = zfieNameBytes.length;
                    raf.writeInt(zfieNameBytesLen);
                    writtenSoFar += 4L;
                    raf.write(zfieNameBytes);
                    writtenSoFar += (long)zfieNameBytesLen;
                    raf.writeByte(zfie.isDir ? 1 : 0);
                    ++writtenSoFar;
                    raf.writeInt(zfie.offset);
                    writtenSoFar += 4L;
                    raf.writeInt(zfie.size);
                    writtenSoFar += 4L;
                    raf.writeInt(zfie.compressedSize);
                    writtenSoFar += 4L;
                    raf.writeLong(zfie.getLastModified());
                    writtenSoFar += 8L;
                }
            }
            Object var21_21 = null;
            try {
                if (raf != null) {
                    raf.close();
                }
                break block17;
            }
            catch (IOException ioe) {}
            break block17;
            {
                catch (Throwable t) {
                    Object var21_22 = null;
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                        break block17;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeZipIndex() {
        lock.lock();
        try {
            boolean bl = this.writeIndex();
            Object var3_2 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private File getIndexFile() {
        if (this.zipIndexFile == null) {
            if (this.zipFile == null) {
                return null;
            }
            this.zipIndexFile = new File((this.preindexedCacheLocation == null ? "" : this.preindexedCacheLocation) + this.zipFile.getName() + ".index");
        }
        return this.zipIndexFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    static /* synthetic */ ZipFileIndexEntry[] access$602(ZipFileIndex x0, ZipFileIndexEntry[] x1) {
        x0.entries = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DirectoryEntry {
        private boolean filesInited = false;
        private boolean directoriesInited = false;
        private boolean zipFileEntriesInited;
        private boolean entriesInited = false;
        private long writtenOffsetOffset = 0L;
        private String dirName;
        private List<String> zipFileEntriesFiles = List.nil();
        private List<String> zipFileEntriesDirectories = List.nil();
        private List<ZipFileIndexEntry> zipFileEntries = List.nil();
        private java.util.List<ZipFileIndexEntry> entries = new ArrayList<ZipFileIndexEntry>();
        private ZipFileIndex zipFileIndex;
        private int numEntries;

        DirectoryEntry(String dirName, ZipFileIndex index) {
            if (File.separatorChar == '/') {
                dirName.replace('\\', '/');
            } else {
                dirName.replace('/', '\\');
            }
            this.dirName = dirName.intern();
            this.zipFileIndex = index;
        }

        private List<String> getFiles() {
            if (this.filesInited) {
                return this.zipFileEntriesFiles;
            }
            this.initEntries();
            for (ZipFileIndexEntry e : this.entries) {
                if (e.isDir) continue;
                this.zipFileEntriesFiles = this.zipFileEntriesFiles.append(e.name);
            }
            this.filesInited = true;
            return this.zipFileEntriesFiles;
        }

        private List<String> getDirectories() {
            if (this.directoriesInited) {
                return this.zipFileEntriesFiles;
            }
            this.initEntries();
            for (ZipFileIndexEntry e : this.entries) {
                if (!e.isDir) continue;
                this.zipFileEntriesDirectories = this.zipFileEntriesDirectories.append(e.name);
            }
            this.directoriesInited = true;
            return this.zipFileEntriesDirectories;
        }

        private List<ZipFileIndexEntry> getEntries() {
            if (this.zipFileEntriesInited) {
                return this.zipFileEntries;
            }
            this.initEntries();
            this.zipFileEntries = List.nil();
            for (ZipFileIndexEntry zfie : this.entries) {
                this.zipFileEntries = this.zipFileEntries.append(zfie);
            }
            this.zipFileEntriesInited = true;
            return this.zipFileEntries;
        }

        private ZipFileIndexEntry getEntry(String rootName) {
            this.initEntries();
            int index = Collections.binarySearch(this.entries, new ZipFileIndexEntry(this.dirName, rootName));
            if (index < 0) {
                return null;
            }
            return this.entries.get(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void initEntries() {
            block15: {
                block16: {
                    if (this.entriesInited) {
                        return;
                    }
                    if (this.zipFileIndex.readFromIndex) break block16;
                    int from = -Arrays.binarySearch(this.zipFileIndex.entries, new ZipFileIndexEntry(this.dirName, MIN_CHAR)) - 1;
                    int to = -Arrays.binarySearch(this.zipFileIndex.entries, new ZipFileIndexEntry(this.dirName, MAX_CHAR)) - 1;
                    boolean emptyList = false;
                    for (int i = from; i < to; ++i) {
                        this.entries.add(this.zipFileIndex.entries[i]);
                    }
                    break block15;
                }
                File indexFile = this.zipFileIndex.getIndexFile();
                if (indexFile != null) {
                    RandomAccessFile raf = null;
                    raf = new RandomAccessFile(indexFile, "r");
                    raf.seek(this.writtenOffsetOffset);
                    for (int nFiles = 0; nFiles < this.numEntries; ++nFiles) {
                        int zfieNameBytesLen = raf.readInt();
                        byte[] zfieNameBytes = new byte[zfieNameBytesLen];
                        raf.read(zfieNameBytes);
                        String eName = new String(zfieNameBytes, "UTF-8");
                        boolean eIsDir = raf.readByte() != 0;
                        int eOffset = raf.readInt();
                        int eSize = raf.readInt();
                        int eCsize = raf.readInt();
                        long eJavaTimestamp = raf.readLong();
                        ZipFileIndexEntry rfie = new ZipFileIndexEntry(this.dirName, eName);
                        rfie.isDir = eIsDir;
                        rfie.offset = eOffset;
                        rfie.size = eSize;
                        rfie.compressedSize = eCsize;
                        rfie.javatime = eJavaTimestamp;
                        this.entries.add(rfie);
                    }
                    Object var15_18 = null;
                    try {
                        if (raf == null) {
                            raf.close();
                        }
                        break block15;
                    }
                    catch (Throwable t) {}
                    break block15;
                    {
                        catch (Throwable throwable) {
                            Object var15_19 = null;
                            try {
                                if (raf == null) {
                                    raf.close();
                                }
                                break block15;
                            }
                            catch (Throwable t) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_20 = null;
                        try {
                            if (raf == null) {
                                raf.close();
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            this.entriesInited = true;
        }

        java.util.List<ZipFileIndexEntry> getEntriesAsCollection() {
            this.initEntries();
            return this.entries;
        }

        static /* synthetic */ int access$1402(DirectoryEntry x0, int x1) {
            x0.numEntries = x1;
            return x0.numEntries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZipDirectory {
        private String lastDir;
        private int lastStart;
        private int lastLen;
        byte[] zipDir;
        RandomAccessFile zipRandomFile = null;
        ZipFileIndex zipFileIndex = null;

        public ZipDirectory(RandomAccessFile zipRandomFile, long start, long end, ZipFileIndex index) throws IOException {
            this.zipRandomFile = zipRandomFile;
            this.zipFileIndex = index;
            this.findCENRecord(start, end);
        }

        private void findCENRecord(long start, long end) throws IOException {
            long totalLength = end - start;
            int endbuflen = 1024;
            byte[] endbuf = new byte[endbuflen];
            long endbufend = end - start;
            while (endbufend >= 22L) {
                int i;
                if (endbufend < (long)endbuflen) {
                    endbuflen = (int)endbufend;
                }
                long endbufpos = endbufend - (long)endbuflen;
                this.zipRandomFile.seek(start + endbufpos);
                this.zipRandomFile.readFully(endbuf, 0, endbuflen);
                for (i = endbuflen - 22; i >= 0 && (endbuf[i] != 80 || endbuf[i + 1] != 75 || endbuf[i + 2] != 5 || endbuf[i + 3] != 6 || endbufpos + (long)i + 22L + (long)ZipFileIndex.get2ByteLittleEndian(endbuf, i + 20) != totalLength); --i) {
                }
                if (i >= 0) {
                    this.zipDir = new byte[ZipFileIndex.get4ByteLittleEndian(endbuf, i + 12) + 2];
                    this.zipDir[0] = endbuf[i + 10];
                    this.zipDir[1] = endbuf[i + 11];
                    this.zipRandomFile.seek(start + (long)ZipFileIndex.get4ByteLittleEndian(endbuf, i + 16));
                    this.zipRandomFile.readFully(this.zipDir, 2, this.zipDir.length - 2);
                    return;
                }
                endbufend = endbufpos + 21L;
            }
            throw new ZipException("cannot read zip file");
        }

        private void buildIndex() throws IOException {
            int entryCount = ZipFileIndex.get2ByteLittleEndian(this.zipDir, 0);
            ZipFileIndex.access$602(ZipFileIndex.this, new ZipFileIndexEntry[entryCount]);
            if (entryCount > 0) {
                ZipFileIndex.this.directories = new HashMap();
                ArrayList<ZipFileIndexEntry> entryList = new ArrayList<ZipFileIndexEntry>();
                int pos = 2;
                for (int i = 0; i < entryCount; ++i) {
                    pos = this.readEntry(pos, entryList, ZipFileIndex.this.directories);
                }
                Iterator i = ZipFileIndex.this.directories.keySet().iterator();
                while (i.hasNext()) {
                    ZipFileIndexEntry zipFileIndexEntry = new ZipFileIndexEntry((String)i.next());
                    zipFileIndexEntry.isDir = true;
                    entryList.add(zipFileIndexEntry);
                }
                ZipFileIndex.access$602(ZipFileIndex.this, entryList.toArray(new ZipFileIndexEntry[entryList.size()]));
                Arrays.sort(ZipFileIndex.this.entries);
            } else {
                ZipFileIndex.this.cleanupState();
            }
        }

        private int readEntry(int pos, java.util.List<ZipFileIndexEntry> entryList, Map<String, DirectoryEntry> directories) throws IOException {
            int dirStart;
            if (ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos) != 33639248) {
                throw new ZipException("cannot read zip file entry");
            }
            int fileStart = dirStart = pos + 46;
            int fileEnd = fileStart + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 28);
            if (this.zipFileIndex.symbolFilePrefixLength != 0 && fileEnd - fileStart >= ZipFileIndex.this.symbolFilePrefixLength) {
                dirStart += this.zipFileIndex.symbolFilePrefixLength;
                fileStart += this.zipFileIndex.symbolFilePrefixLength;
            }
            for (int index = fileStart; index < fileEnd; ++index) {
                byte nextByte = this.zipDir[index];
                if (nextByte != 92 && nextByte != 47) continue;
                this.zipDir[index] = (byte)File.separatorChar;
                fileStart = index + 1;
            }
            String directory = null;
            if (fileStart == dirStart) {
                directory = "";
            } else if (this.lastDir != null && this.lastLen == fileStart - dirStart - 1) {
                int index = this.lastLen - 1;
                while (this.zipDir[this.lastStart + index] == this.zipDir[dirStart + index]) {
                    if (index == 0) {
                        directory = this.lastDir;
                        break;
                    }
                    --index;
                }
            }
            if (directory == null) {
                this.lastStart = dirStart;
                this.lastLen = fileStart - dirStart - 1;
                this.lastDir = directory = new String(this.zipDir, dirStart, this.lastLen, "UTF-8").intern();
                String tempDirectory = directory;
                while (directories.get(tempDirectory) == null) {
                    directories.put(tempDirectory, new DirectoryEntry(tempDirectory, this.zipFileIndex));
                    int separator = tempDirectory.lastIndexOf(File.separatorChar);
                    if (separator != -1) {
                        tempDirectory = tempDirectory.substring(0, separator);
                        continue;
                    }
                    break;
                }
            } else if (directories.get(directory = directory.intern()) == null) {
                directories.put(directory, new DirectoryEntry(directory, this.zipFileIndex));
            }
            if (fileStart != fileEnd) {
                ZipFileIndexEntry entry = new ZipFileIndexEntry(directory, new String(this.zipDir, fileStart, fileEnd - fileStart, "UTF-8"));
                entry.setNativeTime(ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 12));
                entry.compressedSize = ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 20);
                entry.size = ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 24);
                entry.offset = ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 42);
                entryList.add(entry);
            }
            return pos + 46 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 28) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 30) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 32);
        }
    }
}

