/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.antlr;

import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javafx.antlr.StringLiteralProcessor;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;

public abstract class AbstractGeneratedLexerV4
extends Lexer {
    protected Log log;
    private final BraceQuoteTracker NULL_BQT;
    private BraceQuoteTracker quoteStack;
    static final int CUR_QUOTE_CTX = 0;
    static final int SNG_QUOTE_CTX = 1;
    static final int DBL_QUOTE_CTX = 2;
    int eStringStart;

    protected AbstractGeneratedLexerV4() {
        this.quoteStack = this.NULL_BQT = new BraceQuoteTracker(null, '\'', false);
        this.eStringStart = 0;
    }

    protected AbstractGeneratedLexerV4(CharStream input) {
        super(input);
        this.quoteStack = this.NULL_BQT = new BraceQuoteTracker(null, '\'', false);
        this.eStringStart = 0;
    }

    protected AbstractGeneratedLexerV4(CharStream input, RecognizerSharedState state) {
        super(input, state);
        this.quoteStack = this.NULL_BQT = new BraceQuoteTracker(null, '\'', false);
        this.eStringStart = 0;
    }

    void processString() {
        this.setText(StringLiteralProcessor.convert(this.log, this.getCharIndex(), this.getText()));
    }

    void processFormatString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"').append(this.getText()).append('\"');
        this.setText(StringLiteralProcessor.convert(this.log, this.getCharIndex() + 1, sb.toString()));
    }

    void processTranslationKey() {
        String text = this.getText().substring(2);
        if (text.length() > 0) {
            text = StringLiteralProcessor.convert(this.log, this.getCharIndex(), text);
        }
        this.setText(text);
    }

    protected void enterBrace(int quote, boolean nextIsPercent) {
        this.quoteStack.enterBrace(quote, nextIsPercent);
    }

    protected void leaveQuote() {
        this.quoteStack.leaveQuote();
    }

    protected boolean rightBraceLikeQuote(int quote) {
        return this.quoteStack.rightBraceLikeQuote(quote);
    }

    protected void leaveBrace() {
        this.quoteStack.leaveBrace();
    }

    protected boolean percentIsFormat() {
        return this.quoteStack.percentIsFormat();
    }

    protected void resetPercentIsFormat() {
        this.quoteStack.resetPercentIsFormat();
    }

    protected int getLexicalState() {
        return this.quoteStack.getLexicalState();
    }

    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        StringBuffer mb = new StringBuffer();
        if (e instanceof NoViableAltException) {
            if (e.c == -1) {
                mb.append("Sorry, I scanned to the end of your script from around line " + e.line + " but could not see how to process it. ");
                mb.append("This can happen if you forget a closing delimiter such as ''' '\"' or '{'");
            } else {
                mb.append("Sorry, but the character " + this.getCharErrorDisplay(e.c));
                mb.append("is not allowed in a JavaFX script. Well at least, not here.");
            }
        } else {
            mb.append(super.getErrorMessage(e, tokenNames));
        }
        return mb.toString();
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
        String msg = this.getErrorMessage(e, tokenNames);
        this.log.error(this.getCharIndex(), "javafx.generalerror", msg);
    }

    protected boolean checkIntLiteralRange(String text, int pos, int radix, boolean negative) {
        long value = 0L;
        pos = pos - text.length() - (negative ? 1 : 0);
        try {
            value = Convert.string2int(text, radix);
        }
        catch (Exception e) {
            if (negative) {
                this.log.error(pos, "javafx.lexer.literal.range", "small", new String("-" + text));
            } else {
                this.log.error(pos, "javafx.lexer.literal.range", "big", text);
            }
            return false;
        }
        return true;
    }

    protected class BraceQuoteTracker {
        private int braceDepth;
        private char quote;
        private boolean percentIsFormat;
        private BraceQuoteTracker next;

        private BraceQuoteTracker(BraceQuoteTracker prev, char quote, boolean percentIsFormat) {
            this.quote = quote;
            this.percentIsFormat = percentIsFormat;
            this.braceDepth = 1;
            this.next = prev;
        }

        void enterBrace(int quote, boolean percentIsFormat) {
            if (quote == 0) {
                if (AbstractGeneratedLexerV4.this.quoteStack != AbstractGeneratedLexerV4.this.NULL_BQT) {
                    ++((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.braceDepth;
                    ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.percentIsFormat = percentIsFormat;
                }
            } else {
                AbstractGeneratedLexerV4.this.quoteStack = new BraceQuoteTracker(AbstractGeneratedLexerV4.this.quoteStack, (char)quote, percentIsFormat);
            }
        }

        char leaveBrace() {
            if (AbstractGeneratedLexerV4.this.quoteStack != AbstractGeneratedLexerV4.this.NULL_BQT && --((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.braceDepth == 0) {
                return ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.quote;
            }
            return '\u0000';
        }

        boolean rightBraceLikeQuote(int quote) {
            return AbstractGeneratedLexerV4.this.quoteStack != AbstractGeneratedLexerV4.this.NULL_BQT && ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.braceDepth == 1 && (quote == 0 || ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.quote == (char)quote);
        }

        void leaveQuote() {
            assert (AbstractGeneratedLexerV4.this.quoteStack != AbstractGeneratedLexerV4.this.NULL_BQT && ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.braceDepth == 0);
            AbstractGeneratedLexerV4.this.quoteStack = ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.next;
        }

        boolean percentIsFormat() {
            return AbstractGeneratedLexerV4.this.quoteStack != AbstractGeneratedLexerV4.this.NULL_BQT && ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.percentIsFormat;
        }

        void resetPercentIsFormat() {
            ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.percentIsFormat = false;
        }

        boolean inBraceQuote() {
            return AbstractGeneratedLexerV4.this.quoteStack != AbstractGeneratedLexerV4.this.NULL_BQT;
        }

        int getLexicalState() {
            return AbstractGeneratedLexerV4.this.quoteStack == AbstractGeneratedLexerV4.this.NULL_BQT ? 0 : ((AbstractGeneratedLexerV4)AbstractGeneratedLexerV4.this).quoteStack.braceDepth;
        }
    }
}

